/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.data;

import com.medsal15.ESDamageTypes;
import com.medsal15.data.DataMapGenerator;
import com.medsal15.data.ESBlockStateProvider;
import com.medsal15.data.ESBlockTags;
import com.medsal15.data.ESEntityTypeTags;
import com.medsal15.data.ESItemModelProvider;
import com.medsal15.data.ESItemTags;
import com.medsal15.data.ESLangProvider;
import com.medsal15.data.ESRecipeProvider;
import com.medsal15.data.ESSoundDefinitions;
import com.medsal15.data.loot_tables.ESBlockLootSubProvider;
import com.medsal15.data.loot_tables.ESGLMProvider;
import com.medsal15.data.loot_tables.ESLootSubProvider;
import com.medsal15.data.loot_tables.ESLootTableProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="extrastuck", bus=EventBusSubscriber.Bus.MOD)
public final class ESData {
    @SubscribeEvent
    public static final void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeClient(), (DataProvider)new ESLangProvider(output));
        gen.addProvider(event.includeClient(), (DataProvider)new ESBlockStateProvider(output, fileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new ESItemModelProvider(output, fileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new ESSoundDefinitions(output, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, bootstrap -> {
            bootstrap.register(ESDamageTypes.CAPTAIN_JUSTICE_PROJECTILE, (Object)new DamageType(ESDamageTypes.CAPTAIN_JUSTICE_PROJECTILE.location().toString(), DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.1f, DamageEffects.HURT, DeathMessageType.DEFAULT));
            bootstrap.register(ESDamageTypes.THORN_SHIELD, (Object)new DamageType(ESDamageTypes.THORN_SHIELD.location().toString(), DamageScaling.NEVER, 0.1f, DamageEffects.THORNS, DeathMessageType.DEFAULT));
        }), Set.of("extrastuck")));
        ESBlockTags blocktags = (ESBlockTags)gen.addProvider(event.includeServer(), (DataProvider)new ESBlockTags(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ESRecipeProvider(output, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new ESItemTags(output, lookupProvider, blocktags.contentsGetter(), fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new DataMapGenerator(output, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new ESEntityTypeTags(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), o -> new ESLootTableProvider(o, lookupProvider, List.of(new LootTableProvider.SubProviderEntry(ESBlockLootSubProvider::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(ESLootSubProvider::new, LootContextParamSets.CHEST))));
        gen.addProvider(event.includeServer(), (DataProvider)new ESGLMProvider(output, lookupProvider));
    }
}

