/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.data;

import com.medsal15.ExtraStuck;
import com.medsal15.items.ESItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public final class ESItemModelProvider
extends ItemModelProvider {
    public ESItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "extrastuck", existingFileHelper);
    }

    protected void registerModels() {
        this.registerShields();
        this.registerMeleeWeapons();
        this.registerRangedWeapons();
        this.registerAmmo();
        this.registerArmors();
        this.registerModus();
        this.registerTools();
        this.registerBlocks();
        this.basicItem((Item)ESItems.LUCK_TOKEN.get());
        this.basicItem((Item)ESItems.PIZZA.get());
    }

    private void registerShields() {
        this.modelShield(ESItems.WOODEN_SHIELD);
        this.modelThinShield(ESItems.FLAME_SHIELD);
        this.modelShield(ESItems.LIGHT_SHIELD);
        this.modelThinShield(ESItems.HALT_SHIELD);
        this.modelThinShield(ESItems.NON_CONTACT_CONTRACT);
        this.basicItem(ESItems.SLIED.getId());
        this.modelLargeShield(ESItems.RIOT_SHIELD);
        this.modelRoundShield(ESItems.CAPTAIN_JUSTICE_THROWABLE_SHIELD);
        this.basicItem((Item)ESItems.CAPTAIN_JUSTICE_SHIELD_THROWABLE.get());
        this.modelShield(ESItems.CAPITASHIELD);
        this.modelShield(ESItems.IRON_SHIELD);
        this.modelShield(ESItems.GOLD_SHIELD);
        this.modelShield(ESItems.FLUX_SHIELD);
        this.modelShield(ESItems.DIAMOND_SHIELD);
        this.modelShield(ESItems.NETHERITE_SHIELD);
        this.modelShield(ESItems.GARNET_SHIELD);
        this.modelShield(ESItems.POGO_SHIELD);
        this.modelShield(ESItems.RETURN_TO_SENDER);
    }

    private void modelShield(DeferredItem<Item> shield, String texture, String base) {
        String id = shield.getId().toString();
        ItemModelBuilder blocking = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id + "_blocking", this.modLoc(base + "_blocking"))).texture("0", this.modLoc(texture))).texture("particle", this.modLoc(texture));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id, this.modLoc(base))).texture("0", this.modLoc(texture))).texture("particle", this.modLoc(texture))).override().predicate(ResourceLocation.withDefaultNamespace((String)"blocking"), 1.0f).model((ModelFile)blocking);
    }

    private void modelShield(DeferredItem<Item> shield, String texture) {
        this.modelShield(shield, texture, "base_shield");
    }

    private void modelShield(DeferredItem<Item> shield) {
        String path = shield.getId().getPath().toString();
        this.modelShield(shield, "item/" + path);
    }

    private void modelThinShield(DeferredItem<Item> shield) {
        String path = shield.getId().getPath().toString();
        this.modelShield(shield, "item/" + path, "thin_shield");
    }

    private void modelLargeShield(DeferredItem<Item> shield) {
        String path = shield.getId().getPath().toString();
        this.modelShield(shield, "item/" + path, "large_shield");
    }

    private void modelRoundShield(DeferredItem<Item> shield) {
        String path = shield.getId().getPath().toString();
        this.modelShield(shield, "item/" + path, "round_shield");
    }

    private void registerAmmo() {
        this.basicItem((Item)ESItems.FLAME_ARROW.get());
        this.basicItem((Item)ESItems.NETHER_ARROW.get());
        this.basicItem((Item)ESItems.CARDBOARD_ARROW.get());
        this.basicItem((Item)ESItems.MISSED_YOU.get());
        this.basicItem((Item)ESItems.SWEET_TOOTH.get());
        this.basicItem((Item)ESItems.LIGHTNING_ARROW.get());
        this.basicItem((Item)ESItems.EXPLOSIVE_ARROW.get());
        this.basicItem((Item)ESItems.IRON_ARROW.get());
        this.basicItem((Item)ESItems.QUARTZ_ARROW.get());
        this.basicItem((Item)ESItems.PRISMARINE_ARROW.get());
        this.basicItem((Item)ESItems.GLASS_ARROW.get());
        this.basicItem((Item)ESItems.AMETHYST_ARROW.get());
        this.basicItem((Item)ESItems.PROJECDRILL.get());
        this.basicItem((Item)ESItems.CRUSADER_CROSSBOLT.get());
        this.basicItem((Item)ESItems.END_ARROW.get());
        this.basicItem((Item)ESItems.TELERROW.get());
        this.basicItem((Item)ESItems.DRAGON_ARROW.get());
        this.basicItem((Item)ESItems.HANDGUN_BULLET.get());
        this.basicItem((Item)ESItems.HEAVY_HANDGUN_BULLET.get());
    }

    private void modelDie(DeferredItem<Item> die, String path) {
        String id = die.getId().toString();
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id, this.modLoc("base_die"))).texture("1", (String)path + "one")).texture("2", (String)path + "two")).texture("3", (String)path + "three")).texture("4", (String)path + "four")).texture("5", (String)path + "five")).texture("6", (String)path + "six");
    }

    private void knifeWeapon(DeferredItem<Item> knife) {
        String path = knife.getId().getPath().toString();
        ((ItemModelBuilder)this.withExistingParent(path, ExtraStuck.modid("item/knife_weapon"))).texture("layer0", ExtraStuck.modid("item/" + path));
    }

    private void registerMeleeWeapons() {
        this.handheldItem((Item)ESItems.GEM_BREAKER.get());
        this.handheldItem((Item)ESItems.GOLD_COIN.get());
        this.modelDie(ESItems.D_ICE, "item/dice/ice");
        this.handheldItem((Item)ESItems.TOKEN_TETRAHEDRON.get());
        this.knifeWeapon(ESItems.SLICE_AND_DICE);
        this.handheldItem((Item)ESItems.DONE.get());
        this.handheldItem((Item)ESItems.D10.get());
        this.handheldItem((Item)ESItems.RAINBOW_D7.get());
        this.handheldItem((Item)ESItems.D8_NIGHT.get());
        this.handheldItem((Item)ESItems.CAN_DIE.get());
        this.handheldItem((Item)ESItems.INFINI_DIE.get());
        this.handheldItem((Item)ESItems.SILVER_BAT.get());
        this.handheldItem((Item)ESItems.GOLDEN_PAN.get());
        this.handheldItem((Item)ESItems.ROLLING_PIN.get());
        this.handheldItem((Item)ESItems.KEY_OF_TRIALS.get());
        this.handheldItem((Item)ESItems.KEY_OF_OMINOUS_TRIALS.get());
        this.handheldItem((Item)ESItems.OFFICE_KEY.get());
        this.handheldItem((Item)ESItems.BAGUETTE_MAGIQUE.get());
        this.handheldItem((Item)ESItems.BROOM.get());
        this.handheldItem((Item)ESItems.MAGNEFORK.get());
        this.handheldItem((Item)ESItems.OVERCHARGED_MAGNEFORK.get());
        this.handheldItem((Item)ESItems.UNDERCHARGED_MAGNEFORK.get());
    }

    private void registerRangedWeapons() {
        this.handheldItem((Item)ESItems.HANDGUN.get());
    }

    private void registerArmors() {
        this.basicItem((Item)ESItems.CHEF_HAT.get());
        this.basicItem((Item)ESItems.CHEF_APRON.get());
        this.basicItem((Item)ESItems.HEAVY_BOOTS.get());
        this.basicItem((Item)ESItems.PROPELLER_HAT.get());
    }

    private void registerModus() {
        this.basicItem((Item)ESItems.PILE_MODUS_CARD.get());
        this.basicItem((Item)ESItems.FORTUNE_MODUS_CARD.get());
        this.basicItem((Item)ESItems.ORE_MODUS_CARD.get());
        this.basicItem((Item)ESItems.ARCHEOLOGY_MODUS_CARD.get());
        this.basicItem((Item)ESItems.VOID_MODUS_CARD.get());
        this.basicItem((Item)ESItems.FORTUNE_COOKIE.get());
        this.withExistingParent(ESItems.CARD_ORE.getId().toString(), this.modLoc("block/card_ore"));
    }

    private void registerTools() {
        this.basicItem((Item)ESItems.MAGNET.get());
    }

    private void registerBlocks() {
        this.withExistingParent(ESItems.CUT_GARNET.getId().toString(), this.modLoc("block/cut_garnet"));
        this.withExistingParent(ESItems.CUT_GARNET_STAIRS.getId().toString(), this.modLoc("block/cut_garnet_stairs"));
        this.withExistingParent(ESItems.CUT_GARNET_SLAB.getId().toString(), this.modLoc("block/cut_garnet_slab"));
        this.wallInventory(ESItems.CUT_GARNET_WALL.getId().toString(), this.modLoc("block/cut_garnet"));
        this.withExistingParent(ESItems.GARNET_BRICKS.getId().toString(), this.modLoc("block/garnet_bricks"));
        this.withExistingParent(ESItems.GARNET_BRICK_STAIRS.getId().toString(), this.modLoc("block/garnet_brick_stairs"));
        this.withExistingParent(ESItems.GARNET_BRICK_SLAB.getId().toString(), this.modLoc("block/garnet_brick_slab"));
        this.wallInventory(ESItems.GARNET_BRICK_WALL.getId().toString(), this.modLoc("block/garnet_bricks"));
        this.withExistingParent(ESItems.CHISELED_GARNET_BRICKS.getId().toString(), this.modLoc("block/chiseled_garnet_bricks"));
        this.withExistingParent(ESItems.CUT_RUBY.getId().toString(), this.modLoc("block/cut_ruby"));
        this.withExistingParent(ESItems.CUT_RUBY_STAIRS.getId().toString(), this.modLoc("block/cut_ruby_stairs"));
        this.withExistingParent(ESItems.CUT_RUBY_SLAB.getId().toString(), this.modLoc("block/cut_ruby_slab"));
        this.wallInventory(ESItems.CUT_RUBY_WALL.getId().toString(), this.modLoc("block/cut_ruby"));
        this.withExistingParent(ESItems.RUBY_BRICKS.getId().toString(), this.modLoc("block/ruby_bricks"));
        this.withExistingParent(ESItems.RUBY_BRICK_STAIRS.getId().toString(), this.modLoc("block/ruby_brick_stairs"));
        this.withExistingParent(ESItems.RUBY_BRICK_SLAB.getId().toString(), this.modLoc("block/ruby_brick_slab"));
        this.wallInventory(ESItems.RUBY_BRICK_WALL.getId().toString(), this.modLoc("block/ruby_bricks"));
        this.withExistingParent(ESItems.CHISELED_RUBY_BRICKS.getId().toString(), this.modLoc("block/chiseled_ruby_bricks"));
        this.withExistingParent(ESItems.COBALT_BLOCK.getId().toString(), this.modLoc("block/cobalt_block"));
        this.basicItem((Item)ESItems.COBALT_DOOR.get());
        this.trapdoorBottom(ESItems.COBALT_TRAPDOOR.getId().toString(), this.modLoc("block/cobalt_trapdoor"));
        this.pressurePlate(ESItems.COBALT_PRESSURE_PLATE.getId().toString(), this.modLoc("block/cobalt_block"));
        this.withExistingParent(ESItems.SULFUROUS_STONE.getId().toString(), this.modLoc("block/sulfurous_stone"));
        this.withExistingParent(ESItems.SULFUROUS_STONE_STAIRS.getId().toString(), this.modLoc("block/sulfurous_stone_stairs"));
        this.withExistingParent(ESItems.SULFUROUS_STONE_SLAB.getId().toString(), this.modLoc("block/sulfurous_stone_slab"));
        this.wallInventory(ESItems.SULFUROUS_STONE_WALL.getId().toString(), this.modLoc("block/sulfurous_stone"));
        this.withExistingParent(ESItems.MARBLE.getId().toString(), this.modLoc("block/marble"));
        this.withExistingParent(ESItems.MARBLE_STAIRS.getId().toString(), this.modLoc("block/marble_stairs"));
        this.withExistingParent(ESItems.MARBLE_SLAB.getId().toString(), this.modLoc("block/marble_slab"));
        this.wallInventory(ESItems.MARBLE_WALL.getId().toString(), this.modLoc("block/marble"));
        this.withExistingParent(ESItems.POLISHED_MARBLE.getId().toString(), this.modLoc("block/polished_marble"));
        this.withExistingParent(ESItems.POLISHED_MARBLE_STAIRS.getId().toString(), this.modLoc("block/polished_marble_stairs"));
        this.withExistingParent(ESItems.POLISHED_MARBLE_SLAB.getId().toString(), this.modLoc("block/polished_marble_slab"));
        this.wallInventory(ESItems.POLISHED_MARBLE_WALL.getId().toString(), this.modLoc("block/polished_marble"));
        this.withExistingParent(ESItems.MARBLE_BRICKS.getId().toString(), this.modLoc("block/marble_bricks"));
        this.withExistingParent(ESItems.MARBLE_BRICK_STAIRS.getId().toString(), this.modLoc("block/marble_brick_stairs"));
        this.withExistingParent(ESItems.MARBLE_BRICK_SLAB.getId().toString(), this.modLoc("block/marble_brick_slab"));
        this.wallInventory(ESItems.MARBLE_BRICK_WALL.getId().toString(), this.modLoc("block/marble_bricks"));
        this.withExistingParent(ESItems.ZILLIUM_BRICKS.getId().toString(), this.modLoc("block/zillium_bricks"));
        this.withExistingParent(ESItems.ZILLIUM_BRICK_STAIRS.getId().toString(), this.modLoc("block/zillium_brick_stairs"));
        this.withExistingParent(ESItems.ZILLIUM_BRICK_SLAB.getId().toString(), this.modLoc("block/zillium_brick_slab"));
        this.wallInventory(ESItems.ZILLIUM_BRICK_WALL.getId().toString(), this.modLoc("block/zillium_bricks"));
    }
}

