/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.data;

import com.medsal15.ESDamageTypes;
import com.medsal15.blocks.ESBlocks;
import com.medsal15.data.ESItemTags;
import com.medsal15.entities.ESEntities;
import com.medsal15.items.ESItems;
import com.medsal15.mobeffects.ESMobEffects;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;

public final class ESLangProvider
extends LanguageProvider {
    public static final String SHIELD_DAMAGE_KEY = "extrastuck.shield_damage";
    public static final String SHIELD_EFFECT_KEY = "extrastuck.shield_effect";
    public static final String SHIELD_SELF_EFFECT_KEY = "extrastuck.shield_self_effect";
    public static final String SLIED_DROP_KEY = ((Item)ESItems.SLIED.get()).getDescriptionId() + ".drop";
    public static final String DONE_DROP_KEY = ((Item)ESItems.DONE.get()).getDescriptionId() + ".drop_message";
    public static final String GIFT_PROTECTION_GIFT_KEY = ((Item)ESItems.GIFT_OF_PROTECTION.get()).getDescriptionId() + ".gift_drop";
    public static final String TOKEN_TETRAHEDRON_TOKEN_KEY = ((Item)ESItems.TOKEN_TETRAHEDRON.get()).getDescriptionId() + ".token_drop";
    public static final String GOLDEN_PAN_HIT = "sound.extrastuck.golden_pan_hit";
    public static final String GUN_CONTENT_KEY = "extrastuck.gun_content";
    public static final String GUN_EMPTY_KEY = "extrastuck.gun_empty";
    public static final String ALT_GUN_EMPTY_KEY = "extrastuck.office_key.empty";
    public static final String ALT_GUN_HEAVY_KEY = "extrastuck.office_key.heavy";
    public static final String ENERGY_STORAGE_KEY = "extrastuck.energy_storage";
    public static final String INNATE_ENCHANT_KEY = "extrastuck.innate_enchant";
    public static final String INNATE_ENCHANTS_KEY = "extrastuck.innate_enchants";

    public ESLangProvider(PackOutput output) {
        super(output, "extrastuck", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.extrastuck", "ExtraStuck");
        this.add(SHIELD_DAMAGE_KEY, "Deals %s damage to melee attackers");
        this.add(SHIELD_EFFECT_KEY, "Applies %s (%s) to melee attackers");
        this.add(SHIELD_SELF_EFFECT_KEY, "Applies %s (%s) when attacked");
        this.add(ENERGY_STORAGE_KEY, "%s / %s FE");
        this.add(INNATE_ENCHANT_KEY, "+1 level to %2$s");
        this.add(INNATE_ENCHANTS_KEY, "+%1$s levels to %2$s");
        this.add(GUN_CONTENT_KEY, "Loaded with %1$s %2$s");
        this.add(GUN_EMPTY_KEY, "Unloaded");
        this.add(ALT_GUN_EMPTY_KEY, "It feels strangely hollow...");
        this.add(ALT_GUN_HEAVY_KEY, "It feels weirdly heavy...");
        this.add(GOLDEN_PAN_HIT, "Golden Pan Strike");
        this.add("patchouli.extrastuck.title", "ExtraStuck Guide");
        this.add("patchouli.extrastuck.landing", "Unofficial ExtraStuck Walkthrough (100%% official)");
        this.addShields();
        this.addArrows();
        this.addWeapons();
        this.addArmors();
        this.addModuses();
        this.addBlocks();
        this.addTools();
        this.addTags();
        this.addEffect((Supplier)ESMobEffects.TIME_STOP, "Time Stop");
        this.addEffectDescription((Supplier<? extends MobEffect>)ESMobEffects.TIME_STOP, "Prevents most movement");
        this.addItem((Supplier)ESItems.GIFT, "Gift");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.GIFT, "\"For you\"");
        this.addItem((Supplier)ESItems.ANTI_DIE, "Anti Die");
        this.addItem((Supplier)ESItems.LUCK_TOKEN, "Luck Token");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.LUCK_TOKEN, "Just holding this makes you feel lucky!");
        this.addItem((Supplier)ESItems.PIZZA, "Pizza");
        this.addDeathMessages(ESDamageTypes.CAPTAIN_JUSTICE_PROJECTILE, "%1$s was shot by %2$s", "%1$s was shot by %2$s with %3$s");
        this.addDeathMessages(ESDamageTypes.THORN_SHIELD, "%1$s struck %2$s's shield too hard", "%1$s struck %2$s's %3$s too hard");
    }

    private void addShields() {
        this.addItem((Supplier)ESItems.WOODEN_SHIELD, "Wooden Shield");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.WOODEN_SHIELD, "This cheap shield is 100% fire-ready");
        this.addItem((Supplier)ESItems.FLAME_SHIELD, "Flame Shield");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.FLAME_SHIELD, "Uh oh, it seems your wooden shield is burning!");
        this.addItem((Supplier)ESItems.HALT_SHIELD, "Halt Shield");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.HALT_SHIELD, "Forces your enemies to turn back");
        this.addItem((Supplier)ESItems.LIGHT_SHIELD, "Light Shield");
        this.addItem((Supplier)ESItems.NON_CONTACT_CONTRACT, "Non-Contact Contract");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.NON_CONTACT_CONTRACT, "This piece of paper has the ability to prevent contact with you");
        this.addItem((Supplier)ESItems.GIFT_OF_PROTECTION, "Gift of Protection");
        this.add(GIFT_PROTECTION_GIFT_KEY, "You found a gift!");
        this.addItem((Supplier)ESItems.SLIED, "slied");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.SLIED, "Can this even block damage?");
        this.add(SLIED_DROP_KEY, "Expectedly, it could not");
        this.addItem((Supplier)ESItems.RIOT_SHIELD, "Riot Shield");
        this.addItem((Supplier)ESItems.CAPTAIN_JUSTICE_SHIELD_THROWABLE, "Captain Justice's Shield Throwable");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.CAPTAIN_JUSTICE_SHIELD_THROWABLE, "Straight from a comic book and ready to throw down!");
        this.addItem((Supplier)ESItems.CAPTAIN_JUSTICE_THROWABLE_SHIELD, "Captain Justice's Throwable Shield");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.CAPTAIN_JUSTICE_THROWABLE_SHIELD, "Straight from a comic book and ready to protect!");
        this.addEntityType(ESEntities.CAPTAIN_JUSTICE_SHIELD, "Captain Justice Shield");
        this.addItem((Supplier)ESItems.CAPITASHIELD, "Capitashield");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.CAPITASHIELD, "Protects you, at a cost");
        this.addItem((Supplier)ESItems.IRON_SHIELD, "Iron Shield");
        this.addItem((Supplier)ESItems.SPIKES_ON_A_SLAB, "Spikes on a Slab");
        this.addItem((Supplier)ESItems.JAWBITER, "Jawbiter");
        this.addItem((Supplier)ESItems.ELDRITCH_SHIELD, "Eldritch Shield");
        this.addItem((Supplier)ESItems.GOLD_SHIELD, "Gold Shield");
        this.addItem((Supplier)ESItems.FLUX_SHIELD, "Flux Shield");
        this.addItem((Supplier)ESItems.DIAMOND_SHIELD, "Diamond Shield");
        this.addItem((Supplier)ESItems.NETHERITE_SHIELD, "Netherite Shield");
        this.addItem((Supplier)ESItems.GARNET_SHIELD, "Garnet Shield");
        this.addItem((Supplier)ESItems.POGO_SHIELD, "Pogo Shield");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.POGO_SHIELD, "The shield that bounces back!");
        this.addItem((Supplier)ESItems.RETURN_TO_SENDER, "Return to Sender");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.RETURN_TO_SENDER, "The shield that shoots back!");
    }

    private void addArrows() {
        this.addItem((Supplier)ESItems.NETHER_ARROW, "Nether Arrow");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.NETHER_ARROW, "Likes the heat");
        this.addEntityType(ESEntities.NETHER_ARROW, "Nether Arrow");
        this.addItem((Supplier)ESItems.FLAME_ARROW, "Flame Arrow");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.FLAME_ARROW, "Extra hot");
        this.addEntityType(ESEntities.FLAME_ARROW, "Flame Arrow");
        this.addItem((Supplier)ESItems.CARDBOARD_ARROW, "Cardboard Arrow");
        this.addEntityType(ESEntities.CARDBOARD_ARROW, "Cardboard Arrow");
        this.addItem((Supplier)ESItems.MISSED_YOU, "missed you");
        this.addEntityType(ESEntities.MISSED_ARROW, "Missed Arrow");
        this.addItem((Supplier)ESItems.SWEET_TOOTH, "Sweet Tooth");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.SWEET_TOOTH, "Delicious and dangerous!");
        this.addEntityType(ESEntities.CANDY_ARROW, "Sweet Tooth");
        this.addItem((Supplier)ESItems.LIGHTNING_ARROW, "Lightning Bolt");
        this.addEntityType(ESEntities.LIGHTNING_ARROW, "Lighting Arrow");
        this.addItem((Supplier)ESItems.EXPLOSIVE_ARROW, "Explosive Arrow");
        this.addEntityType(ESEntities.EXPLOSIVE_ARROW, "Explosive Arrow");
        this.addItem((Supplier)ESItems.IRON_ARROW, "Iron Arrow");
        this.addEntityType(ESEntities.IRON_ARROW, "Iron Arrow");
        this.addItem((Supplier)ESItems.QUARTZ_ARROW, "Quartz Arrow");
        this.addEntityType(ESEntities.QUARTZ_ARROW, "Quartz Arrow");
        this.addItem((Supplier)ESItems.PRISMARINE_ARROW, "Prismarine Arrow");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.PRISMARINE_ARROW, "Best swimmer in class");
        this.addEntityType(ESEntities.PRISMARINE_ARROW, "Prismarine Arrow");
        this.addItem((Supplier)ESItems.GLASS_ARROW, "Glass Arrow");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.GLASS_ARROW, "Fragile");
        this.addEntityType(ESEntities.GLASS_ARROW, "Glass Arrow");
        this.addItem((Supplier)ESItems.AMETHYST_ARROW, "Amethyst Arrow");
        this.addEntityType(ESEntities.AMETHYST_ARROW, "Amethyst Arrow");
        this.addItem((Supplier)ESItems.PROJECDRILL, "Projecdrill");
        this.addEntityType(ESEntities.MINING_ARROW, "Mining Arrow");
        this.addItem((Supplier)ESItems.CRUSADER_CROSSBOLT, "Crusader's Crossbolt");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.CRUSADER_CROSSBOLT, "After nine years in development, hopefully it will have been worth the wait...");
        this.addEntityType(ESEntities.HEALING_ARROW, "Healing Arrow");
        this.addItem((Supplier)ESItems.END_ARROW, "End Arrow");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.END_ARROW, "Hates flying");
        this.addEntityType(ESEntities.END_ARROW, "End Arrow");
        this.addItem((Supplier)ESItems.TELERROW, "Telerrow");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.TELERROW, "Now you're over there");
        this.addEntityType(ESEntities.TELEPORT_ARROW, "Teleport Arrow");
        this.addItem((Supplier)ESItems.DRAGON_ARROW, "Dragon Arrow");
        this.addEntityType(ESEntities.DRAGON_ARROW, "Dragon Arrow");
    }

    private void addWeapons() {
        this.addItem((Supplier)ESItems.GEM_BREAKER, "Gem Breaker");
        this.addItem((Supplier)ESItems.BELL_HAMMER, "Bell Hammer");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.BELL_HAMMER, "It rings with every strike");
        this.addItem((Supplier)ESItems.BLIND_HAMMER, "Blind Hammer");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.BLIND_HAMMER, "With you in the dark");
        this.addItem((Supplier)ESItems.GOLD_COIN, "Gold Coin");
        this.addItem((Supplier)ESItems.STICKY_DIE, "Sticky Die");
        this.addItem((Supplier)ESItems.TOKEN_TETRAHEDRON, "Token Tetrahedron");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.TOKEN_TETRAHEDRON, "Jackpot");
        this.add(TOKEN_TETRAHEDRON_TOKEN_KEY, "The enemy droped a token!");
        this.addItem((Supplier)ESItems.D_ICE, "D-Ice");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.D_ICE, "Only for the coolest rollers");
        this.addItem((Supplier)ESItems.SLICE_AND_DICE, "Slice and Dice");
        this.addItem((Supplier)ESItems.DONE, "D1");
        this.addItemExtra((Supplier<? extends Item>)ESItems.DONE, "drop_message", "You dropped down your d1");
        this.addItem((Supplier)ESItems.D10, "D10");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.D10, "The power of the World, in a die");
        this.addItem((Supplier)ESItems.RAINBOW_D7, "Rainbow D7");
        this.addItem((Supplier)ESItems.D8_NIGHT, "D8 Night");
        this.addItem((Supplier)ESItems.CAN_DIE, "Can-Die");
        this.addItem((Supplier)ESItems.INFINI_DIE, "Infini-Die");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.INFINI_DIE, "Theorically infinite damage output");
        this.addItem((Supplier)ESItems.SILVER_BAT, "Silver Bat");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.SILVER_BAT, "Purify all your enemies");
        this.addItem((Supplier)ESItems.GOLDEN_PAN, "Golden Pan");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.GOLDEN_PAN, "A valuable frying pan, extremely rarely found in lootbo- gifts.");
        this.addItem((Supplier)ESItems.ROLLING_PIN, "Rolling Pin");
        this.addItem((Supplier)ESItems.KEY_OF_TRIALS, "Key of Trials");
        this.addItem((Supplier)ESItems.KEY_OF_OMINOUS_TRIALS, "Key of Ominous Trials");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.KEY_OF_OMINOUS_TRIALS, "Reward for challenging dangerous foes");
        this.addItem((Supplier)ESItems.OFFICE_KEY, "Office Key");
        this.addItem((Supplier)ESItems.BAGUETTE_MAGIQUE, "Baguette Magique");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.BAGUETTE_MAGIQUE, "Un morceau de pain utilis\u00e9 par les magiciens");
        this.addItem((Supplier)ESItems.BROOM, "Broom");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.BROOM, "Sweep sweep sweep");
        this.addItem((Supplier)ESItems.MAGNEFORK, "Magnefork");
        this.addItem((Supplier)ESItems.OVERCHARGED_MAGNEFORK, "Overcharged Magnefork");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.OVERCHARGED_MAGNEFORK, "Batteries sold separately");
        this.addItem((Supplier)ESItems.UNDERCHARGED_MAGNEFORK, "Undercharged Magnefork");
        this.addItem((Supplier)ESItems.HANDGUN, "Handgun");
        this.addItem((Supplier)ESItems.HANDGUN_BULLET, "Handgun Bullet");
        this.addEntityType(ESEntities.HANDGUN_BULLET, "Handgun Bullet");
        this.addItem((Supplier)ESItems.HEAVY_HANDGUN_BULLET, "Heavy Handgun Bullet");
        this.addEntityType(ESEntities.HEAVY_HANDGUN_BULLET, "Heavy Handgun Bullet");
        this.addEntityType(ESEntities.ITEM_BULLET, "Item Bullet");
    }

    private void addArmors() {
        this.addItem((Supplier)ESItems.CHEF_HAT, "Chef Hat");
        this.addItem((Supplier)ESItems.CHEF_APRON, "Chef Apron");
        this.addItem((Supplier)ESItems.HEAVY_BOOTS, "Heavy Boots");
        this.addItem((Supplier)ESItems.PROPELLER_HAT, "Propeller Hat");
    }

    private void addModuses() {
        this.addItem((Supplier)ESItems.PILE_MODUS_CARD, "Pile Modus");
        this.addItem((Supplier)ESItems.FORTUNE_MODUS_CARD, "Fortune Modus");
        this.addItem((Supplier)ESItems.ORE_MODUS_CARD, "Ore Modus");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.ORE_MODUS_CARD, "Perfect for mining lovers");
        this.addItem((Supplier)ESItems.ARCHEOLOGY_MODUS_CARD, "Archeology Modus");
        this.addItem((Supplier)ESItems.VOID_MODUS_CARD, "Void Modus");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.VOID_MODUS_CARD, "Too Many Items");
        this.addItem((Supplier)ESItems.FORTUNE_COOKIE, "Fortune Cookie");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.FORTUNE_COOKIE, "What's inside?");
        this.addBlock((Supplier)ESBlocks.CARD_ORE, "Card Ore");
    }

    private void addTools() {
        this.addItem((Supplier)ESItems.OLD_BRUSH, "Old Brush");
        this.addItem((Supplier)ESItems.MAGNET, "Magnet");
        this.addItemTooltip((Supplier<? extends Item>)ESItems.MAGNET, "How do they work?");
    }

    private void addBlocks() {
        this.addBlock((Supplier)ESBlocks.CUT_GARNET, "Cut Garnet");
        this.addBlock((Supplier)ESBlocks.CUT_GARNET_STAIRS, "Cut Garnet Stairs");
        this.addBlock((Supplier)ESBlocks.CUT_GARNET_SLAB, "Cut Garnet Slab");
        this.addBlock((Supplier)ESBlocks.CUT_GARNET_WALL, "Cut Garnet Wall");
        this.addBlock((Supplier)ESBlocks.GARNET_BRICKS, "Garnet Bricks");
        this.addBlock((Supplier)ESBlocks.GARNET_BRICK_STAIRS, "Garnet Brick Stairs");
        this.addBlock((Supplier)ESBlocks.GARNET_BRICK_SLAB, "Garnet Brick Slab");
        this.addBlock((Supplier)ESBlocks.GARNET_BRICK_WALL, "Garnet Brick Wall");
        this.addBlock((Supplier)ESBlocks.CHISELED_GARNET_BRICKS, "Chiseled Garnet Bricks");
        this.addBlock((Supplier)ESBlocks.CUT_RUBY, "Cut Ruby");
        this.addBlock((Supplier)ESBlocks.CUT_RUBY_STAIRS, "Cut Ruby Stairs");
        this.addBlock((Supplier)ESBlocks.CUT_RUBY_SLAB, "Cut Ruby Slab");
        this.addBlock((Supplier)ESBlocks.CUT_RUBY_WALL, "Cut Ruby Wall");
        this.addBlock((Supplier)ESBlocks.RUBY_BRICKS, "Ruby Bricks");
        this.addBlock((Supplier)ESBlocks.RUBY_BRICK_STAIRS, "Ruby Brick Stairs");
        this.addBlock((Supplier)ESBlocks.RUBY_BRICK_SLAB, "Ruby Brick Slab");
        this.addBlock((Supplier)ESBlocks.RUBY_BRICK_WALL, "Ruby Brick Wall");
        this.addBlock((Supplier)ESBlocks.CHISELED_RUBY_BRICKS, "Chiseled Ruby Bricks");
        this.addBlock((Supplier)ESBlocks.COBALT_BLOCK, "Cobalt Block");
        this.addBlock((Supplier)ESBlocks.COBALT_BARS, "Cobalt Bars");
        this.addBlock((Supplier)ESBlocks.COBALT_DOOR, "Cobalt Door");
        this.addBlock((Supplier)ESBlocks.COBALT_TRAPDOOR, "Cobalt Trapdoor");
        this.addBlock((Supplier)ESBlocks.COBALT_PRESSURE_PLATE, "Cobalt Pressure Plate");
        this.addBlock((Supplier)ESBlocks.SULFUROUS_STONE, "Sulfurous Stone");
        this.addBlock((Supplier)ESBlocks.SULFUROUS_STONE_STAIRS, "Sulfurous Stone Stairs");
        this.addBlock((Supplier)ESBlocks.SULFUROUS_STONE_SLAB, "Sulfurous Stone Slab");
        this.addBlock((Supplier)ESBlocks.SULFUROUS_STONE_WALL, "Sulfurous Stone Wall");
        this.addBlock((Supplier)ESBlocks.MARBLE, "Marble");
        this.addBlock((Supplier)ESBlocks.MARBLE_STAIRS, "Marble Stairs");
        this.addBlock((Supplier)ESBlocks.MARBLE_SLAB, "Marble Slab");
        this.addBlock((Supplier)ESBlocks.MARBLE_WALL, "Marble Wall");
        this.addBlock((Supplier)ESBlocks.POLISHED_MARBLE, "Polished Marble");
        this.addBlock((Supplier)ESBlocks.POLISHED_MARBLE_STAIRS, "Polished Marble Stairs");
        this.addBlock((Supplier)ESBlocks.POLISHED_MARBLE_SLAB, "Polished Marble Slab");
        this.addBlock((Supplier)ESBlocks.POLISHED_MARBLE_WALL, "Polished Marble Wall");
        this.addBlock((Supplier)ESBlocks.MARBLE_BRICKS, "Marble Bricks");
        this.addBlock((Supplier)ESBlocks.MARBLE_BRICK_STAIRS, "Marble Brick Stairs");
        this.addBlock((Supplier)ESBlocks.MARBLE_BRICK_SLAB, "Marble Brick Slab");
        this.addBlock((Supplier)ESBlocks.MARBLE_BRICK_WALL, "Marble Brick Wall");
        this.addBlock((Supplier)ESBlocks.ZILLIUM_BRICKS, "Zillium Bricks");
        this.addBlock((Supplier)ESBlocks.ZILLIUM_BRICK_STAIRS, "Zillium Brick Stairs");
        this.addBlock((Supplier)ESBlocks.ZILLIUM_BRICK_SLAB, "Zillium Brick Slab");
        this.addBlock((Supplier)ESBlocks.ZILLIUM_BRICK_WALL, "Zillium Brick Wall");
    }

    private void addTags() {
        this.add(ESItemTags.AMMO, "Ammunition");
        this.add(ESItemTags.AMMO_HANDGUN, "Handgun Ammunition");
    }

    protected void addItemTooltip(Supplier<? extends Item> key, String text) {
        this.addItemExtra(key, "tooltip", text);
    }

    protected void addItemExtra(Supplier<? extends Item> key, String extra, String text) {
        this.add(key.get().getDescriptionId() + "." + extra, text);
    }

    protected void addBlockTooltip(Supplier<? extends Block> key, String text) {
        this.add(key.get().getDescriptionId() + ".tooltip", text);
    }

    protected void addDeathMessages(ResourceKey<DamageType> damage, String generic, String namedItem) {
        this.add("death.attack." + damage.location().toString(), generic);
        this.add("death.attack." + damage.location().toString() + ".item", namedItem);
    }

    private void addEffectDescription(Supplier<? extends MobEffect> effect, String desc) {
        this.add(effect.get().getDescriptionId() + ".description", desc);
    }
}

