/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.data;

import com.medsal15.ExtraStuck;
import com.medsal15.items.ESItems;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipeBuilder;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationRecipeBuilder;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.util.MSTags;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public final class ESRecipeProvider
extends RecipeProvider {
    public ESRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@Nonnull RecipeOutput output) {
        this.shieldRecipes(output);
        this.weaponRecipes(output);
        this.arrowRecipes(output);
        this.ammoRecipes(output);
        this.armorRecipes(output);
        this.modusRecipes(output);
        this.toolRecipes(output);
        this.blockRecipes(output);
        CombinationRecipeBuilder.of(ESItems.GIFT).input((ItemLike)Items.PAPER).and().input((ItemLike)MSItems.SURPRISE_EMBRYO).build(output);
        GristCostRecipeBuilder.of(ESItems.GIFT).grist(GristTypes.GARNET, 2L).grist(GristTypes.GOLD, 12L).build(output);
        CombinationRecipeBuilder.of(ESItems.PIZZA).input((ItemLike)Items.BREAD).or().input((ItemLike)Items.BEETROOT).build(output);
        GristCostRecipeBuilder.of(ESItems.PIZZA).grist(GristTypes.AMBER, 6L).grist(GristTypes.RUST, 1L).build(output);
    }

    private void shieldRecipes(@Nonnull RecipeOutput output) {
        CombinationRecipeBuilder.of(ESItems.WOODEN_SHIELD).input(Tags.Items.RODS_WOODEN).and().input(ItemTags.WOODEN_PRESSURE_PLATES).build(output);
        GristCostRecipeBuilder.of(ESItems.WOODEN_SHIELD).grist(GristTypes.BUILD, 26L).build(output);
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.WOODEN_SHIELD}), (RecipeCategory)RecipeCategory.COMBAT, ESItems.FLAME_SHIELD, (float)0.0f, (int)600).unlockedBy("has_wooden_shield", ESRecipeProvider.has(ESItems.WOODEN_SHIELD)).save(output, this.modLoc("campfire/flame_shield"));
        GristCostRecipeBuilder.of(ESItems.FLAME_SHIELD).grist(GristTypes.TAR, 13L).grist(GristTypes.SULFUR, 8L).build(output);
        CombinationRecipeBuilder.of(ESItems.HALT_SHIELD).input(ESItems.FLAME_SHIELD).or().input(ItemTags.WOODEN_DOORS).build(output);
        GristCostRecipeBuilder.of(ESItems.HALT_SHIELD).grist(GristTypes.TAR, 187L).grist(GristTypes.DIAMOND, 60L).build(output);
        CombinationRecipeBuilder.of(ESItems.LIGHT_SHIELD).input(ESItems.FLAME_SHIELD).and().input((ItemLike)Items.BEACON).build(output);
        GristCostRecipeBuilder.of(ESItems.LIGHT_SHIELD).grist(GristTypes.URANIUM, 444L).grist(GristTypes.QUARTZ, 345L).grist(GristTypes.DIAMOND, 246L).build(output);
        CombinationRecipeBuilder.of(ESItems.NON_CONTACT_CONTRACT).input(ESItems.WOODEN_SHIELD).and().input((ItemLike)Items.PAPER).build(output);
        GristCostRecipeBuilder.of(ESItems.NON_CONTACT_CONTRACT).grist(GristTypes.CHALK, 202L).grist(GristTypes.TAR, 20L).build(output);
        CombinationRecipeBuilder.of(ESItems.SLIED).input(ESItems.NON_CONTACT_CONTRACT).and().input((ItemLike)MSItems.SBAHJ_POSTER).build(output);
        GristCostRecipeBuilder.of(ESItems.SLIED).grist(GristTypes.ARTIFACT, -5L).build(output);
        CombinationRecipeBuilder.of(ESItems.RIOT_SHIELD).input(ESItems.NON_CONTACT_CONTRACT).or().input(Ingredient.of((ItemLike[])new ItemLike[]{MSItems.ROCKEFELLERS_WALKING_BLADECANE, MSItems.ROCKEFELLERS_WALKING_BLADECANE_SHEATHED})).build(output);
        GristCostRecipeBuilder.of(ESItems.RIOT_SHIELD).grist(GristTypes.TAR, 197L).grist(GristTypes.RUST, 228L).build(output);
        CombinationRecipeBuilder.of(ESItems.CAPTAIN_JUSTICE_THROWABLE_SHIELD).input(ESItems.RIOT_SHIELD).and().input((ItemLike)Items.TRIDENT).build(output);
        GristCostRecipeBuilder.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.CAPTAIN_JUSTICE_THROWABLE_SHIELD, ESItems.CAPTAIN_JUSTICE_SHIELD_THROWABLE})).grist(GristTypes.COBALT, 827L).grist(GristTypes.BUILD, 256L).grist(GristTypes.GOLD, 433L).build(output);
        CombinationRecipeBuilder.of(ESItems.CAPITASHIELD).input(ESItems.GOLD_SHIELD).and().input(ESItems.NON_CONTACT_CONTRACT).build(output);
        GristCostRecipeBuilder.of(ESItems.CAPITASHIELD).grist(GristTypes.GOLD, 567L).grist(GristTypes.DIAMOND, 246L).build(output);
        CombinationRecipeBuilder.of(ESItems.IRON_SHIELD).input((ItemLike)Items.SHIELD).and().input(Tags.Items.INGOTS_IRON).build(output);
        GristCostRecipeBuilder.of(ESItems.IRON_SHIELD).grist(GristTypes.RUST, 63L).grist(GristTypes.MERCURY, 17L).build(output);
        CombinationRecipeBuilder.of(ESItems.SPIKES_ON_A_SLAB).input(ESItems.IRON_SHIELD).or().input((ItemLike)MSItems.SPIKES).build(output);
        GristCostRecipeBuilder.of(ESItems.SPIKES_ON_A_SLAB).grist(GristTypes.RUST, 122L).grist(GristTypes.GARNET, 21L).build(output);
        CombinationRecipeBuilder.of(ESItems.JAWBITER).input(ESItems.SPIKES_ON_A_SLAB).and().input((ItemLike)MSItems.CANDY_CORN).build(output);
        GristCostRecipeBuilder.of(ESItems.JAWBITER).grist(GristTypes.MARBLE, 83L).grist(GristTypes.IODINE, 52L).build(output);
        CombinationRecipeBuilder.of(ESItems.ELDRITCH_SHIELD).input(ESItems.JAWBITER).or().input((ItemLike)MSItems.GRIMOIRE).build(output);
        GristCostRecipeBuilder.of(ESItems.ELDRITCH_SHIELD).grist(GristTypes.CHALK, 1666L).grist(GristTypes.GARNET, 999L).grist(GristTypes.TAR, 777L).build(output);
        CombinationRecipeBuilder.of(ESItems.GOLD_SHIELD).input(ESItems.IRON_SHIELD).and().input(Tags.Items.INGOTS_GOLD).build(output);
        GristCostRecipeBuilder.of(ESItems.GOLD_SHIELD).grist(GristTypes.GOLD, 253L).grist(GristTypes.CAULK, 153L).build(output);
        CombinationRecipeBuilder.of(ESItems.FLUX_SHIELD).input(ESItems.GOLD_SHIELD).or().input(Tags.Items.STORAGE_BLOCKS_REDSTONE).build(output);
        GristCostRecipeBuilder.of(ESItems.FLUX_SHIELD).grist(GristTypes.GOLD, 593L).grist(GristTypes.GARNET, 231L).build(output);
        CombinationRecipeBuilder.of(ESItems.DIAMOND_SHIELD).input(ESItems.GOLD_SHIELD).or().input(Tags.Items.GEMS_DIAMOND).build(output);
        GristCostRecipeBuilder.of(ESItems.DIAMOND_SHIELD).grist(GristTypes.DIAMOND, 768L).grist(GristTypes.AMETHYST, 256L).build(output);
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.DIAMOND_SHIELD}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)ESItems.NETHERITE_SHIELD.get())).unlocks("netherite_shield", ESRecipeProvider.has(ESItems.DIAMOND_SHIELD)).save(output, this.modLoc("smithing/netherite_shield"));
        CombinationRecipeBuilder.of(ESItems.GARNET_SHIELD).input(ESItems.DIAMOND_SHIELD).and().input((ItemLike)MSItems.FROG).build(output);
        GristCostRecipeBuilder.of(ESItems.GARNET_SHIELD).grist(GristTypes.GARNET, 1500L).grist(GristTypes.DIAMOND, 1000L).grist(GristTypes.RUBY, 444L).build(output);
        CombinationRecipeBuilder.of(ESItems.POGO_SHIELD).input(ESItems.IRON_SHIELD).and().input((ItemLike)Items.SLIME_BALL).build(output);
        GristCostRecipeBuilder.of(ESItems.POGO_SHIELD).grist(GristTypes.RUST, 125L).grist(GristTypes.SHALE, 55L).build(output);
        CombinationRecipeBuilder.of(ESItems.RETURN_TO_SENDER).input(ESItems.POGO_SHIELD).or().input((ItemLike)MSItems.MAILBOX).build(output);
        GristCostRecipeBuilder.of(ESItems.RETURN_TO_SENDER).grist(GristTypes.MARBLE, 868L).grist(GristTypes.CAULK, 133L).build(output);
        CombinationRecipeBuilder.of(ESItems.GIFT_OF_PROTECTION).input(ESItems.GIFT).or().input(ESItems.NON_CONTACT_CONTRACT).build(output);
        GristCostRecipeBuilder.of(ESItems.GIFT_OF_PROTECTION).grist(GristTypes.AMBER, 1225L).grist(GristTypes.IODINE, 606L).build(output);
    }

    private void weaponRecipes(@Nonnull RecipeOutput output) {
        CombinationRecipeBuilder.of(ESItems.GEM_BREAKER).input((ItemLike)MSItems.REGI_HAMMER).or().input((ItemLike)Items.EMERALD_BLOCK).build(output, this.modLoc("combinations/gem_breaker_emerald"));
        CombinationRecipeBuilder.of(ESItems.GEM_BREAKER).input((ItemLike)MSItems.REGI_HAMMER).or().input((ItemLike)Items.DIAMOND_BLOCK).build(output, this.modLoc("combinations/gem_breaker_diamond"));
        GristCostRecipeBuilder.of(ESItems.GEM_BREAKER).grist(GristTypes.AMETHYST, 63L).grist(GristTypes.RUBY, 63L).grist(GristTypes.MARBLE, 127L).build(output);
        CombinationRecipeBuilder.of(ESItems.BELL_HAMMER).input((ItemLike)MSItems.LUCERNE_HAMMER).and().input((ItemLike)Items.BELL).build(output);
        GristCostRecipeBuilder.of(ESItems.BELL_HAMMER).grist(GristTypes.GOLD, 444L).grist(GristTypes.MERCURY, 150L).grist(GristTypes.RUST, 300L).build(output);
        CombinationRecipeBuilder.of(ESItems.BLIND_HAMMER).input(ESItems.BELL_HAMMER).or().input((ItemLike)Items.SCULK_SHRIEKER).build(output);
        GristCostRecipeBuilder.of(ESItems.BLIND_HAMMER).grist(GristTypes.TAR, 3444L).grist(GristTypes.DIAMOND, 1250L).grist(GristTypes.RUST, 900L).build(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemStack)ESItems.GOLD_COIN.toStack()).pattern(" N ").pattern("NIN").pattern(" N ").define(Character.valueOf('N'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('I'), (ItemLike)Items.GOLD_INGOT).unlockedBy("has_gold_ingot", ESRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).save(output, this.modLoc("shaped/gold_coin"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.GOLD_COIN}), (RecipeCategory)RecipeCategory.MISC, (ItemStack)new ItemStack((ItemLike)Items.GOLD_NUGGET), (float)0.1f, (int)200).unlockedBy("has_gold_coin", ESRecipeProvider.has(ESItems.GOLD_COIN)).save(output, this.modLoc("smelting/gold_coin"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.GOLD_COIN}), (RecipeCategory)RecipeCategory.MISC, (ItemStack)new ItemStack((ItemLike)Items.GOLD_NUGGET), (float)0.1f, (int)100).unlockedBy("has_gold_coin", ESRecipeProvider.has(ESItems.GOLD_COIN)).save(output, this.modLoc("blasting/gold_coin"));
        CombinationRecipeBuilder.of(ESItems.STICKY_DIE).input((ItemLike)MSItems.DICE).or().input((ItemLike)Items.SLIME_BALL).build(output);
        GristCostRecipeBuilder.of(ESItems.STICKY_DIE).grist(GristTypes.CAULK, 33L).grist(GristTypes.TAR, 3L).build(output);
        CombinationRecipeBuilder.of(ESItems.ANTI_DIE).input(ESItems.STICKY_DIE).and().input((ItemLike)MSItems.MIRROR).build(output);
        GristCostRecipeBuilder.of(ESItems.ANTI_DIE).grist(GristTypes.URANIUM, 166L).grist(GristTypes.MERCURY, 333L).grist(GristTypes.AMETHYST, 139L).build(output);
        CombinationRecipeBuilder.of(ESItems.TOKEN_TETRAHEDRON).input(ESItems.GOLD_COIN).and().input((ItemLike)Items.EMERALD).build(output);
        GristCostRecipeBuilder.of(ESItems.TOKEN_TETRAHEDRON).grist(GristTypes.RUBY, 244L).grist(GristTypes.DIAMOND, 244L).grist(GristTypes.GOLD, 444L).build(output);
        CombinationRecipeBuilder.of(ESItems.D_ICE).input(ESItems.STICKY_DIE).and().input(Ingredient.of((ItemLike[])new ItemLike[]{Items.ICE, Items.PACKED_ICE, Items.BLUE_ICE, MSItems.ICE_SHARD})).build(output);
        GristCostRecipeBuilder.of(ESItems.D_ICE).grist(GristTypes.COBALT, 66L).grist(GristTypes.BUILD, 55L).build(output);
        CombinationRecipeBuilder.of(ESItems.SLICE_AND_DICE).input((ItemLike)MSItems.DAGGER).or().input(ESItems.GOLD_COIN).build(output);
        GristCostRecipeBuilder.of(ESItems.SLICE_AND_DICE).grist(GristTypes.GOLD, 66L).grist(GristTypes.CHALK, 33L).build(output);
        CombinationRecipeBuilder.of(ESItems.DONE).input((ItemLike)MSItems.SBAHJ_POSTER).or().input(ESItems.D_ICE).build(output);
        GristCostRecipeBuilder.of(ESItems.DONE).grist(GristTypes.ARTIFACT, -6L).build(output);
        CombinationRecipeBuilder.of(ESItems.D10).input(ESItems.TOKEN_TETRAHEDRON).and().input((ItemLike)Items.CLOCK).build(output);
        GristCostRecipeBuilder.of(ESItems.D10).grist(GristTypes.DIAMOND, 1331L).grist(GristTypes.GOLD, 10L).grist(GristTypes.GARNET, 999L).build(output);
        CombinationRecipeBuilder.of(ESItems.RAINBOW_D7).input((ItemLike)MSItems.DICE).and().input((ItemLike)MSItems.WATER_COLORS_BUCKET).build(output);
        GristCostRecipeBuilder.of(ESItems.RAINBOW_D7).grist(GristTypes.GOLD, 777L).grist(GristTypes.DIAMOND, 777L).grist(GristTypes.COBALT, 777L).grist(GristTypes.URANIUM, 77L).build(output);
        CombinationRecipeBuilder.of(ESItems.D8_NIGHT).input(ESItems.RAINBOW_D7).or().input((ItemLike)MSItems.NIGHTSTICK).build(output);
        GristCostRecipeBuilder.of(ESItems.D8_NIGHT).grist(GristTypes.COBALT, 1888L).grist(GristTypes.DIAMOND, 888L).build(output);
        CombinationRecipeBuilder.of(ESItems.CAN_DIE).input((ItemLike)MSItems.DICE).or().input((ItemLike)MSItems.CANDY_CORN).build(output);
        GristCostRecipeBuilder.of(ESItems.CAN_DIE).grist(GristTypes.MARBLE, 12L).grist(GristTypes.CHALK, 36L).grist(GristTypes.AMBER, 12L).build(output);
        CombinationRecipeBuilder.of(ESItems.SILVER_BAT).input((ItemLike)MSItems.METAL_BAT).and().input((ItemLike)Items.GLASS).build(output);
        GristCostRecipeBuilder.of(ESItems.SILVER_BAT).grist(GristTypes.MERCURY, 35L).grist(GristTypes.RUST, 70L).build(output);
        GristCostRecipeBuilder.of(ESItems.GOLDEN_PAN).grist(GristTypes.GOLD, 250L).grist(GristTypes.RUST, 44L).build(output);
        CombinationRecipeBuilder.of(ESItems.ROLLING_PIN).input((ItemLike)MSItems.DEUCE_CLUB).and().input(ESItems.PIZZA).build(output);
        GristCostRecipeBuilder.of(ESItems.ROLLING_PIN).grist(GristTypes.BUILD, 12L).build(output);
        CombinationRecipeBuilder.of(ESItems.KEY_OF_TRIALS).input((ItemLike)MSItems.HOUSE_KEY).and().input((ItemLike)Items.TRIAL_KEY).build(output);
        GristCostRecipeBuilder.of(ESItems.KEY_OF_TRIALS).grist(GristTypes.SHALE, 13L).grist(GristTypes.RUST, 7L).build(output);
        CombinationRecipeBuilder.of(ESItems.KEY_OF_OMINOUS_TRIALS).input(ESItems.KEY_OF_TRIALS).and().input((ItemLike)Items.OMINOUS_TRIAL_KEY).build(output);
        CombinationRecipeBuilder.of(ESItems.KEY_OF_OMINOUS_TRIALS).input(ESItems.KEY_OF_TRIALS).and().input((ItemLike)Items.OMINOUS_BOTTLE).build(output, ExtraStuck.modid("combinations/key_of_ominous_trials_alt"));
        GristCostRecipeBuilder.of(ESItems.KEY_OF_OMINOUS_TRIALS).grist(GristTypes.GARNET, 6L).grist(GristTypes.SHALE, 43L).build(output);
        CombinationRecipeBuilder.of(ESItems.OFFICE_KEY).input((ItemLike)MSItems.HOUSE_KEY).or().input((ItemLike)Items.IRON_DOOR).build(output);
        GristCostRecipeBuilder.of(ESItems.OFFICE_KEY).grist(GristTypes.MARBLE, 33L).grist(GristTypes.TAR, 12L).build(output);
        CombinationRecipeBuilder.of(ESItems.BAGUETTE_MAGIQUE).input((ItemLike)MSItems.STALE_BAGUETTE).and().input((ItemLike)MSItems.WAND).build(output);
        GristCostRecipeBuilder.of(ESItems.BAGUETTE_MAGIQUE).grist(GristTypes.AMBER, 12L).grist(GristTypes.IODINE, 18L).grist(GristTypes.SULFUR, 6L).build(output);
        CombinationRecipeBuilder.of(ESItems.BROOM).input((ItemLike)Items.BRUSH).and().input((ItemLike)Items.HAY_BLOCK).build(output);
        GristCostRecipeBuilder.of(ESItems.BROOM).grist(GristTypes.CHALK, 39L).grist(GristTypes.IODINE, 50L).grist(GristTypes.SHALE, 27L).build(output);
        CombinationRecipeBuilder.of(ESItems.MAGNEFORK).input((ItemLike)MSItems.TUNING_FORK).and().input(ESItems.MAGNET).build(output);
        GristCostRecipeBuilder.of(ESItems.MAGNEFORK).grist(GristTypes.RUST, 40L).grist(GristTypes.GARNET, 5L).grist(GristTypes.COBALT, 5L).build(output);
        CombinationRecipeBuilder.of(ESItems.OVERCHARGED_MAGNEFORK).input(ESItems.MAGNEFORK).or().input((ItemLike)MSItems.BATTERY).build(output);
        CombinationRecipeBuilder.of(ESItems.OVERCHARGED_MAGNEFORK).input(ESItems.MAGNET).and().input((ItemLike)MSItems.EDISONS_FURY).build(output, ExtraStuck.modid("combinations/overcharged_magnefork_alt"));
        GristCostRecipeBuilder.of(ESItems.OVERCHARGED_MAGNEFORK).grist(GristTypes.GOLD, 450L).grist(GristTypes.URANIUM, 75L).grist(GristTypes.GARNET, 20L).grist(GristTypes.COBALT, 20L).build(output);
        GristCostRecipeBuilder.of(ESItems.UNDERCHARGED_MAGNEFORK).grist(GristTypes.GOLD, 450L).grist(GristTypes.URANIUM, 75L).grist(GristTypes.GARNET, 20L).grist(GristTypes.COBALT, 20L).build(output);
        GristCostRecipeBuilder.of(ESItems.HANDGUN).grist(GristTypes.MARBLE, 33L).grist(GristTypes.TAR, 12L).build(output);
    }

    private void arrowRecipes(@Nonnull RecipeOutput output) {
        CombinationRecipeBuilder.of(ESItems.NETHER_ARROW).input((ItemLike)Items.ARROW).and().input((ItemLike)Items.NETHERRACK).build(output);
        GristCostRecipeBuilder.of(ESItems.NETHER_ARROW).grist(GristTypes.SULFUR, 12L).grist(GristTypes.RUST, 8L).build(output);
        CombinationRecipeBuilder.of(ESItems.FLAME_ARROW).input(ESItems.NETHER_ARROW).and().input(Ingredient.of((ItemLike[])new ItemLike[]{Items.BLAZE_ROD, Items.BLAZE_POWDER})).build(output);
        GristCostRecipeBuilder.of(ESItems.FLAME_ARROW).grist(GristTypes.SULFUR, 8L).grist(GristTypes.TAR, 4L).build(output);
        CombinationRecipeBuilder.of(ESItems.CARDBOARD_ARROW).input((ItemLike)MSItems.CARDBOARD_TUBE).and().input((ItemLike)Items.FLINT).build(output);
        GristCostRecipeBuilder.of(ESItems.CARDBOARD_ARROW).grist(GristTypes.BUILD, 1L).build(output);
        CombinationRecipeBuilder.of(ESItems.MISSED_YOU).input(ESItems.CARDBOARD_ARROW).or().input((ItemLike)MSItems.SBAHJ_POSTER).build(output);
        GristCostRecipeBuilder.of(ESItems.MISSED_YOU).grist(GristTypes.ARTIFACT, 1L).build(output);
        CombinationRecipeBuilder.of(ESItems.SWEET_TOOTH).input(Ingredient.of((ItemLike[])new ItemLike[]{ESItems.CARDBOARD_ARROW, Items.BONE})).and().input((ItemLike)MSItems.CANDY_CORN).build(output);
        GristCostRecipeBuilder.of(ESItems.SWEET_TOOTH).grist(GristTypes.SHALE, 1L).grist(GristTypes.IODINE, 6L).build(output);
        CombinationRecipeBuilder.of(ESItems.LIGHTNING_ARROW).input((ItemLike)Items.LIGHTNING_ROD).or().input((ItemLike)MSItems.BATTERY).build(output);
        GristCostRecipeBuilder.of(ESItems.LIGHTNING_ARROW).grist(GristTypes.GOLD, 25L).grist(GristTypes.RUST, 25L).build(output);
        CombinationRecipeBuilder.of(ESItems.EXPLOSIVE_ARROW).input(ESItems.FLAME_ARROW).or().input(ESItems.LIGHTNING_ARROW).build(output);
        GristCostRecipeBuilder.of(ESItems.EXPLOSIVE_ARROW).grist(GristTypes.SULFUR, 21L).grist(GristTypes.TAR, 7L).grist(GristTypes.CHALK, 12L).build(output);
        CombinationRecipeBuilder.of(ESItems.IRON_ARROW).input((ItemLike)Items.ARROW).and().input(Tags.Items.INGOTS_IRON).build(output);
        GristCostRecipeBuilder.of(ESItems.IRON_ARROW).grist(GristTypes.BUILD, 2L).grist(GristTypes.RUST, 4L).build(output);
        CombinationRecipeBuilder.of(ESItems.QUARTZ_ARROW).input(ESItems.IRON_ARROW).or().input(Tags.Items.GEMS_QUARTZ).build(output);
        GristCostRecipeBuilder.of(ESItems.QUARTZ_ARROW).grist(GristTypes.QUARTZ, 12L).grist(GristTypes.BUILD, 4L).build(output);
        CombinationRecipeBuilder.of(ESItems.PRISMARINE_ARROW).input(ESItems.QUARTZ_ARROW).and().input((ItemLike)Items.PRISMARINE_SHARD).build(output);
        GristCostRecipeBuilder.of(ESItems.PRISMARINE_ARROW).grist(GristTypes.DIAMOND, 1L).grist(GristTypes.COBALT, 7L).grist(GristTypes.BUILD, 1L).build(output);
        CombinationRecipeBuilder.of(ESItems.GLASS_ARROW).input(ESItems.QUARTZ_ARROW).and().input(Tags.Items.GLASS_BLOCKS).build(output);
        GristCostRecipeBuilder.of(ESItems.GLASS_ARROW).grist(GristTypes.QUARTZ, 25L).grist(GristTypes.MARBLE, 5L).build(output);
        CombinationRecipeBuilder.of(ESItems.AMETHYST_ARROW).input(ESItems.GLASS_ARROW).or().input(Tags.Items.GEMS_AMETHYST).build(output);
        GristCostRecipeBuilder.of(ESItems.AMETHYST_ARROW).grist(GristTypes.DIAMOND, 4L).grist(GristTypes.AMETHYST, 19L).build(output);
        CombinationRecipeBuilder.of(ESItems.PROJECDRILL).input(ESItems.IRON_ARROW).and().input((ItemLike)Items.IRON_PICKAXE).build(output);
        GristCostRecipeBuilder.of(ESItems.PROJECDRILL).grist(GristTypes.RUST, 32L).grist(GristTypes.MERCURY, 8L).build(output);
        CombinationRecipeBuilder.of(ESItems.CRUSADER_CROSSBOLT).input((ItemLike)Items.ARROW).and().input(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLISTERING_MELON_SLICE, Items.GOLDEN_CARROT})).build(output);
        GristCostRecipeBuilder.of(ESItems.CRUSADER_CROSSBOLT).grist(GristTypes.GOLD, 9L).grist(GristTypes.GARNET, 5L).build(output);
        CombinationRecipeBuilder.of(ESItems.END_ARROW).input((ItemLike)Items.ARROW).or().input((ItemLike)Items.END_STONE).build(output);
        CombinationRecipeBuilder.of(ESItems.END_ARROW).input((ItemLike)Items.END_ROD).and().input((ItemLike)Items.FLINT).build(output, this.modLoc("end_arrow_2"));
        GristCostRecipeBuilder.of(ESItems.END_ARROW).grist(GristTypes.URANIUM, 3L).grist(GristTypes.CAULK, 7L).build(output);
        CombinationRecipeBuilder.of(ESItems.TELERROW).input(ESItems.END_ARROW).or().input((ItemLike)Items.ENDER_PEARL).build(output);
        GristCostRecipeBuilder.of(ESItems.TELERROW).grist(GristTypes.URANIUM, 23L).grist(GristTypes.MERCURY, 12L).grist(GristTypes.DIAMOND, 8L).build(output);
        CombinationRecipeBuilder.of(ESItems.DRAGON_ARROW).input(ESItems.TELERROW).and().input((ItemLike)Items.DRAGON_BREATH).build(output);
        GristCostRecipeBuilder.of(ESItems.DRAGON_ARROW).grist(GristTypes.URANIUM, 15L).grist(GristTypes.RUBY, 4L).build(output);
    }

    private void ammoRecipes(@Nonnull RecipeOutput output) {
        CombinationRecipeBuilder.of(ESItems.HANDGUN_BULLET).input((ItemLike)Items.GUNPOWDER).and().input((ItemLike)Items.IRON_NUGGET).build(output);
        GristCostRecipeBuilder.of(ESItems.HANDGUN_BULLET).grist(GristTypes.CHALK, 3L).grist(GristTypes.TAR, 1L).build(output);
        CombinationRecipeBuilder.of(ESItems.HEAVY_HANDGUN_BULLET).input(ESItems.HANDGUN_BULLET).and().input((ItemLike)Items.IRON_INGOT).build(output);
        GristCostRecipeBuilder.of(ESItems.HEAVY_HANDGUN_BULLET).grist(GristTypes.RUST, 5L).grist(GristTypes.TAR, 2L).build(output);
    }

    private void armorRecipes(@Nonnull RecipeOutput output) {
        CombinationRecipeBuilder.of(ESItems.CHEF_HAT).input(ESItems.PIZZA).or().input((ItemLike)Items.LEATHER_HELMET).build(output);
        GristCostRecipeBuilder.of(ESItems.CHEF_HAT).grist(GristTypes.CHALK, 22L).build(output);
        CombinationRecipeBuilder.of(ESItems.CHEF_APRON).input(ESItems.PIZZA).or().input((ItemLike)Items.LEATHER_CHESTPLATE).build(output);
        GristCostRecipeBuilder.of(ESItems.CHEF_APRON).grist(GristTypes.CHALK, 32L).build(output);
        CombinationRecipeBuilder.of(ESItems.HEAVY_BOOTS).input((ItemLike)Items.IRON_BOOTS).and().input((ItemLike)Items.ANVIL).build(output);
        GristCostRecipeBuilder.of(ESItems.HEAVY_BOOTS).grist(GristTypes.RUST, 54L).grist(GristTypes.TAR, 27L).build(output);
        CombinationRecipeBuilder.of(ESItems.PROPELLER_HAT).input((ItemLike)Items.IRON_HELMET).and().input((ItemLike)Items.FEATHER).build(output);
        CombinationRecipeBuilder.of(ESItems.PROPELLER_HAT).input((ItemLike)Items.IRON_HELMET).and().input((ItemLike)Items.WIND_CHARGE).build(output, this.modLoc("propeller_hat_alt"));
        GristCostRecipeBuilder.of(ESItems.PROPELLER_HAT).grist(GristTypes.RUST, 90L).grist(GristTypes.GARNET, 17L).grist(GristTypes.AMBER, 17L).grist(GristTypes.COBALT, 17L).build(output);
    }

    private void modusRecipes(@Nonnull RecipeOutput output) {
        CombinationRecipeBuilder.of(ESItems.PILE_MODUS_CARD).input(MSTags.Items.MODUS_CARD).and().input((ItemLike)Items.BRICK).build(output);
        GristCostRecipeBuilder.of(ESItems.PILE_MODUS_CARD).grist(GristTypes.BUILD, 234L).grist(GristTypes.GARNET, 34L).build(output);
        CombinationRecipeBuilder.of(ESItems.FORTUNE_MODUS_CARD).input(MSTags.Items.MODUS_CARD).and().input((ItemLike)Items.COOKIE).build(output);
        GristCostRecipeBuilder.of(ESItems.FORTUNE_MODUS_CARD).grist(GristTypes.BUILD, 357L).grist(GristTypes.IODINE, 28L).grist(GristTypes.AMBER, 28L).build(output);
        CombinationRecipeBuilder.of(ESItems.ORE_MODUS_CARD).input(MSTags.Items.MODUS_CARD).or().input((ItemLike)Items.IRON_PICKAXE).build(output);
        GristCostRecipeBuilder.of(ESItems.ORE_MODUS_CARD).grist(GristTypes.BUILD, 320L).grist(GristTypes.DIAMOND, 16L).build(output);
        CombinationRecipeBuilder.of(ESItems.ARCHEOLOGY_MODUS_CARD).input(MSTags.Items.MODUS_CARD).or().input((ItemLike)Items.BRUSH).build(output);
        GristCostRecipeBuilder.of(ESItems.ARCHEOLOGY_MODUS_CARD).grist(GristTypes.BUILD, 210L).grist(GristTypes.SHALE, 25L).build(output);
        CombinationRecipeBuilder.of(ESItems.VOID_MODUS_CARD).input(MSTags.Items.MODUS_CARD).and().input((ItemLike)Items.LAVA_BUCKET).build(output);
        GristCostRecipeBuilder.of(ESItems.VOID_MODUS_CARD).grist(GristTypes.BUILD, 410L).grist(GristTypes.COBALT, 31L).grist(GristTypes.TAR, 27L).build(output);
    }

    private void toolRecipes(@Nonnull RecipeOutput output) {
        CombinationRecipeBuilder.of(ESItems.OLD_BRUSH).input((ItemLike)Items.BRUSH).and().input((ItemLike)Items.NETHERITE_SCRAP).build(output);
        GristCostRecipeBuilder.of(ESItems.OLD_BRUSH).grist(GristTypes.SHALE, 8L).grist(GristTypes.RUST, 32L).grist(GristTypes.CAULK, 15L).build(output);
        CombinationRecipeBuilder.of(ESItems.MAGNET).input((ItemLike)MSItems.ITEM_MAGNET).or().input((ItemLike)Items.REDSTONE).build(output);
        GristCostRecipeBuilder.of(ESItems.MAGNET).grist(GristTypes.CAULK, 36L).grist(GristTypes.GARNET, 8L).grist(GristTypes.COBALT, 8L).build(output);
    }

    private void blockRecipes(@Nonnull RecipeOutput output) {
        CombinationRecipeBuilder.of(ESItems.CUT_GARNET).input((ItemLike)Items.AMETHYST_BLOCK).or().input(Tags.Items.DYES_RED).build(output);
        GristCostRecipeBuilder.of(ESItems.CUT_GARNET).grist(GristTypes.GARNET, 4L).build(output);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.CUT_GARNET}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.CUT_GARNET_STAIRS).unlockedBy("has_cut_garnet", ESRecipeProvider.has(ESItems.CUT_GARNET)).save(output, this.modLoc("stonecutting/cut_garnet_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.CUT_GARNET_STAIRS.toStack(4)).pattern("G  ").pattern("GG ").pattern("GGG").define(Character.valueOf('G'), ESItems.CUT_GARNET).unlockedBy("has_cut_garnet", ESRecipeProvider.has(ESItems.CUT_GARNET)).save(output, this.modLoc("shaped/cut_garnet_stairs"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.CUT_GARNET}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.CUT_GARNET_SLAB, (int)2).unlockedBy("has_cut_garnet", ESRecipeProvider.has(ESItems.CUT_GARNET)).save(output, this.modLoc("stonecutting/cut_garnet_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.CUT_GARNET_SLAB.toStack(6)).pattern("GGG").define(Character.valueOf('G'), ESItems.CUT_GARNET).unlockedBy("has_cut_garnet", ESRecipeProvider.has(ESItems.CUT_GARNET)).save(output, this.modLoc("shaped/cut_garnet_slab"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.CUT_GARNET}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.CUT_GARNET_WALL).unlockedBy("has_cut_garnet", ESRecipeProvider.has(ESItems.CUT_GARNET)).save(output, this.modLoc("stonecutting/cut_garnet_wall"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.CUT_GARNET_WALL.toStack(6)).pattern("GGG").pattern("GGG").define(Character.valueOf('G'), ESItems.CUT_GARNET).unlockedBy("has_cut_garnet", ESRecipeProvider.has(ESItems.CUT_GARNET)).save(output, this.modLoc("shaped/cut_garnet_wall"));
        CombinationRecipeBuilder.of(ESItems.GARNET_BRICKS).input((ItemLike)MSItems.CRUXITE_BRICKS).and().input(Tags.Items.DYES_RED).build(output);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.CUT_GARNET}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.GARNET_BRICKS).unlockedBy("has_cut_garnet", ESRecipeProvider.has(ESItems.CUT_GARNET)).save(output, this.modLoc("stonecutting/garnet_bricks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.GARNET_BRICKS.toStack(4)).pattern("GG").pattern("GG").define(Character.valueOf('G'), ESItems.CUT_GARNET).unlockedBy("has_cut_garnet", ESRecipeProvider.has(ESItems.CUT_GARNET)).save(output, this.modLoc("shaped/garnet_bricks"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.GARNET_BRICKS, ESItems.CUT_GARNET}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.GARNET_BRICK_STAIRS).unlockedBy("has_garnet_bricks", ESRecipeProvider.has(ESItems.GARNET_BRICKS)).save(output, this.modLoc("stonecutting/garnet_brick_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.GARNET_BRICK_STAIRS.toStack(4)).pattern("G  ").pattern("GG ").pattern("GGG").define(Character.valueOf('G'), ESItems.GARNET_BRICKS).unlockedBy("has_garnet_bricks", ESRecipeProvider.has(ESItems.GARNET_BRICKS)).save(output, this.modLoc("shaped/garnet_brick_stairs"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.GARNET_BRICKS, ESItems.CUT_GARNET}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.GARNET_BRICK_SLAB, (int)2).unlockedBy("has_garnet_bricks", ESRecipeProvider.has(ESItems.GARNET_BRICKS)).save(output, this.modLoc("stonecutting/garnet_brick_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.GARNET_BRICK_SLAB.toStack(6)).pattern("GGG").define(Character.valueOf('G'), ESItems.GARNET_BRICKS).unlockedBy("has_garnet_bricks", ESRecipeProvider.has(ESItems.GARNET_BRICKS)).save(output, this.modLoc("shaped/garnet_brick_slab"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.GARNET_BRICKS, ESItems.CUT_GARNET}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.GARNET_BRICK_WALL).unlockedBy("has_garnet_bricks", ESRecipeProvider.has(ESItems.GARNET_BRICKS)).save(output, this.modLoc("stonecutting/garnet_brick_wall"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.GARNET_BRICK_WALL.toStack(6)).pattern("GGG").pattern("GGG").define(Character.valueOf('G'), ESItems.GARNET_BRICKS).unlockedBy("has_garnet_bricks", ESRecipeProvider.has(ESItems.GARNET_BRICKS)).save(output, this.modLoc("shaped/garnet_brick_wall"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.GARNET_BRICKS, ESItems.CUT_GARNET}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.CHISELED_GARNET_BRICKS).unlockedBy("has_garnet_bricks", ESRecipeProvider.has(ESItems.GARNET_BRICKS)).save(output, this.modLoc("stonecutting/chiseled_garnet_bricks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.CHISELED_GARNET_BRICKS.toStack(1)).pattern("G").pattern("G").define(Character.valueOf('G'), ESItems.GARNET_BRICK_SLAB).unlockedBy("has_garnet_brick_slab", ESRecipeProvider.has(ESItems.GARNET_BRICK_SLAB)).save(output, this.modLoc("shaped/chiseled_garnet_bricks"));
        CombinationRecipeBuilder.of(ESItems.CUT_RUBY).input(ESItems.CUT_GARNET).and().input(Tags.Items.DUSTS_GLOWSTONE).build(output);
        GristCostRecipeBuilder.of(ESItems.CUT_RUBY).grist(GristTypes.RUBY, 4L).build(output);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.CUT_RUBY}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.CUT_RUBY_STAIRS).unlockedBy("has_cut_ruby", ESRecipeProvider.has(ESItems.CUT_RUBY)).save(output, this.modLoc("stonecutting/cut_ruby_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.CUT_RUBY_STAIRS.toStack(4)).pattern("G  ").pattern("GG ").pattern("GGG").define(Character.valueOf('G'), ESItems.CUT_RUBY).unlockedBy("has_cut_ruby", ESRecipeProvider.has(ESItems.CUT_RUBY)).save(output, this.modLoc("shaped/cut_ruby_stairs"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.CUT_RUBY}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.CUT_RUBY_SLAB, (int)2).unlockedBy("has_cut_ruby", ESRecipeProvider.has(ESItems.CUT_RUBY)).save(output, this.modLoc("stonecutting/cut_ruby_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.CUT_RUBY_SLAB.toStack(6)).pattern("GGG").define(Character.valueOf('G'), ESItems.CUT_RUBY).unlockedBy("has_cut_ruby", ESRecipeProvider.has(ESItems.CUT_RUBY)).save(output, this.modLoc("shaped/cut_ruby_slab"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.CUT_RUBY}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.CUT_RUBY_WALL).unlockedBy("has_cut_ruby", ESRecipeProvider.has(ESItems.CUT_RUBY)).save(output, this.modLoc("stonecutting/cut_ruby_wall"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.CUT_RUBY_WALL.toStack(6)).pattern("GGG").pattern("GGG").define(Character.valueOf('G'), ESItems.CUT_RUBY).unlockedBy("has_cut_ruby", ESRecipeProvider.has(ESItems.CUT_RUBY)).save(output, this.modLoc("shaped/cut_ruby_wall"));
        CombinationRecipeBuilder.of(ESItems.RUBY_BRICKS).input(ESItems.GARNET_BRICKS).and().input(Tags.Items.DUSTS_GLOWSTONE).build(output);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.CUT_RUBY}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.RUBY_BRICKS).unlockedBy("has_cut_ruby", ESRecipeProvider.has(ESItems.CUT_RUBY)).save(output, this.modLoc("stonecutting/ruby_bricks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.RUBY_BRICKS.toStack(4)).pattern("GG").pattern("GG").define(Character.valueOf('G'), ESItems.CUT_RUBY).unlockedBy("has_cut_ruby", ESRecipeProvider.has(ESItems.CUT_RUBY)).save(output, this.modLoc("shaped/ruby_bricks"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.RUBY_BRICKS, ESItems.CUT_RUBY}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.RUBY_BRICK_STAIRS).unlockedBy("has_ruby_bricks", ESRecipeProvider.has(ESItems.RUBY_BRICKS)).save(output, this.modLoc("stonecutting/ruby_brick_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.RUBY_BRICK_STAIRS.toStack(4)).pattern("G  ").pattern("GG ").pattern("GGG").define(Character.valueOf('G'), ESItems.RUBY_BRICKS).unlockedBy("has_ruby_bricks", ESRecipeProvider.has(ESItems.RUBY_BRICKS)).save(output, this.modLoc("shaped/ruby_brick_stairs"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.RUBY_BRICKS, ESItems.CUT_RUBY}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.RUBY_BRICK_SLAB, (int)2).unlockedBy("has_ruby_bricks", ESRecipeProvider.has(ESItems.RUBY_BRICKS)).save(output, this.modLoc("stonecutting/ruby_brick_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.RUBY_BRICK_SLAB.toStack(6)).pattern("GGG").define(Character.valueOf('G'), ESItems.RUBY_BRICKS).unlockedBy("has_ruby_bricks", ESRecipeProvider.has(ESItems.RUBY_BRICKS)).save(output, this.modLoc("shaped/ruby_brick_slab"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.RUBY_BRICKS, ESItems.CUT_RUBY}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.RUBY_BRICK_WALL).unlockedBy("has_ruby_bricks", ESRecipeProvider.has(ESItems.RUBY_BRICKS)).save(output, this.modLoc("stonecutting/ruby_brick_wall"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.RUBY_BRICK_WALL.toStack(6)).pattern("GGG").pattern("GGG").define(Character.valueOf('G'), ESItems.RUBY_BRICKS).unlockedBy("has_ruby_bricks", ESRecipeProvider.has(ESItems.RUBY_BRICKS)).save(output, this.modLoc("shaped/ruby_brick_wall"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.RUBY_BRICKS, ESItems.CUT_RUBY}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.CHISELED_RUBY_BRICKS).unlockedBy("has_ruby_bricks", ESRecipeProvider.has(ESItems.RUBY_BRICKS)).save(output, this.modLoc("stonecutting/chiseled_ruby_bricks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.CHISELED_RUBY_BRICKS.toStack(1)).pattern("G").pattern("G").define(Character.valueOf('G'), ESItems.RUBY_BRICK_SLAB).unlockedBy("has_ruby_brick_slab", ESRecipeProvider.has(ESItems.RUBY_BRICK_SLAB)).save(output, this.modLoc("shaped/chiseled_ruby_bricks"));
        CombinationRecipeBuilder.of(ESItems.COBALT_BLOCK).input(Tags.Items.STORAGE_BLOCKS_IRON).and().input(Tags.Items.DYES_BLUE).build(output);
        GristCostRecipeBuilder.of(ESItems.COBALT_BLOCK).grist(GristTypes.COBALT, 45L).build(output);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.COBALT_BLOCK}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.COBALT_BARS, (int)24).unlockedBy("has_cobalt_block", ESRecipeProvider.has(ESItems.COBALT_BLOCK)).save(output, this.modLoc("stonecutting/cobalt_bars"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.COBALT_BLOCK}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.COBALT_DOOR, (int)4).unlockedBy("has_cobalt_block", ESRecipeProvider.has(ESItems.COBALT_BLOCK)).save(output, this.modLoc("stonecutting/cobalt_door"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.COBALT_BLOCK}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.COBALT_TRAPDOOR, (int)2).unlockedBy("has_cobalt_block", ESRecipeProvider.has(ESItems.COBALT_BLOCK)).save(output, this.modLoc("stonecutting/cobalt_trapdoor"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.COBALT_BLOCK}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.COBALT_PRESSURE_PLATE, (int)4).unlockedBy("has_cobalt_block", ESRecipeProvider.has(ESItems.COBALT_BLOCK)).save(output, this.modLoc("stonecutting/cobalt_pressure_plate"));
        CombinationRecipeBuilder.of(ESItems.SULFUROUS_STONE).input((ItemLike)Items.NETHERRACK).and().input(Tags.Items.DYES_YELLOW).build(output);
        GristCostRecipeBuilder.of(ESItems.SULFUROUS_STONE).grist(GristTypes.BUILD, 2L).grist(GristTypes.SULFUR, 4L).build(output);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.SULFUROUS_STONE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.SULFUROUS_STONE_STAIRS).unlockedBy("has_sulfurous_stone", ESRecipeProvider.has(ESItems.SULFUROUS_STONE)).save(output, this.modLoc("stonecutting/sulfurous_stone_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.SULFUROUS_STONE_STAIRS.toStack(4)).pattern("G  ").pattern("GG ").pattern("GGG").define(Character.valueOf('G'), ESItems.SULFUROUS_STONE).unlockedBy("has_sulfurous_stone", ESRecipeProvider.has(ESItems.SULFUROUS_STONE)).save(output, this.modLoc("shaped/sulfurous_stone_stairs"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.SULFUROUS_STONE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.SULFUROUS_STONE_SLAB, (int)2).unlockedBy("has_sulfurous_stone", ESRecipeProvider.has(ESItems.SULFUROUS_STONE)).save(output, this.modLoc("stonecutting/sulfurous_stone_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.SULFUROUS_STONE_SLAB.toStack(6)).pattern("GGG").define(Character.valueOf('G'), ESItems.SULFUROUS_STONE).unlockedBy("has_sulfurous_stone", ESRecipeProvider.has(ESItems.SULFUROUS_STONE)).save(output, this.modLoc("shaped/sulfurous_stone_slab"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.SULFUROUS_STONE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.SULFUROUS_STONE_WALL).unlockedBy("has_sulfurous_stone", ESRecipeProvider.has(ESItems.SULFUROUS_STONE)).save(output, this.modLoc("stonecutting/sulfurous_stone_wall"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.SULFUROUS_STONE_WALL.toStack(6)).pattern("GGG").pattern("GGG").define(Character.valueOf('G'), ESItems.SULFUROUS_STONE).unlockedBy("has_sulfurous_stone", ESRecipeProvider.has(ESItems.SULFUROUS_STONE)).save(output, this.modLoc("shaped/sulfurous_stone_wall"));
        CombinationRecipeBuilder.of(ESItems.MARBLE).input((ItemLike)MSItems.CHALK).and().input(Tags.Items.DYES_PINK).build(output);
        GristCostRecipeBuilder.of(ESItems.MARBLE).grist(GristTypes.MARBLE, 4L).build(output);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.MARBLE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.MARBLE_STAIRS).unlockedBy("has_marble", ESRecipeProvider.has(ESItems.MARBLE)).save(output, this.modLoc("stonecutting/marble_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.MARBLE_STAIRS.toStack(4)).pattern("G  ").pattern("GG ").pattern("GGG").define(Character.valueOf('G'), ESItems.MARBLE).unlockedBy("has_marble", ESRecipeProvider.has(ESItems.MARBLE)).save(output, this.modLoc("shaped/marble_stairs"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.MARBLE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.MARBLE_SLAB, (int)2).unlockedBy("has_marble", ESRecipeProvider.has(ESItems.MARBLE)).save(output, this.modLoc("stonecutting/marble_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.MARBLE_SLAB.toStack(6)).pattern("GGG").define(Character.valueOf('G'), ESItems.MARBLE).unlockedBy("has_marble", ESRecipeProvider.has(ESItems.MARBLE)).save(output, this.modLoc("shaped/marble_slab"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.MARBLE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.MARBLE_WALL).unlockedBy("has_marble", ESRecipeProvider.has(ESItems.MARBLE)).save(output, this.modLoc("stonecutting/marble_wall"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.MARBLE_WALL.toStack(6)).pattern("GGG").pattern("GGG").define(Character.valueOf('G'), ESItems.MARBLE).unlockedBy("has_marble", ESRecipeProvider.has(ESItems.MARBLE)).save(output, this.modLoc("shaped/marble_wall"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.MARBLE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.POLISHED_MARBLE).unlockedBy("has_marble", ESRecipeProvider.has(ESItems.MARBLE)).save(output, this.modLoc("stonecutting/polished_marble"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.POLISHED_MARBLE.toStack(4)).pattern("GG").pattern("GG").define(Character.valueOf('G'), ESItems.MARBLE).unlockedBy("has_marble", ESRecipeProvider.has(ESItems.MARBLE)).save(output, this.modLoc("shaped/polished_marble"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.MARBLE, ESItems.POLISHED_MARBLE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.POLISHED_MARBLE_STAIRS).unlockedBy("has_polished_marble", ESRecipeProvider.has(ESItems.POLISHED_MARBLE)).save(output, this.modLoc("stonecutting/polished_marble_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.POLISHED_MARBLE_STAIRS.toStack(4)).pattern("G  ").pattern("GG ").pattern("GGG").define(Character.valueOf('G'), ESItems.POLISHED_MARBLE).unlockedBy("has_polished_marble", ESRecipeProvider.has(ESItems.POLISHED_MARBLE)).save(output, this.modLoc("shaped/polished_marble_stairs"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.MARBLE, ESItems.POLISHED_MARBLE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.POLISHED_MARBLE_SLAB, (int)2).unlockedBy("has_polished_marble", ESRecipeProvider.has(ESItems.POLISHED_MARBLE)).save(output, this.modLoc("stonecutting/polished_marble_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.POLISHED_MARBLE_SLAB.toStack(6)).pattern("GGG").define(Character.valueOf('G'), ESItems.POLISHED_MARBLE).unlockedBy("has_polished_marble", ESRecipeProvider.has(ESItems.POLISHED_MARBLE)).save(output, this.modLoc("shaped/polished_marble_slab"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.MARBLE, ESItems.POLISHED_MARBLE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.POLISHED_MARBLE_WALL).unlockedBy("has_polished_marble", ESRecipeProvider.has(ESItems.POLISHED_MARBLE)).save(output, this.modLoc("stonecutting/polished_marble_wall"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.POLISHED_MARBLE_WALL.toStack(6)).pattern("GGG").pattern("GGG").define(Character.valueOf('G'), ESItems.POLISHED_MARBLE).unlockedBy("has_polished_marble", ESRecipeProvider.has(ESItems.POLISHED_MARBLE)).save(output, this.modLoc("shaped/polished_marble_wall"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.MARBLE, ESItems.POLISHED_MARBLE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.MARBLE_BRICKS).unlockedBy("has_marble", ESRecipeProvider.has(ESItems.MARBLE_BRICKS)).save(output, this.modLoc("stonecutting/marble_bricks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.MARBLE_BRICKS.toStack(4)).pattern("GG").pattern("GG").define(Character.valueOf('G'), ESItems.POLISHED_MARBLE).unlockedBy("has_polished_marble", ESRecipeProvider.has(ESItems.POLISHED_MARBLE)).save(output, this.modLoc("shaped/marble_bricks"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.MARBLE, ESItems.POLISHED_MARBLE, ESItems.MARBLE_BRICKS}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.MARBLE_BRICK_STAIRS).unlockedBy("has_marble_bricks", ESRecipeProvider.has(ESItems.MARBLE_BRICKS)).save(output, this.modLoc("stonecutting/marble_bricks_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.MARBLE_BRICK_STAIRS.toStack(4)).pattern("G  ").pattern("GG ").pattern("GGG").define(Character.valueOf('G'), ESItems.MARBLE_BRICKS).unlockedBy("has_marble_bricks", ESRecipeProvider.has(ESItems.MARBLE_BRICKS)).save(output, this.modLoc("shaped/marble_bricks_stairs"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.MARBLE, ESItems.POLISHED_MARBLE, ESItems.MARBLE_BRICKS}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.MARBLE_BRICK_SLAB, (int)2).unlockedBy("has_marble_bricks", ESRecipeProvider.has(ESItems.MARBLE_BRICKS)).save(output, this.modLoc("stonecutting/marble_bricks_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.MARBLE_BRICK_SLAB.toStack(6)).pattern("GGG").define(Character.valueOf('G'), ESItems.MARBLE_BRICKS).unlockedBy("has_marble_bricks", ESRecipeProvider.has(ESItems.MARBLE_BRICKS)).save(output, this.modLoc("shaped/marble_bricks_slab"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.MARBLE, ESItems.POLISHED_MARBLE, ESItems.MARBLE_BRICKS}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.MARBLE_BRICK_WALL).unlockedBy("has_marble_bricks", ESRecipeProvider.has(ESItems.MARBLE_BRICKS)).save(output, this.modLoc("stonecutting/marble_bricks_wall"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.MARBLE_BRICK_WALL.toStack(6)).pattern("GGG").pattern("GGG").define(Character.valueOf('G'), ESItems.MARBLE_BRICKS).unlockedBy("has_marble_bricks", ESRecipeProvider.has(ESItems.MARBLE_BRICKS)).save(output, this.modLoc("shaped/marble_bricks_wall"));
        CombinationRecipeBuilder.of(ESItems.ZILLIUM_BRICKS).input((ItemLike)Items.STONE_BRICKS).and().input((ItemLike)MSItems.ZILLIUM_SKITTLES).build(output);
        GristCostRecipeBuilder.of(ESItems.ZILLIUM_BRICKS).grist(GristTypes.ZILLIUM, 4L).build(output);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.ZILLIUM_BRICKS}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.ZILLIUM_BRICK_STAIRS).unlockedBy("has_zillium_bricks", ESRecipeProvider.has(ESItems.ZILLIUM_BRICKS)).save(output, this.modLoc("stonecutting/zillium_bricks_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.ZILLIUM_BRICK_STAIRS.toStack(4)).pattern("G  ").pattern("GG ").pattern("GGG").define(Character.valueOf('G'), ESItems.ZILLIUM_BRICKS).unlockedBy("has_zillium_bricks", ESRecipeProvider.has(ESItems.ZILLIUM_BRICKS)).save(output, this.modLoc("shaped/zillium_bricks_stairs"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.ZILLIUM_BRICKS}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.ZILLIUM_BRICK_SLAB, (int)2).unlockedBy("has_zillium_bricks", ESRecipeProvider.has(ESItems.ZILLIUM_BRICKS)).save(output, this.modLoc("stonecutting/zillium_bricks_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.ZILLIUM_BRICK_SLAB.toStack(6)).pattern("GGG").define(Character.valueOf('G'), ESItems.ZILLIUM_BRICKS).unlockedBy("has_zillium_bricks", ESRecipeProvider.has(ESItems.ZILLIUM_BRICKS)).save(output, this.modLoc("shaped/zillium_bricks_slab"));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ESItems.ZILLIUM_BRICKS}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ESItems.ZILLIUM_BRICK_WALL).unlockedBy("has_zillium_bricks", ESRecipeProvider.has(ESItems.ZILLIUM_BRICKS)).save(output, this.modLoc("stonecutting/zillium_bricks_wall"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)ESItems.ZILLIUM_BRICK_WALL.toStack(6)).pattern("GGG").pattern("GGG").define(Character.valueOf('G'), ESItems.ZILLIUM_BRICKS).unlockedBy("has_zillium_bricks", ESRecipeProvider.has(ESItems.ZILLIUM_BRICKS)).save(output, this.modLoc("shaped/zillium_bricks_wall"));
    }

    private ResourceLocation modLoc(String text) {
        return ResourceLocation.fromNamespaceAndPath((String)"extrastuck", (String)text);
    }
}

