/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.entities;

import com.medsal15.entities.projectiles.CaptainJusticeShield;
import com.medsal15.entities.projectiles.arrows.AmethystArrow;
import com.medsal15.entities.projectiles.arrows.CandyArrow;
import com.medsal15.entities.projectiles.arrows.CardboardArrow;
import com.medsal15.entities.projectiles.arrows.DragonArrow;
import com.medsal15.entities.projectiles.arrows.EndArrow;
import com.medsal15.entities.projectiles.arrows.ExplosiveArrow;
import com.medsal15.entities.projectiles.arrows.FlameArrow;
import com.medsal15.entities.projectiles.arrows.GlassArrow;
import com.medsal15.entities.projectiles.arrows.HealingArrow;
import com.medsal15.entities.projectiles.arrows.IronArrow;
import com.medsal15.entities.projectiles.arrows.LightningArrow;
import com.medsal15.entities.projectiles.arrows.MiningArrow;
import com.medsal15.entities.projectiles.arrows.MissedArrow;
import com.medsal15.entities.projectiles.arrows.NetherArrow;
import com.medsal15.entities.projectiles.arrows.PrismarineArrow;
import com.medsal15.entities.projectiles.arrows.QuartzArrow;
import com.medsal15.entities.projectiles.arrows.TeleportArrow;
import com.medsal15.entities.projectiles.bullets.ESBullet;
import com.medsal15.entities.projectiles.bullets.ItemBullet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ESEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"extrastuck");
    public static final Supplier<EntityType<CaptainJusticeShield>> CAPTAIN_JUSTICE_SHIELD = ENTITIES.register("captain_justice_shield", () -> EntityType.Builder.of(CaptainJusticeShield::new, (MobCategory)MobCategory.MISC).sized(1.0f, 0.25f).setTrackingRange(1).setUpdateInterval(10).build("extrastuck:captain_justice_shield"));
    public static final Supplier<EntityType<FlameArrow>> FLAME_ARROW = ESEntities.registerArrow("flame_arrow", FlameArrow::new);
    public static final Supplier<EntityType<NetherArrow>> NETHER_ARROW = ESEntities.registerArrow("nether_arrow", NetherArrow::new);
    public static final Supplier<EntityType<CardboardArrow>> CARDBOARD_ARROW = ESEntities.registerArrow("cardboard_arrow", CardboardArrow::new);
    public static final Supplier<EntityType<MissedArrow>> MISSED_ARROW = ESEntities.registerArrow("missed_arrow", MissedArrow::new);
    public static final Supplier<EntityType<CandyArrow>> CANDY_ARROW = ESEntities.registerArrow("candy_arrow", CandyArrow::new);
    public static final Supplier<EntityType<LightningArrow>> LIGHTNING_ARROW = ESEntities.registerArrow("lightning_arrow", LightningArrow::new);
    public static final Supplier<EntityType<ExplosiveArrow>> EXPLOSIVE_ARROW = ESEntities.registerArrow("explosive_arrow", ExplosiveArrow::new);
    public static final Supplier<EntityType<IronArrow>> IRON_ARROW = ESEntities.registerArrow("iron_arrow", IronArrow::new);
    public static final Supplier<EntityType<QuartzArrow>> QUARTZ_ARROW = ESEntities.registerArrow("quartz_arrow", QuartzArrow::new);
    public static final Supplier<EntityType<PrismarineArrow>> PRISMARINE_ARROW = ESEntities.registerArrow("prismarine_arrow", PrismarineArrow::new);
    public static final Supplier<EntityType<GlassArrow>> GLASS_ARROW = ESEntities.registerArrow("glass_arrow", GlassArrow::new);
    public static final Supplier<EntityType<AmethystArrow>> AMETHYST_ARROW = ESEntities.registerArrow("amethyst_arrow", AmethystArrow::new);
    public static final Supplier<EntityType<MiningArrow>> MINING_ARROW = ESEntities.registerArrow("mining_arrow", MiningArrow::new);
    public static final Supplier<EntityType<HealingArrow>> HEALING_ARROW = ESEntities.registerArrow("healing_arrow", HealingArrow::new);
    public static final Supplier<EntityType<EndArrow>> END_ARROW = ESEntities.registerArrow("end_arrow", EndArrow::new);
    public static final Supplier<EntityType<TeleportArrow>> TELEPORT_ARROW = ESEntities.registerArrow("teleport_arrow", TeleportArrow::new);
    public static final Supplier<EntityType<DragonArrow>> DRAGON_ARROW = ESEntities.registerArrow("dragon_arrow", DragonArrow::new);
    public static final Supplier<EntityType<ESBullet>> HANDGUN_BULLET = ESEntities.registerArrow("handgun_bullet", ESBullet::new);
    public static final Supplier<EntityType<ESBullet>> HEAVY_HANDGUN_BULLET = ESEntities.registerArrow("heavy_handgun_bullet", ESBullet::new);
    public static final Supplier<EntityType<ItemBullet>> ITEM_BULLET = ENTITIES.register("item_bullet", () -> EntityType.Builder.of(ItemBullet::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).setUpdateInterval(10).build("extrastuck:item_bullet"));

    private static <T extends AbstractArrow> Supplier<EntityType<T>> registerArrow(String name, EntityType.EntityFactory<T> fac) {
        return ENTITIES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)fac, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).setTrackingRange(1).setUpdateInterval(20).build("extrastuck:" + name));
    }

    public static Collection<EntityType<? extends AbstractArrow>> getArrows() {
        ArrayList<EntityType<? extends AbstractArrow>> list = new ArrayList<EntityType<? extends AbstractArrow>>();
        list.add(FLAME_ARROW.get());
        list.add(NETHER_ARROW.get());
        list.add(CARDBOARD_ARROW.get());
        list.add(MISSED_ARROW.get());
        list.add(CANDY_ARROW.get());
        list.add(LIGHTNING_ARROW.get());
        list.add(EXPLOSIVE_ARROW.get());
        list.add(IRON_ARROW.get());
        list.add(QUARTZ_ARROW.get());
        list.add(PRISMARINE_ARROW.get());
        list.add(GLASS_ARROW.get());
        list.add(AMETHYST_ARROW.get());
        list.add(MINING_ARROW.get());
        list.add(HEALING_ARROW.get());
        list.add(END_ARROW.get());
        list.add(TELEPORT_ARROW.get());
        list.add(DRAGON_ARROW.get());
        return list;
    }
}

