/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.entities.projectiles;

import com.medsal15.ESDamageTypes;
import com.medsal15.entities.ESEntities;
import com.medsal15.items.ESItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class CaptainJusticeShield
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> FOIL_ACCESSOR = SynchedEntityData.defineId(CaptainJusticeShield.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> LOYALTY_ACCESSOR = SynchedEntityData.defineId(CaptainJusticeShield.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private boolean dealtDamage;
    public int clientSideReturnTridentTickCount;

    public CaptainJusticeShield(EntityType<? extends CaptainJusticeShield> entityType, Level level) {
        super(entityType, level);
    }

    public CaptainJusticeShield(Level level, LivingEntity shooter, ItemStack pickup) {
        super(ESEntities.CAPTAIN_JUSTICE_SHIELD.get(), shooter, level, pickup, null);
        this.entityData.set(FOIL_ACCESSOR, (Object)pickup.hasFoil());
        this.entityData.set(LOYALTY_ACCESSOR, (Object)this.getLoyaltyFromItem(pickup));
    }

    public CaptainJusticeShield(Level level, double x, double y, double z, ItemStack pickup) {
        super(ESEntities.CAPTAIN_JUSTICE_SHIELD.get(), x, y, z, level, pickup, pickup);
        this.entityData.set(FOIL_ACCESSOR, (Object)pickup.hasFoil());
        this.entityData.set(LOYALTY_ACCESSOR, (Object)this.getLoyaltyFromItem(pickup));
    }

    protected void defineSynchedData(@Nonnull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FOIL_ACCESSOR, (Object)false);
        builder.define(LOYALTY_ACCESSOR, (Object)0);
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(FOIL_ACCESSOR);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ESItems.CAPTAIN_JUSTICE_SHIELD_THROWABLE.get());
    }

    public ItemStack getWeaponItem() {
        return this.getPickupItemStackOrigin();
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        byte i = (Byte)this.entityData.get(LOYALTY_ACCESSOR);
        if (i > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 vec3 = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3.y * 0.015 * (double)i, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double d0 = 0.05 * (double)i;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.tick();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.getOwner();
        return entity == null || !entity.isAlive() ? false : !(entity instanceof ServerPlayer) || !entity.isSpectator();
    }

    @Nullable
    protected EntityHitResult findHitEntity(@Nonnull Vec3 startVec, @Nonnull Vec3 endVec) {
        return this.dealtDamage ? null : super.findHitEntity(startVec, endVec);
    }

    protected void onHitEntity(@Nonnull EntityHitResult result) {
        Entity entity = result.getEntity();
        float f = 8.0f;
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().source(ESDamageTypes.CAPTAIN_JUSTICE_PROJECTILE, (Entity)this, (Entity)(entity1 == null ? this : entity1));
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)f);
        }
        this.dealtDamage = true;
        if (entity.hurt(damagesource, f)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel1 = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)entity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                this.doKnockback(livingentity, damagesource);
                this.doPostHurtEffects(livingentity);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(SoundEvents.TRIDENT_HIT, 1.0f, 1.0f);
    }

    private byte getLoyaltyFromItem(ItemStack stack) {
        byte by;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            by = (byte)Mth.clamp((int)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverlevel, (ItemStack)stack, (Entity)this), (int)0, (int)127);
        } else {
            by = 0;
        }
        return by;
    }

    public static class CJSModel
    extends Model {
        public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"extrastuck", (String)"captain_justice_shield"), "main");
        private final ModelPart root;

        public CJSModel(ModelPart root) {
            super(RenderType::entitySolid);
            this.root = root;
        }

        public static LayerDefinition createLayer() {
            MeshDefinition mesh = new MeshDefinition();
            PartDefinition root = mesh.getRoot();
            PartDefinition shield = root.addOrReplaceChild("main", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, 0.0f, -6.0f, 12.0f, 1.0f, 12.0f), PartPose.ZERO);
            shield.addOrReplaceChild("spike_d1", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.05f, -9.0f, 1.1f, 1.1f, 2.0f), PartPose.rotation((float)0.0f, (float)-0.7853982f, (float)0.0f));
            shield.addOrReplaceChild("spike_d2", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.05f, -9.0f, 1.1f, 1.1f, 2.0f), PartPose.rotation((float)0.0f, (float)0.7853982f, (float)0.0f));
            shield.addOrReplaceChild("spike_d3", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.05f, -9.0f, 1.1f, 1.1f, 2.0f), PartPose.rotation((float)0.0f, (float)2.3561945f, (float)0.0f));
            shield.addOrReplaceChild("spike_d4", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.05f, -9.0f, 1.1f, 1.1f, 2.0f), PartPose.rotation((float)0.0f, (float)-2.3561945f, (float)0.0f));
            shield.addOrReplaceChild("spike_1", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -0.05f, -7.0f, 1.1f, 1.1f, 2.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)0.0f));
            shield.addOrReplaceChild("spike_2", CubeListBuilder.create().texOffs(0, 0).addBox(1.5f, -0.05f, -7.0f, 1.1f, 1.1f, 2.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)0.0f));
            shield.addOrReplaceChild("spike_3", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -0.05f, -7.0f, 1.1f, 1.1f, 2.0f), PartPose.rotation((float)0.0f, (float)1.5707964f, (float)0.0f));
            shield.addOrReplaceChild("spike_4", CubeListBuilder.create().texOffs(0, 0).addBox(1.5f, -0.05f, -7.0f, 1.1f, 1.1f, 2.0f), PartPose.rotation((float)0.0f, (float)1.5707964f, (float)0.0f));
            shield.addOrReplaceChild("spike_5", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -0.05f, -7.0f, 1.1f, 1.1f, 2.0f), PartPose.rotation((float)0.0f, (float)((float)Math.PI), (float)0.0f));
            shield.addOrReplaceChild("spike_6", CubeListBuilder.create().texOffs(0, 0).addBox(1.5f, -0.05f, -7.0f, 1.1f, 1.1f, 2.0f), PartPose.rotation((float)0.0f, (float)((float)Math.PI), (float)0.0f));
            shield.addOrReplaceChild("spike_7", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -0.05f, -7.0f, 1.1f, 1.1f, 2.0f), PartPose.rotation((float)0.0f, (float)-1.5707964f, (float)0.0f));
            shield.addOrReplaceChild("spike_8", CubeListBuilder.create().texOffs(0, 0).addBox(1.5f, -0.05f, -7.0f, 1.1f, 1.1f, 2.0f), PartPose.rotation((float)0.0f, (float)-1.5707964f, (float)0.0f));
            return LayerDefinition.create((MeshDefinition)mesh, (int)48, (int)13);
        }

        public void renderToBuffer(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
            this.root.render(poseStack, buffer, packedLight, packedOverlay, color);
        }
    }

    public static class CJSRenderer
    extends EntityRenderer<CaptainJusticeShield> {
        public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"extrastuck", (String)"textures/entity/captain_justice_shield.png");
        private final CJSModel model;

        public CJSRenderer(EntityRendererProvider.Context context) {
            super(context);
            this.model = new CJSModel(context.bakeLayer(CJSModel.LAYER_LOCATION));
        }

        public void render(@Nonnull CaptainJusticeShield entity, float entityYaw, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
            VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.model.renderType(this.getTextureLocation(entity)), (boolean)false, (boolean)entity.isFoil());
            this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
            super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }

        public ResourceLocation getTextureLocation(@Nonnull CaptainJusticeShield entity) {
            return TEXTURE;
        }
    }
}

