/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.entities.projectiles.arrows;

import com.medsal15.entities.ESEntities;
import com.medsal15.items.ESItems;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class ExplosiveArrow
extends AbstractArrow {
    private boolean landed;

    public ExplosiveArrow(EntityType<? extends ExplosiveArrow> entityType, Level level) {
        super(entityType, level);
    }

    public ExplosiveArrow(Level level, ItemStack pickup, LivingEntity shooter, ItemStack weapon) {
        super(ESEntities.EXPLOSIVE_ARROW.get(), shooter, level, pickup, weapon);
    }

    public ExplosiveArrow(Level level, double x, double y, double z, ItemStack pickup, ItemStack weapon) {
        super(ESEntities.EXPLOSIVE_ARROW.get(), x, y, z, level, pickup, weapon);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ESItems.EXPLOSIVE_ARROW.get());
    }

    protected void onHit(@Nonnull HitResult result) {
        super.onHit(result);
        if (!this.landed) {
            Explosion exp = new Explosion(this.level(), (Entity)this, this.getX(), this.getY(), this.getZ(), 2.0f, this.wasOnFire, Explosion.BlockInteraction.KEEP);
            exp.explode();
            exp.finalizeExplosion(true);
            this.landed = true;
        }
    }

    public void addAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("extrastuck:landed", this.landed);
    }

    public void readAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.landed = compound.getBoolean("extrastuck:landed");
    }
}

