/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.entities.projectiles.arrows;

import com.medsal15.entities.ESEntities;
import com.medsal15.items.ESItems;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class FlameArrow
extends AbstractArrow {
    public FlameArrow(EntityType<? extends FlameArrow> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(1.0);
    }

    public FlameArrow(Level level, ItemStack pickup, LivingEntity shooter, ItemStack weapon) {
        super(ESEntities.FLAME_ARROW.get(), shooter, level, pickup, weapon);
        this.setBaseDamage(1.0);
    }

    public FlameArrow(Level level, double x, double y, double z, ItemStack pickup, ItemStack weapon) {
        super(ESEntities.FLAME_ARROW.get(), x, y, z, level, pickup, weapon);
        this.setBaseDamage(1.0);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ESItems.FLAME_ARROW.get());
    }

    protected void onHitEntity(@Nonnull EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        int duration = 200;
        if (this.isCritArrow()) {
            duration *= 2;
        }
        living.setRemainingFireTicks(duration);
    }

    protected void onHitBlock(@Nonnull BlockHitResult result) {
        super.onHitBlock(result);
        if (result.getType() == HitResult.Type.MISS) {
            return;
        }
        if (this.level() instanceof ServerLevel) {
            BlockPos target;
            switch (result.getDirection()) {
                case UP: {
                    target = result.getBlockPos().above();
                    break;
                }
                case DOWN: {
                    target = result.getBlockPos().below();
                    break;
                }
                case EAST: {
                    target = result.getBlockPos().east();
                    break;
                }
                case WEST: {
                    target = result.getBlockPos().west();
                    break;
                }
                case NORTH: {
                    target = result.getBlockPos().north();
                    break;
                }
                case SOUTH: {
                    target = result.getBlockPos().south();
                    break;
                }
                default: {
                    return;
                }
            }
            if (FireBlock.canBePlacedAt((Level)this.level(), (BlockPos)target, (Direction)this.getDirection())) {
                this.level().setBlock(target, BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)target), 11);
            }
        }
    }
}

