/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.entities.projectiles.arrows;

import com.medsal15.entities.ESEntities;
import com.medsal15.items.ESItems;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class HealingArrow
extends AbstractArrow {
    public HealingArrow(EntityType<? extends HealingArrow> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(0.0);
    }

    public HealingArrow(Level level, ItemStack pickup, LivingEntity shooter, ItemStack weapon) {
        super(ESEntities.HEALING_ARROW.get(), shooter, level, pickup, weapon);
        this.setBaseDamage(0.0);
    }

    public HealingArrow(Level level, double x, double y, double z, ItemStack pickup, ItemStack weapon) {
        super(ESEntities.HEALING_ARROW.get(), x, y, z, level, pickup, weapon);
        this.setBaseDamage(0.0);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ESItems.CRUSADER_CROSSBOLT.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onHitEntity(@Nonnull EntityHitResult result) {
        LivingEntity entity;
        block2: {
            Entity owner;
            block3: {
                TamableAnimal tame;
                super.onHitEntity(result);
                Entity ent = result.getEntity();
                if (!(ent instanceof LivingEntity)) return;
                entity = (LivingEntity)ent;
                owner = this.getOwner();
                if (owner == null || owner.getTeam() == null) break block2;
                if (!(owner instanceof LivingEntity)) break block3;
                LivingEntity lowner = (LivingEntity)owner;
                if (ent instanceof TamableAnimal && (tame = (TamableAnimal)ent).isOwnedBy(lowner)) break block2;
            }
            if (!entity.isAlliedTo(owner)) return;
        }
        boolean bl = true;
        boolean canHeal = bl;
        if (!canHeal) return;
        entity.heal(5.0f);
    }
}

