/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.entities.projectiles.arrows;

import com.medsal15.entities.ESEntities;
import com.medsal15.items.ESItems;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class MiningArrow
extends AbstractArrow {
    private boolean mined;

    public MiningArrow(EntityType<? extends MiningArrow> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(3.0);
    }

    public MiningArrow(Level level, ItemStack pickup, LivingEntity shooter, ItemStack weapon) {
        super(ESEntities.MINING_ARROW.get(), shooter, level, pickup, weapon);
        this.setBaseDamage(3.0);
    }

    public MiningArrow(Level level, double x, double y, double z, ItemStack pickup, ItemStack weapon) {
        super(ESEntities.MINING_ARROW.get(), x, y, z, level, pickup, weapon);
        this.setBaseDamage(3.0);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ESItems.PROJECDRILL.get());
    }

    protected void onHitBlock(@Nonnull BlockHitResult result) {
        super.onHitBlock(result);
        if (result.getType() == HitResult.Type.MISS || this.mined) {
            return;
        }
        if (this.level() instanceof ServerLevel) {
            this.mined = true;
            BlockPos pos = result.getBlockPos();
            BlockState blockState = this.level().getBlockState(pos);
            if (!blockState.is(BlockTags.INCORRECT_FOR_IRON_TOOL) && blockState.getDestroySpeed((BlockGetter)this.level(), pos) != -1.0f) {
                this.level().destroyBlock(pos, true, this.getOwner());
            }
        }
    }

    public void addAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("extrastuck:mined", this.mined);
    }

    public void readAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.mined = compound.getBoolean("extrastuck:mined");
    }
}

