/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.entities.projectiles.arrows;

import com.medsal15.entities.ESEntities;
import com.medsal15.items.ESItems;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class NetherArrow
extends AbstractArrow {
    public NetherArrow(EntityType<? extends NetherArrow> entityType, Level level) {
        super(entityType, level);
    }

    public NetherArrow(Level level, ItemStack pickup, LivingEntity shooter, ItemStack weapon) {
        super(ESEntities.NETHER_ARROW.get(), shooter, level, pickup, weapon);
    }

    public NetherArrow(Level level, double x, double y, double z, ItemStack pickup, ItemStack weapon) {
        super(ESEntities.NETHER_ARROW.get(), x, y, z, level, pickup, weapon);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ESItems.NETHER_ARROW.get());
    }

    protected void onHitEntity(@Nonnull EntityHitResult result) {
        Entity entity = result.getEntity();
        double baseDamage = this.getBaseDamage();
        if (entity.getRemainingFireTicks() > 0) {
            this.setBaseDamage(baseDamage * 1.5);
        }
        super.onHitEntity(result);
        this.setBaseDamage(baseDamage);
    }
}

