/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.entities.projectiles.arrows;

import com.medsal15.entities.ESEntities;
import com.medsal15.items.ESItems;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class TeleportArrow
extends AbstractArrow {
    private boolean hit;

    public TeleportArrow(EntityType<? extends TeleportArrow> entityType, Level level) {
        super(entityType, level);
    }

    public TeleportArrow(Level level, ItemStack pickup, LivingEntity shooter, ItemStack weapon) {
        super(ESEntities.TELEPORT_ARROW.get(), shooter, level, pickup, weapon);
    }

    public TeleportArrow(Level level, double x, double y, double z, ItemStack pickup, ItemStack weapon) {
        super(ESEntities.TELEPORT_ARROW.get(), x, y, z, level, pickup, weapon);
    }

    protected ItemStack getDefaultPickupItem() {
        return ESItems.TELERROW.toStack();
    }

    protected void onHitBlock(@Nonnull BlockHitResult result) {
        super.onHitBlock(result);
        Entity owner = this.getOwner();
        Level level = this.level();
        if (!this.hit && owner != null && this.canTeleport(owner, level) && level instanceof ServerLevel) {
            Endermite endermite;
            ServerLevel serverLevel = (ServerLevel)level;
            owner.teleportTo(this.getX(), this.getY(), this.getZ());
            if (serverLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && this.random.nextFloat() < 0.05f && (endermite = (Endermite)EntityType.ENDERMITE.create((Level)serverLevel)) != null) {
                endermite.moveTo(this.getX(), this.getY(), this.getZ());
                serverLevel.addFreshEntity((Entity)endermite);
            }
            Holder.Reference type = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.FALL);
            owner.hurt(new DamageSource((Holder)type), 5.0f);
            this.hit = true;
        }
        this.discard();
    }

    protected void onHitEntity(@Nonnull EntityHitResult result) {
        super.onHitEntity(result);
        Entity owner = this.getOwner();
        Entity target = result.getEntity();
        Level level = this.level();
        if (!this.hit && owner != null && this.canTeleport(owner, level) && this.canTeleport(target, level) && level instanceof ServerLevel) {
            Endermite endermite;
            ServerLevel serverLevel = (ServerLevel)level;
            double x = target.getX();
            double y = target.getY();
            double z = target.getZ();
            target.teleportTo(owner.getX(), owner.getY(), owner.getZ());
            owner.teleportTo(x, y, z);
            if (serverLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && this.random.nextFloat() < 0.05f && (endermite = (Endermite)EntityType.ENDERMITE.create((Level)serverLevel)) != null) {
                endermite.moveTo(x, y, z);
                serverLevel.addFreshEntity((Entity)endermite);
            }
            Holder.Reference type = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.FALL);
            owner.hurt(new DamageSource((Holder)type), 5.0f);
            target.hurt(new DamageSource((Holder)type), 5.0f);
            this.hit = true;
        }
    }

    private boolean canTeleport(Entity entity, Level level) {
        if (entity.level().dimension() == level.dimension()) {
            boolean bl;
            if (!(entity instanceof LivingEntity)) {
                bl = entity.isAlive();
            } else {
                LivingEntity livingentity = (LivingEntity)entity;
                bl = livingentity.isAlive() && !livingentity.isSleeping();
            }
            return bl;
        }
        return entity.canUsePortal(true);
    }

    public void addAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("extrastuck:hit", this.hit);
    }

    public void readAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.hit = compound.getBoolean("extrastuck:hit");
    }
}

