/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.entities.projectiles.bullets;

import com.medsal15.items.ESDataComponents;
import com.medsal15.items.projectiles.IAsProjectile;
import com.medsal15.items.projectiles.ICreateArrow;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class ESBullet
extends AbstractArrow {
    public ESBullet(EntityType<? extends ESBullet> type, Level level) {
        super(type, level);
        this.setNoGravity(true);
    }

    public ESBullet(EntityType<? extends ESBullet> type, Level level, ItemStack pickup, LivingEntity shooter, ItemStack weapon) {
        super(type, shooter, level, pickup, weapon);
        this.setNoGravity(true);
        if (pickup.has(ESDataComponents.AMMO_DAMAGE)) {
            this.setBaseDamage(((Float)pickup.get(ESDataComponents.AMMO_DAMAGE)).floatValue());
        }
    }

    public ESBullet(EntityType<? extends ESBullet> type, Level level, double x, double y, double z, ItemStack pickup, ItemStack weapon) {
        super(type, x, y, z, level, pickup, weapon);
        this.setNoGravity(true);
        if (pickup.has(ESDataComponents.AMMO_DAMAGE)) {
            this.setBaseDamage(((Float)pickup.get(ESDataComponents.AMMO_DAMAGE)).floatValue());
        }
    }

    public static ICreateArrow createArrow(EntityType<? extends ESBullet> type) {
        return (level, ammo, shooter, weapon) -> new ESBullet(type, level, ammo, shooter, weapon);
    }

    public static IAsProjectile asProjectile(EntityType<? extends ESBullet> type) {
        return (level, x, y, z, stack, weapon) -> new ESBullet(type, level, x, y, z, stack, weapon);
    }

    protected void onHitEntity(@Nonnull EntityHitResult result) {
        double damage = this.getBaseDamage();
        this.setBaseDamage(damage / this.getDeltaMovement().length());
        super.onHitEntity(result);
        this.setBaseDamage(damage);
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    protected void onHitBlock(@Nonnull BlockHitResult result) {
        this.discard();
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.METAL_PRESSURE_PLATE_CLICK_ON;
    }
}

