/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.interpreters.create;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.DefaultInterpreter;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.fml.ModList;

public record CreateBasicInterpreter(GristSet.Immutable processCost) implements RecipeInterpreter
{
    public static final MapCodec<CreateBasicInterpreter> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)GristSet.Codecs.MAP_CODEC.optionalFieldOf("process_cost", (Object)GristSet.EMPTY).forGetter(CreateBasicInterpreter::processCost)).apply((Applicative)inst, CreateBasicInterpreter::new));

    public MapCodec<? extends RecipeInterpreter> codec() {
        return CODEC;
    }

    public List<Item> getOutputItems(Recipe<?> recipe) {
        return DefaultInterpreter.INSTANCE.getOutputItems(recipe);
    }

    public GristSet generateCost(Recipe<?> recipe, Item output, GeneratorCallback callback) {
        if (!ModList.get().isLoaded("create") || !(recipe instanceof ProcessingRecipe)) {
            return null;
        }
        ProcessingRecipe proc = (ProcessingRecipe)recipe;
        if (proc.getFluidIngredients().size() > 0 || proc.getFluidResults().size() > 0) {
            return null;
        }
        int count = 0;
        for (ItemStack stack : proc.getRollableResultsAsItemStacks()) {
            if (stack.getItem() != output) {
                return null;
            }
            count += stack.getCount();
        }
        MutableGristSet totalCost = MutableGristSet.newDefault();
        totalCost.add((GristSet)this.processCost);
        for (Ingredient ingredient : proc.getIngredients()) {
            GristSet cost = callback.lookupCostFor(ingredient);
            if (cost == null) {
                return null;
            }
            totalCost.add(cost);
        }
        totalCost.scale(1.0f / (float)count, false);
        return totalCost;
    }

    public void reportPreliminaryLookups(Recipe<?> recipe, LookupTracker tracker) {
        DefaultInterpreter.INSTANCE.reportPreliminaryLookups(recipe, tracker);
    }
}

