/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.interpreters.create;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.DefaultInterpreter;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.fml.ModList;

public enum ItemApplicationInterpreter implements RecipeInterpreter
{
    INSTANCE;

    public static final MapCodec<ItemApplicationInterpreter> CODEC;

    public MapCodec<? extends RecipeInterpreter> codec() {
        return CODEC;
    }

    public List<Item> getOutputItems(Recipe<?> recipe) {
        return DefaultInterpreter.INSTANCE.getOutputItems(recipe);
    }

    public GristSet generateCost(Recipe<?> recipe, Item output, GeneratorCallback callback) {
        if (!ModList.get().isLoaded("create") || !(recipe instanceof ItemApplicationRecipe)) {
            return null;
        }
        ItemApplicationRecipe apply = (ItemApplicationRecipe)recipe;
        int count = 0;
        for (ItemStack stack : apply.getRollableResultsAsItemStacks()) {
            if (stack.getItem() != output) {
                return null;
            }
            count += stack.getCount();
        }
        MutableGristSet totalCost = MutableGristSet.newDefault();
        GristSet baseCost = callback.lookupCostFor(apply.getProcessedItem());
        if (baseCost == null) {
            return null;
        }
        totalCost.add(baseCost);
        if (!apply.shouldKeepHeldItem()) {
            GristSet heldCost = callback.lookupCostFor(apply.getRequiredHeldItem());
            if (heldCost == null) {
                return null;
            }
            totalCost.add(heldCost);
        }
        totalCost.scale(1.0f / (float)count, false);
        return totalCost;
    }

    public void reportPreliminaryLookups(Recipe<?> recipe, LookupTracker tracker) {
        DefaultInterpreter.INSTANCE.reportPreliminaryLookups(recipe, tracker);
    }

    static {
        CODEC = MapCodec.unit((Object)((Object)INSTANCE));
    }
}

