/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.items;

import com.medsal15.items.ESDataComponents;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class ESEnergyStorage
implements IEnergyStorage,
ICapabilityProvider<ItemStack, Void, IEnergyStorage> {
    private final ItemStack stack;

    public ESEnergyStorage(ItemStack stack) {
        this.stack = stack;
    }

    public int getMaxEnergyStored() {
        if (this.stack.has(ESDataComponents.ENERGY_STORAGE)) {
            return (Integer)this.stack.get(ESDataComponents.ENERGY_STORAGE);
        }
        return 0;
    }

    public int getEnergyStored() {
        if (this.stack.has(ESDataComponents.ENERGY)) {
            return (Integer)this.stack.get(ESDataComponents.ENERGY);
        }
        return 0;
    }

    public boolean canExtract() {
        return this.stack.has(ESDataComponents.ENERGY) || this.stack.has(ESDataComponents.ENERGY_STORAGE);
    }

    public boolean canReceive() {
        return this.stack.has(ESDataComponents.ENERGY_STORAGE);
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        if (this.stack.has(ESDataComponents.ENERGY)) {
            int stored = (Integer)this.stack.get(ESDataComponents.ENERGY);
            int energy = Math.min(toExtract, (Integer)this.stack.get(ESDataComponents.ENERGY));
            if (!simulate) {
                int left = stored - energy;
                this.stack.set(ESDataComponents.ENERGY, (Object)left);
            }
            return energy;
        }
        return 0;
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        if (this.stack.has(ESDataComponents.ENERGY_STORAGE)) {
            int max = (Integer)this.stack.get(ESDataComponents.ENERGY_STORAGE);
            int stored = (Integer)this.stack.getOrDefault(ESDataComponents.ENERGY, (Object)0);
            int charge = Math.min(toReceive, max - stored);
            if (!simulate) {
                this.stack.set(ESDataComponents.ENERGY, (Object)Math.min(max, stored + charge));
            }
            return charge;
        }
        return 0;
    }

    @Nullable
    public IEnergyStorage getCapability(@Nonnull ItemStack object, @Nonnull Void context) {
        return this;
    }
}

