/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.items;

import com.medsal15.ExtraStuck;
import com.medsal15.mobeffects.ESMobEffects;
import com.mraof.minestuck.entity.item.GristEntity;
import com.mraof.minestuck.entity.item.VitalityGelEntity;
import com.mraof.minestuck.item.weapon.OnHitEffect;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.EnumClass;
import com.mraof.minestuck.player.Title;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public final class ESHitEffects {
    public static void stealLuck(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            Optional title = Title.getTitle((ServerPlayer)player);
            if (player.isCreative() || !title.isEmpty() && (((Title)title.get()).heroAspect() == EnumAspect.LIGHT || ((Title)title.get()).heroClass() == EnumClass.THIEF)) {
                target.addEffect(new MobEffectInstance(MobEffects.UNLUCK, 50));
                attacker.addEffect(new MobEffectInstance(MobEffects.LUCK, 50));
            }
        }
    }

    public static void timeStop(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        ServerPlayer player;
        int duration = 100;
        if (attacker instanceof ServerPlayer && ((player = (ServerPlayer)attacker).isCreative() || Title.isPlayerOfAspect((ServerPlayer)player, (EnumAspect)EnumAspect.TIME))) {
            duration = 300;
        }
        target.addEffect(new MobEffectInstance(ESMobEffects.TIME_STOP, duration));
    }

    public static OnHitEffect randomDamage(int maxDamage) {
        return (stack, target, attacker) -> {
            AttributeInstance luckatin;
            DamageSource source;
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                source = attacker.damageSources().playerAttack(player);
            } else {
                source = attacker.damageSources().mobAttack(attacker);
            }
            float rng = attacker.getRandom().nextInt(maxDamage) + 1;
            if (stack.has(DataComponents.ATTRIBUTE_MODIFIERS)) {
                ItemAttributeModifiers modifiers = stack.getAttributeModifiers();
                for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
                    if (entry.attribute() != Attributes.ATTACK_DAMAGE) continue;
                    rng = (float)((double)rng + entry.modifier().amount());
                }
            }
            if ((luckatin = attacker.getAttribute(Attributes.LUCK)) != null) {
                rng += (float)luckatin.getValue();
            }
            target.hurt(source, rng);
        };
    }

    public static OnHitEffect chanceDrop(Supplier<ItemStack> item, float chance, @Nullable Supplier<String> message) {
        return (stack, target, attacker) -> {
            if (attacker.getRandom().nextFloat() < chance) {
                ItemStack itemStack = ((ItemStack)item.get()).copy();
                ItemEntity entity = new ItemEntity(attacker.level(), target.getX(), target.getY(), target.getZ(), itemStack);
                attacker.level().addFreshEntity((Entity)entity);
                if (message != null) {
                    attacker.sendSystemMessage((Component)Component.translatable((String)((String)message.get())));
                }
            }
        };
    }

    public static void rainbowEffect(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int rng = attacker.getRandom().nextInt(7);
        Holder effect = null;
        switch (rng) {
            case 0: {
                effect = MobEffects.DAMAGE_BOOST;
                break;
            }
            case 1: {
                effect = MobEffects.DAMAGE_RESISTANCE;
                break;
            }
            case 2: {
                effect = MobEffects.UNLUCK;
                break;
            }
            case 3: {
                effect = MobEffects.LUCK;
                break;
            }
            case 4: {
                effect = MobEffects.MOVEMENT_SPEED;
                break;
            }
            case 5: {
                effect = MobEffects.MOVEMENT_SLOWDOWN;
                break;
            }
            case 6: {
                effect = MobEffects.LEVITATION;
                break;
            }
            default: {
                ExtraStuck.LOGGER.error("rainbowEffect rolled a {} even though it shouldn't be above 6", (Object)rng);
            }
        }
        if (effect != null) {
            target.addEffect(new MobEffectInstance(effect, 77));
            attacker.addEffect(new MobEffectInstance(effect, 77));
        }
    }

    public static OnHitEffect dayNightEffect(OnHitEffect day, OnHitEffect night) {
        return (stack, target, attacker) -> {
            Level level = target.level();
            long time = level.getDayTime();
            if (time >= 6000L && time < 18000L) {
                day.onHit(stack, target, attacker);
            } else {
                day.onHit(stack, target, attacker);
            }
        };
    }

    public static void randomMaxDamage(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        DamageSource source;
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            source = attacker.damageSources().playerAttack(player);
        } else {
            source = attacker.damageSources().mobAttack(attacker);
        }
        float rng = 0.0f;
        if (!Float.isInfinite(target.getMaxHealth())) {
            rng = attacker.getRandom().nextFloat() * target.getHealth();
        }
        target.hurt(source, rng);
    }

    public static OnHitEffect attractItemsGrist(double range) {
        return (stack, target, attacker) -> {
            Consumer<Entity> consumer;
            AABB box = new AABB(target.blockPosition()).inflate(range);
            List entities = attacker.level().getEntities((Entity)target, box, e -> e instanceof ItemEntity || e instanceof GristEntity || e instanceof VitalityGelEntity);
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                consumer = e -> {
                    if (!ESHitEffects.giveToPlayer(player, e)) {
                        e.setPos(attacker.position());
                    }
                };
            } else {
                consumer = e -> e.setPos(attacker.position());
            }
            Consumer<Entity> apply = consumer;
            for (Entity entity : entities) {
                apply.accept(entity);
            }
        };
    }

    private static boolean giveToPlayer(Player player, Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            boolean success = player.addItem(item.getItem());
            if (success) {
                item.discard();
            }
            return success;
        }
        if (entity instanceof GristEntity) {
            GristEntity grist = (GristEntity)entity;
            grist.playerTouch(player);
            return true;
        }
        if (entity instanceof VitalityGelEntity) {
            VitalityGelEntity gel = (VitalityGelEntity)entity;
            gel.playerTouch(player);
            return true;
        }
        return false;
    }

    public static OnHitEffect requireCharge(int charge, OnHitEffect effect, boolean consume) {
        return (stack, target, attacker) -> {
            IEnergyStorage energyStorage = (IEnergyStorage)Capabilities.EnergyStorage.ITEM.getCapability(stack, null);
            if (energyStorage != null && energyStorage.getEnergyStored() >= charge) {
                if (consume) {
                    energyStorage.extractEnergy(charge, false);
                }
                effect.onHit(stack, target, attacker);
            }
        };
    }

    public static OnHitEffect requireCharge(int charge, OnHitEffect effect) {
        return ESHitEffects.requireCharge(charge, effect, true);
    }
}

