/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.items;

import com.medsal15.ESSounds;
import com.medsal15.ExtraStuck;
import com.medsal15.blocks.ESBlocks;
import com.medsal15.data.ESItemTags;
import com.medsal15.data.ESLangProvider;
import com.medsal15.data.loot_tables.ESLootSubProvider;
import com.medsal15.entities.ESEntities;
import com.medsal15.entities.projectiles.arrows.AmethystArrow;
import com.medsal15.entities.projectiles.arrows.CandyArrow;
import com.medsal15.entities.projectiles.arrows.CardboardArrow;
import com.medsal15.entities.projectiles.arrows.DragonArrow;
import com.medsal15.entities.projectiles.arrows.EndArrow;
import com.medsal15.entities.projectiles.arrows.ExplosiveArrow;
import com.medsal15.entities.projectiles.arrows.FlameArrow;
import com.medsal15.entities.projectiles.arrows.GlassArrow;
import com.medsal15.entities.projectiles.arrows.HealingArrow;
import com.medsal15.entities.projectiles.arrows.IronArrow;
import com.medsal15.entities.projectiles.arrows.LightningArrow;
import com.medsal15.entities.projectiles.arrows.MiningArrow;
import com.medsal15.entities.projectiles.arrows.MissedArrow;
import com.medsal15.entities.projectiles.arrows.NetherArrow;
import com.medsal15.entities.projectiles.arrows.PrismarineArrow;
import com.medsal15.entities.projectiles.arrows.QuartzArrow;
import com.medsal15.entities.projectiles.arrows.TeleportArrow;
import com.medsal15.entities.projectiles.bullets.ESBullet;
import com.medsal15.items.ESArmorMaterials;
import com.medsal15.items.ESDataComponents;
import com.medsal15.items.ESHitEffects;
import com.medsal15.items.ESInventoryTickEffects;
import com.medsal15.items.ESItemTiers;
import com.medsal15.items.ESItemTypes;
import com.medsal15.items.ESRightClickBlockEffects;
import com.medsal15.items.GiftItem;
import com.medsal15.items.MagnetItem;
import com.medsal15.items.Tokenitem;
import com.medsal15.items.armor.ChefArmorItem;
import com.medsal15.items.armor.PropellerHatItem;
import com.medsal15.items.food.FortuneCookie;
import com.medsal15.items.guns.ESGun;
import com.medsal15.items.melee.AltGunWeapon;
import com.medsal15.items.melee.BrushWeapon;
import com.medsal15.items.melee.InnateEnchantsWeapon;
import com.medsal15.items.projectiles.ESArrowItem;
import com.medsal15.items.projectiles.ESBulletItem;
import com.medsal15.items.shields.ESShield;
import com.medsal15.items.throwables.SwapTrident;
import com.mraof.minestuck.item.MSItemProperties;
import com.mraof.minestuck.item.MSItemTypes;
import com.mraof.minestuck.item.armor.MSArmorItem;
import com.mraof.minestuck.item.weapon.InventoryTickEffect;
import com.mraof.minestuck.item.weapon.ItemRightClickEffect;
import com.mraof.minestuck.item.weapon.MSToolType;
import com.mraof.minestuck.item.weapon.MagicRangedRightClickEffect;
import com.mraof.minestuck.item.weapon.OnHitEffect;
import com.mraof.minestuck.item.weapon.WeaponItem;
import com.mraof.minestuck.util.MSSoundEvents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import vazkii.patchouli.common.item.ItemModBook;

public final class ESItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"extrastuck");
    public static final DeferredItem<Item> FLAME_SHIELD = ITEMS.registerItem("flame_shield", p -> new ESShield(p.durability(80).component(ESDataComponents.BURN_DURATION, (Object)100), ESShield.BlockFuncs::burn));
    public static final DeferredItem<Item> WOODEN_SHIELD = ITEMS.registerItem("wooden_shield", p -> new ESShield(p.durability(80), ESShield.BlockFuncs.replace(FLAME_SHIELD, (TagKey<DamageType>)DamageTypeTags.IS_FIRE)));
    public static final DeferredItem<Item> HALT_SHIELD = ITEMS.registerItem("halt_shield", p -> new ESShield(p.durability(243), ESShield.BlockFuncs::strongerKnockback, ESShield.BlockFuncs.turn(180.0f)));
    public static final DeferredItem<Item> NON_CONTACT_CONTRACT = ITEMS.registerItem("non_contact_contract", ESShield::new, new Item.Properties().durability(328));
    public static final DeferredItem<Item> SLIED = ITEMS.registerItem("slied", p -> new ESShield(p.durability(59), ESShield.BlockFuncs.selfDropChance(0.25f, () -> ESLangProvider.SLIED_DROP_KEY)));
    public static final DeferredItem<Item> RIOT_SHIELD = ITEMS.registerItem("riot_shield", ESShield::new, new Item.Properties().durability(328));
    public static final DeferredItem<Item> CAPITASHIELD = ITEMS.registerItem("capitashield", p -> new ESShield(p.durability(130), ESShield.BlockFuncs::consumeBoondollars));
    public static final DeferredItem<Item> IRON_SHIELD = ITEMS.registerItem("iron_shield", ESShield::new, new Item.Properties().durability(480));
    public static final DeferredItem<Item> GOLD_SHIELD = ITEMS.registerItem("gold_shield", ESShield::new, new Item.Properties().durability(980));
    public static final DeferredItem<Item> DIAMOND_SHIELD = ITEMS.registerItem("diamond_shield", ESShield::new, new Item.Properties().durability(1561));
    public static final DeferredItem<Item> NETHERITE_SHIELD = ITEMS.registerItem("netherite_shield", ESShield::new, new Item.Properties().durability(1561).fireResistant().attributes(ItemAttributeModifiers.builder().add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(ExtraStuck.modid("netherite_shield"), 0.1, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.OFFHAND).build()));
    public static final DeferredItem<Item> GARNET_SHIELD = ITEMS.registerItem("garnet_shield", ESShield::new, new Item.Properties().durability(2560).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_SPEED, new AttributeModifier(ExtraStuck.modid("garnet_shield"), 0.1, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.OFFHAND).build()));
    public static final DeferredItem<Item> POGO_SHIELD = ITEMS.registerItem("pogo_shield", p -> new ESShield(p.durability(450), ESShield.BlockFuncs.bounceProjectiles((projectile, entity, random) -> {
        double mx = random.nextDouble() * 4.0 + 1.0;
        double fx = random.nextBoolean() ? mx : 1.0 / mx;
        double mz = random.nextDouble() * 4.0 + 1.0;
        double fz = random.nextBoolean() ? mz : 1.0 / mz;
        projectile.setDeltaMovement(projectile.getDeltaMovement().multiply(fx, 1.0, fz));
    })));
    public static final DeferredItem<Item> RETURN_TO_SENDER = ITEMS.registerItem("return_to_sender", p -> new ESShield(p.durability(1353), ESShield.BlockFuncs.bounceProjectiles((projectile, entity, random) -> {
        if (entity != null) {
            Vec3 vec3 = entity.getLookAngle().normalize().multiply(-4.0, -4.0, -4.0);
            projectile.setDeltaMovement(vec3);
            projectile.hasImpulse = true;
        }
    })));
    public static final DeferredItem<Item> SPIKES_ON_A_SLAB = ITEMS.registerItem("spikes_on_a_slab", p -> new ESShield(p.durability(732).component(ESDataComponents.SHIELD_DAMAGE, (Object)Float.valueOf(6.0f)), ESShield.BlockFuncs.DAMAGE));
    public static final DeferredItem<Item> JAWBITER = ITEMS.registerItem("jawbiter", p -> new ESShield(p.durability(612).component(ESDataComponents.SHIELD_DAMAGE, (Object)Float.valueOf(8.0f)), ESShield.BlockFuncs.DAMAGE, ESShield.BlockFuncs::dropCandy));
    public static final DeferredItem<Item> FLUX_SHIELD = ITEMS.registerItem("flux_shield", p -> new ESShield(p.durability(490).component(ESDataComponents.ENERGY_STORAGE, (Object)100000).component(ESDataComponents.FLUX_MULTIPLIER, (Object)100), ESShield.BlockFuncs.USE_POWER));
    public static final DeferredItem<Item> LIGHT_SHIELD = ITEMS.registerItem("light_shield", p -> new ESShield(p.durability(880).component(ESDataComponents.BURN_DURATION, (Object)600), ESShield.BlockFuncs::burn));
    public static final DeferredItem<Item> ELDRITCH_SHIELD = ITEMS.registerItem("eldritch_shield", p -> new ESShield(p.durability(1441).component(ESDataComponents.SHIELD_DAMAGE, (Object)Float.valueOf(10.0f)), ESShield.BlockFuncs.DAMAGE, ESShield.BlockFuncs.gainEffect((Holder<MobEffect>)MobEffects.DAMAGE_BOOST, 100)));
    public static final DeferredItem<Item> CAPTAIN_JUSTICE_THROWABLE_SHIELD = ITEMS.registerItem("captain_justice_throwable_shield", p -> new ESShield(p.durability(789), CAPTAIN_JUSTICE_SHIELD_THROWABLE));
    public static final DeferredItem<Item> CAPTAIN_JUSTICE_SHIELD_THROWABLE = ITEMS.registerItem("captain_justice_shield_throwable", p -> new SwapTrident(p.durability(789), CAPTAIN_JUSTICE_THROWABLE_SHIELD));
    public static final DeferredItem<Item> GIFT_OF_PROTECTION = ITEMS.registerItem("gift_protection", p -> new ESShield(p.durability(624), ESShield.BlockFuncs.itemDropChance(() -> GIFT.toStack(), 0.1f, () -> ESLangProvider.GIFT_PROTECTION_GIFT_KEY)));
    public static final DeferredItem<Item> NETHER_ARROW = ITEMS.registerItem("nether_arrow", p -> new ESArrowItem((Item.Properties)p, NetherArrow::new, NetherArrow::new));
    public static final DeferredItem<Item> FLAME_ARROW = ITEMS.registerItem("flame_arrow", p -> new ESArrowItem((Item.Properties)p, FlameArrow::new, FlameArrow::new));
    public static final DeferredItem<Item> CARDBOARD_ARROW = ITEMS.registerItem("cardboard_arrow", p -> new ESArrowItem((Item.Properties)p, CardboardArrow::new, CardboardArrow::new));
    public static final DeferredItem<Item> MISSED_YOU = ITEMS.registerItem("missed_you", p -> new ESArrowItem((Item.Properties)p, MissedArrow::new, MissedArrow::new));
    public static final DeferredItem<Item> SWEET_TOOTH = ITEMS.registerItem("sweet_tooth", p -> new ESArrowItem((Item.Properties)p, CandyArrow::new, CandyArrow::new), new Item.Properties().food(new FoodProperties.Builder().fast().nutrition(1).saturationModifier(0.5f).build()));
    public static final DeferredItem<Item> LIGHTNING_ARROW = ITEMS.registerItem("lightning_arrow", p -> new ESArrowItem((Item.Properties)p, LightningArrow::new, LightningArrow::new));
    public static final DeferredItem<Item> EXPLOSIVE_ARROW = ITEMS.registerItem("explosive_arrow", p -> new ESArrowItem((Item.Properties)p, ExplosiveArrow::new, ExplosiveArrow::new));
    public static final DeferredItem<Item> IRON_ARROW = ITEMS.registerItem("iron_arrow", p -> new ESArrowItem((Item.Properties)p, IronArrow::new, IronArrow::new));
    public static final DeferredItem<Item> QUARTZ_ARROW = ITEMS.registerItem("quartz_arrow", p -> new ESArrowItem((Item.Properties)p, QuartzArrow::new, QuartzArrow::new));
    public static final DeferredItem<Item> PRISMARINE_ARROW = ITEMS.registerItem("prismarine_arrow", p -> new ESArrowItem((Item.Properties)p, PrismarineArrow::new, PrismarineArrow::new));
    public static final DeferredItem<Item> GLASS_ARROW = ITEMS.registerItem("glass_arrow", p -> new ESArrowItem((Item.Properties)p, GlassArrow::new, GlassArrow::new));
    public static final DeferredItem<Item> AMETHYST_ARROW = ITEMS.registerItem("amethyst_arrow", p -> new ESArrowItem((Item.Properties)p, AmethystArrow::new, AmethystArrow::new));
    public static final DeferredItem<Item> PROJECDRILL = ITEMS.registerItem("projecdrill", p -> new ESArrowItem((Item.Properties)p, MiningArrow::new, MiningArrow::new));
    public static final DeferredItem<Item> CRUSADER_CROSSBOLT = ITEMS.registerItem("crusader_crossbolt", p -> new ESArrowItem((Item.Properties)p, HealingArrow::new, HealingArrow::new));
    public static final DeferredItem<Item> END_ARROW = ITEMS.registerItem("end_arrow", p -> new ESArrowItem((Item.Properties)p, EndArrow::new, EndArrow::new));
    public static final DeferredItem<Item> TELERROW = ITEMS.registerItem("telerrow", p -> new ESArrowItem((Item.Properties)p, TeleportArrow::new, TeleportArrow::new));
    public static final DeferredItem<Item> DRAGON_ARROW = ITEMS.registerItem("dragon_arrow", p -> new ESArrowItem((Item.Properties)p, DragonArrow::new, DragonArrow::new));
    public static final DeferredItem<Item> GEM_BREAKER = ITEMS.register("gem_breaker", () -> new InnateEnchantsWeapon(new WeaponItem.Builder(MSItemTypes.EMERALD_TIER, 7, -3.2f).efficiency(7.0f).set(new MSToolType[]{MSItemTypes.HAMMER_TOOL}), new MSItemProperties().durability(1250), Map.of(Enchantments.FORTUNE, 1)));
    public static final DeferredItem<Item> BELL_HAMMER = ITEMS.register("bell_hammer", () -> new WeaponItem(new WeaponItem.Builder((Tier)Tiers.GOLD, 8, -3.2f).efficiency(12.0f).add(new OnHitEffect[]{OnHitEffect.playSound(() -> SoundEvents.BELL_BLOCK)}), new MSItemProperties().durability(2500)));
    public static final DeferredItem<Item> BLIND_HAMMER = ITEMS.register("blind_hammer", () -> new WeaponItem(new WeaponItem.Builder(MSItemTypes.DENIZEN_TIER, 8, -3.2f).efficiency(15.0f).add(new OnHitEffect[]{OnHitEffect.playSound(() -> SoundEvents.BELL_BLOCK)}).add(new OnHitEffect[]{OnHitEffect.enemyPotionEffect(() -> new MobEffectInstance(MobEffects.BLINDNESS, 100))}).add(new InventoryTickEffect[]{ESInventoryTickEffects::blind}), new MSItemProperties().durability(2500)));
    public static final DeferredItem<Item> GOLD_COIN = ITEMS.register("gold_coin", () -> new WeaponItem(new WeaponItem.Builder((Tier)Tiers.GOLD, 1, -3.0f).efficiency(1.0f).set(new MSToolType[]{ESItemTypes.DICE_TOOL}).add(new OnHitEffect[]{ESHitEffects.randomDamage(2)}), new MSItemProperties().durability(128)));
    public static final DeferredItem<Item> STICKY_DIE = ITEMS.register("sticky_die", () -> new WeaponItem(new WeaponItem.Builder(MSItemTypes.PAPER_TIER, 0, -3.0f).efficiency(1.0f).set(new MSToolType[]{ESItemTypes.DICE_TOOL}).add(new OnHitEffect[]{OnHitEffect.enemyPotionEffect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 2))}).add(new OnHitEffect[]{ESHitEffects.randomDamage(3)}), new MSItemProperties().durability(333)));
    public static final DeferredItem<Item> ANTI_DIE = ITEMS.registerItem("anti_die", p -> new Item(p.stacksTo(1)));
    public static final DeferredItem<Item> TOKEN_TETRAHEDRON = ITEMS.register("token_tetrahedron", () -> new WeaponItem(new WeaponItem.Builder(MSItemTypes.EMERALD_TIER, 1, -3.0f).efficiency(2.0f).set(new MSToolType[]{ESItemTypes.DICE_TOOL}).add(new OnHitEffect[]{ESHitEffects.chanceDrop(() -> LUCK_TOKEN.toStack(1), 0.05f, () -> ESLangProvider.TOKEN_TETRAHEDRON_TOKEN_KEY)}).add(new OnHitEffect[]{ESHitEffects.randomDamage(4)}), new MSItemProperties().durability(444)));
    public static final DeferredItem<Item> D_ICE = ITEMS.register("d_ice", () -> new WeaponItem(new WeaponItem.Builder(MSItemTypes.ICE_TIER, 1, -3.0f).efficiency(1.0f).set(new MSToolType[]{ESItemTypes.DICE_TOOL}).add(new OnHitEffect[]{OnHitEffect.ICE_SHARD}).add(new OnHitEffect[]{ESHitEffects.randomDamage(6)}), new MSItemProperties().durability(260)));
    public static final DeferredItem<Item> SLICE_AND_DICE = ITEMS.register("slice_and_dice", () -> new WeaponItem(new WeaponItem.Builder((Tier)Tiers.GOLD, 2, -2.0f).efficiency(1.0f).set(new MSToolType[]{ESItemTypes.DICE_TOOL, MSItemTypes.KNIFE_TOOL}).add(new OnHitEffect[]{ESHitEffects.randomDamage(6)}), new MSItemProperties().durability(333)));
    public static final DeferredItem<Item> DONE = ITEMS.register("done", () -> new WeaponItem(new WeaponItem.Builder(MSItemTypes.SBAHJ_TIER, 1, -3.0f).efficiency(1.0f).set(new MSToolType[]{ESItemTypes.DICE_TOOL}).add(new OnHitEffect[]{OnHitEffect.SORD_DROP}), new Item.Properties()));
    public static final DeferredItem<Item> D10 = ITEMS.register("d10", () -> new WeaponItem(new WeaponItem.Builder((Tier)Tiers.DIAMOND, 1, -3.0f).set(new MSToolType[]{ESItemTypes.DICE_TOOL}).add(new OnHitEffect[]{ESHitEffects::timeStop}).add(new OnHitEffect[]{ESHitEffects.randomDamage(10)}), new MSItemProperties().durability(1010)));
    public static final DeferredItem<Item> RAINBOW_D7 = ITEMS.register("rainbow_d7", () -> new WeaponItem(new WeaponItem.Builder(MSItemTypes.PRISMARINE_TIER, 0, -3.0f).set(new MSToolType[]{ESItemTypes.DICE_TOOL}).add(new OnHitEffect[]{ESHitEffects.randomDamage(7)}).add(new OnHitEffect[]{ESHitEffects::rainbowEffect}), new MSItemProperties().durability(777)));
    public static final DeferredItem<Item> D8_NIGHT = ITEMS.register("d8_night", () -> new WeaponItem(new WeaponItem.Builder(MSItemTypes.REGI_TIER, 4, -1.0f).set(new MSToolType[]{ESItemTypes.DICE_TOOL, MSItemTypes.BATON_TOOL}).add(new OnHitEffect[]{ESHitEffects.randomDamage(8)}).add(new OnHitEffect[]{ESHitEffects.dayNightEffect((stack, target, attacker) -> target.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 160)), (stack, target, attacker) -> attacker.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 160)))}), new MSItemProperties().durability(888)));
    public static final DeferredItem<Item> CAN_DIE = ITEMS.register("can_die", () -> new WeaponItem(new WeaponItem.Builder(MSItemTypes.CANDY_TIER, 5, -3.0f).set(new MSToolType[]{ESItemTypes.DICE_TOOL}).add(new OnHitEffect[]{ESHitEffects.randomDamage(6)}).add(new OnHitEffect[]{OnHitEffect.SET_CANDY_DROP_FLAG}), new Item.Properties()));
    public static final DeferredItem<Item> INFINI_DIE = ITEMS.register("infini_die", () -> new WeaponItem(new WeaponItem.Builder(MSItemTypes.ZILLY_TIER, 0, -3.0f).set(new MSToolType[]{ESItemTypes.DICE_TOOL}).add(new OnHitEffect[]{ESHitEffects::randomMaxDamage}), new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).rarity(Rarity.EPIC)));
    public static final DeferredItem<Item> SILVER_BAT = ITEMS.register("silver_bat", () -> new InnateEnchantsWeapon(new WeaponItem.Builder((Tier)Tiers.IRON, 4, -2.8f).efficiency(2.0f).set(new MSToolType[]{MSItemTypes.CLUB_TOOL}), new MSItemProperties().durability(500), Map.of(Enchantments.SMITE, 1)));
    public static final DeferredItem<Item> GOLDEN_PAN = ITEMS.register("golden_pan", () -> new WeaponItem(new WeaponItem.Builder((Tier)Tiers.GOLD, 3, -2.8f).set(new MSToolType[]{MSItemTypes.CLUB_TOOL}).add(new OnHitEffect[]{OnHitEffect.playSound(ESSounds.GOLDEN_PAN_HIT)}).add(new OnHitEffect[]{OnHitEffect.enemyKnockback((float)1.0f)}), new MSItemProperties().durability(500).rarity(Rarity.RARE)));
    public static final DeferredItem<Item> ROLLING_PIN = ITEMS.register("rolling_pin", () -> new WeaponItem(new WeaponItem.Builder((Tier)Tiers.WOOD, 1, -2.8f).set(new MSToolType[]{MSItemTypes.CLUB_TOOL}).add(new OnHitEffect[]{OnHitEffect.enemyKnockback((float)0.1f)}), new Item.Properties()));
    public static final DeferredItem<Item> KEY_OF_TRIALS = ITEMS.register("key_of_trials", () -> new WeaponItem(new WeaponItem.Builder(ESItemTiers.COPPER_TIER, 0, -1.0f).efficiency(1.5f).set(new MSToolType[]{MSItemTypes.KEY_TOOL}), new Item.Properties()));
    public static final DeferredItem<Item> KEY_OF_OMINOUS_TRIALS = ITEMS.register("key_of_ominous_trials", () -> new InnateEnchantsWeapon(new WeaponItem.Builder((Tier)Tiers.DIAMOND, 0, -1.0f).efficiency(2.0f).set(new MSToolType[]{MSItemTypes.KEY_TOOL}).add(new OnHitEffect[]{ESHitEffects::stealLuck}), new MSItemProperties().durability(500), Map.of(Enchantments.LOOTING, 1)));
    public static final DeferredItem<Item> OFFICE_KEY = ITEMS.register("office_key", () -> new AltGunWeapon(new WeaponItem.Builder((Tier)Tiers.IRON, 0, -1.0f).efficiency(1.0f).set(new MSToolType[]{MSItemTypes.KEY_TOOL}).set(ItemRightClickEffect.switchTo(HANDGUN)), new Item.Properties().component(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)));
    public static final DeferredItem<Item> BAGUETTE_MAGIQUE = ITEMS.register("baguette_magique", () -> new WeaponItem(new WeaponItem.Builder(MSItemTypes.ORGANIC_TIER, 1, -1.0f).efficiency(1.0f).set(new MSToolType[]{MSItemTypes.WAND_TOOL}).set((ItemRightClickEffect)MagicRangedRightClickEffect.STANDARD_MAGIC).add(new OnHitEffect[]{OnHitEffect.SPAWN_BREADCRUMBS}), new Item.Properties()));
    public static final DeferredItem<Item> BROOM = ITEMS.register("broom", () -> new BrushWeapon(new WeaponItem.Builder(MSItemTypes.ORGANIC_TIER, 3, -2.0f).set(new MSToolType[]{MSItemTypes.CANE_TOOL}).set(ESRightClickBlockEffects::brush).add(new OnHitEffect[]{OnHitEffect.enemyKnockback((float)1.0f)}), new Item.Properties()));
    public static final DeferredItem<Item> MAGNEFORK = ITEMS.register("magnefork", () -> new WeaponItem(new WeaponItem.Builder((Tier)Tiers.IRON, 3, -2.6f).efficiency(1.0f).set(new MSToolType[]{MSItemTypes.FORK_TOOL}).add(new OnHitEffect[]{ESHitEffects.attractItemsGrist(5.0)}), new MSItemProperties().durability(450)));
    public static final DeferredItem<Item> OVERCHARGED_MAGNEFORK = ITEMS.register("overcharged_magnefork", () -> new WeaponItem(new WeaponItem.Builder((Tier)Tiers.GOLD, 8, -2.6f).efficiency(3.0f).set(new MSToolType[]{MSItemTypes.FORK_TOOL}).add(new OnHitEffect[]{ESHitEffects.requireCharge(300, ESHitEffects.attractItemsGrist(10.0))}).set(ItemRightClickEffect.switchTo(UNDERCHARGED_MAGNEFORK)).add(new OnHitEffect[]{OnHitEffect.playSound((Supplier)MSSoundEvents.EVENT_ELECTRIC_SHOCK, (float)0.6f, (float)1.0f)}), new MSItemProperties().durability(750).component(ESDataComponents.ENERGY_STORAGE, (Object)30000)));
    public static final DeferredItem<Item> UNDERCHARGED_MAGNEFORK = ITEMS.register("undercharged_magnefork", () -> new WeaponItem(new WeaponItem.Builder((Tier)Tiers.GOLD, 8, -2.6f).efficiency(3.0f).set(new MSToolType[]{MSItemTypes.FORK_TOOL}).set(ItemRightClickEffect.switchTo(OVERCHARGED_MAGNEFORK)), new MSItemProperties().durability(750).component(ESDataComponents.ENERGY_STORAGE, (Object)30000)));
    public static final DeferredItem<Item> HANDGUN = ITEMS.register("handgun", () -> new ESGun(new ESGun.Builder().ammo(ESItemTags.AMMO_HANDGUN).maxBullets(6).zoom(0.8f).switchTo(OFFICE_KEY), new MSItemProperties().durability(250)));
    public static final DeferredItem<Item> HANDGUN_BULLET = ITEMS.registerItem("handgun_bullet", p -> new ESBulletItem(p.stacksTo(99).component(ESDataComponents.AMMO_DAMAGE, (Object)Float.valueOf(2.0f)), ESBullet.createArrow(ESEntities.HANDGUN_BULLET.get()), ESBullet.asProjectile(ESEntities.HANDGUN_BULLET.get())));
    public static final DeferredItem<Item> HEAVY_HANDGUN_BULLET = ITEMS.registerItem("heavy_handgun_bullet", p -> new ESBulletItem(p.stacksTo(99).component(ESDataComponents.AMMO_DAMAGE, (Object)Float.valueOf(4.0f)), ESBullet.createArrow(ESEntities.HEAVY_HANDGUN_BULLET.get()), ESBullet.asProjectile(ESEntities.HEAVY_HANDGUN_BULLET.get())));
    public static final DeferredItem<Item> CHEF_HAT = ITEMS.register("chef_hat", () -> new ChefArmorItem(ESArmorMaterials.CHEF_ARMOR, ArmorItem.Type.HELMET, new Item.Properties().durability(ArmorItem.Type.HELMET.getDurability(10))));
    public static final DeferredItem<Item> CHEF_APRON = ITEMS.register("chef_apron", () -> new ChefArmorItem(ESArmorMaterials.CHEF_ARMOR, ArmorItem.Type.CHESTPLATE, new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(10))));
    public static final DeferredItem<Item> HEAVY_BOOTS = ITEMS.register("heavy_boots", () -> new MSArmorItem(ArmorMaterials.IRON, ArmorItem.Type.BOOTS, new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(17)).attributes(ItemAttributeModifiers.builder().add(Attributes.GRAVITY, new AttributeModifier(ExtraStuck.modid("heavy_boots_gravity"), 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.FEET).add(Attributes.ARMOR, new AttributeModifier(ExtraStuck.modid("heavy_boots_armor"), 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.FEET).build())));
    public static final DeferredItem<Item> PROPELLER_HAT = ITEMS.register("propeller_hat", () -> new PropellerHatItem(ESArmorMaterials.PROPELLER_HAT, ArmorItem.Type.HELMET, new Item.Properties().durability(ArmorItem.Type.HELMET.getDurability(17)).attributes(ItemAttributeModifiers.builder().add(Attributes.GRAVITY, new AttributeModifier(ExtraStuck.modid("propeller_hat_gravity"), -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.HEAD).add(Attributes.ARMOR, new AttributeModifier(ExtraStuck.modid("propeller_hat_armor"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HEAD).build())));
    public static final DeferredItem<Item> OLD_BRUSH = ITEMS.registerItem("old_brush", BrushItem::new, new Item.Properties().stacksTo(1).durability(320));
    public static final DeferredItem<Item> MAGNET = ITEMS.registerItem("magnet", p -> new MagnetItem((Tier)Tiers.IRON, (Item.Properties)p), new MSItemProperties().stacksTo(1).durability(160));
    public static final DeferredItem<BlockItem> PIZZA = ITEMS.registerSimpleBlockItem(ESBlocks.PIZZA);
    public static final DeferredItem<Item> PILE_MODUS_CARD = ITEMS.registerItem("pile_modus_card", Item::new, new Item.Properties().stacksTo(1));
    public static final DeferredItem<Item> FORTUNE_MODUS_CARD = ITEMS.registerItem("fortune_modus_card", Item::new, new Item.Properties().stacksTo(1));
    public static final DeferredItem<Item> ORE_MODUS_CARD = ITEMS.registerItem("ore_modus_card", Item::new, new Item.Properties().stacksTo(1));
    public static final DeferredItem<Item> ARCHEOLOGY_MODUS_CARD = ITEMS.registerItem("archeology_modus_card", Item::new, new Item.Properties().stacksTo(1));
    public static final DeferredItem<Item> VOID_MODUS_CARD = ITEMS.registerItem("void_modus_card", Item::new, new Item.Properties().stacksTo(1));
    public static final DeferredItem<BlockItem> CARD_ORE = ITEMS.registerSimpleBlockItem(ESBlocks.CARD_ORE);
    public static final DeferredItem<Item> FORTUNE_COOKIE = ITEMS.registerItem("fortune_cookie", FortuneCookie::new, new Item.Properties().food(new FoodProperties.Builder().alwaysEdible().build()));
    public static final DeferredItem<BlockItem> CUT_GARNET = ITEMS.registerSimpleBlockItem(ESBlocks.CUT_GARNET);
    public static final DeferredItem<BlockItem> CUT_GARNET_STAIRS = ITEMS.registerSimpleBlockItem(ESBlocks.CUT_GARNET_STAIRS);
    public static final DeferredItem<BlockItem> CUT_GARNET_SLAB = ITEMS.registerSimpleBlockItem(ESBlocks.CUT_GARNET_SLAB);
    public static final DeferredItem<BlockItem> CUT_GARNET_WALL = ITEMS.registerSimpleBlockItem(ESBlocks.CUT_GARNET_WALL);
    public static final DeferredItem<BlockItem> GARNET_BRICKS = ITEMS.registerSimpleBlockItem(ESBlocks.GARNET_BRICKS);
    public static final DeferredItem<BlockItem> GARNET_BRICK_STAIRS = ITEMS.registerSimpleBlockItem(ESBlocks.GARNET_BRICK_STAIRS);
    public static final DeferredItem<BlockItem> GARNET_BRICK_SLAB = ITEMS.registerSimpleBlockItem(ESBlocks.GARNET_BRICK_SLAB);
    public static final DeferredItem<BlockItem> GARNET_BRICK_WALL = ITEMS.registerSimpleBlockItem(ESBlocks.GARNET_BRICK_WALL);
    public static final DeferredItem<BlockItem> CHISELED_GARNET_BRICKS = ITEMS.registerSimpleBlockItem(ESBlocks.CHISELED_GARNET_BRICKS);
    public static final DeferredItem<BlockItem> CUT_RUBY = ITEMS.registerSimpleBlockItem(ESBlocks.CUT_RUBY);
    public static final DeferredItem<BlockItem> CUT_RUBY_STAIRS = ITEMS.registerSimpleBlockItem(ESBlocks.CUT_RUBY_STAIRS);
    public static final DeferredItem<BlockItem> CUT_RUBY_SLAB = ITEMS.registerSimpleBlockItem(ESBlocks.CUT_RUBY_SLAB);
    public static final DeferredItem<BlockItem> CUT_RUBY_WALL = ITEMS.registerSimpleBlockItem(ESBlocks.CUT_RUBY_WALL);
    public static final DeferredItem<BlockItem> RUBY_BRICKS = ITEMS.registerSimpleBlockItem(ESBlocks.RUBY_BRICKS);
    public static final DeferredItem<BlockItem> RUBY_BRICK_STAIRS = ITEMS.registerSimpleBlockItem(ESBlocks.RUBY_BRICK_STAIRS);
    public static final DeferredItem<BlockItem> RUBY_BRICK_SLAB = ITEMS.registerSimpleBlockItem(ESBlocks.RUBY_BRICK_SLAB);
    public static final DeferredItem<BlockItem> RUBY_BRICK_WALL = ITEMS.registerSimpleBlockItem(ESBlocks.RUBY_BRICK_WALL);
    public static final DeferredItem<BlockItem> CHISELED_RUBY_BRICKS = ITEMS.registerSimpleBlockItem(ESBlocks.CHISELED_RUBY_BRICKS);
    public static final DeferredItem<BlockItem> COBALT_BLOCK = ITEMS.registerSimpleBlockItem(ESBlocks.COBALT_BLOCK);
    public static final DeferredItem<BlockItem> COBALT_BARS = ITEMS.registerSimpleBlockItem(ESBlocks.COBALT_BARS);
    public static final DeferredItem<BlockItem> COBALT_DOOR = ITEMS.registerSimpleBlockItem(ESBlocks.COBALT_DOOR);
    public static final DeferredItem<BlockItem> COBALT_TRAPDOOR = ITEMS.registerSimpleBlockItem(ESBlocks.COBALT_TRAPDOOR);
    public static final DeferredItem<BlockItem> COBALT_PRESSURE_PLATE = ITEMS.registerSimpleBlockItem(ESBlocks.COBALT_PRESSURE_PLATE);
    public static final DeferredItem<BlockItem> SULFUROUS_STONE = ITEMS.registerSimpleBlockItem(ESBlocks.SULFUROUS_STONE);
    public static final DeferredItem<BlockItem> SULFUROUS_STONE_STAIRS = ITEMS.registerSimpleBlockItem(ESBlocks.SULFUROUS_STONE_STAIRS);
    public static final DeferredItem<BlockItem> SULFUROUS_STONE_SLAB = ITEMS.registerSimpleBlockItem(ESBlocks.SULFUROUS_STONE_SLAB);
    public static final DeferredItem<BlockItem> SULFUROUS_STONE_WALL = ITEMS.registerSimpleBlockItem(ESBlocks.SULFUROUS_STONE_WALL);
    public static final DeferredItem<BlockItem> MARBLE = ITEMS.registerSimpleBlockItem(ESBlocks.MARBLE);
    public static final DeferredItem<BlockItem> MARBLE_STAIRS = ITEMS.registerSimpleBlockItem(ESBlocks.MARBLE_STAIRS);
    public static final DeferredItem<BlockItem> MARBLE_SLAB = ITEMS.registerSimpleBlockItem(ESBlocks.MARBLE_SLAB);
    public static final DeferredItem<BlockItem> MARBLE_WALL = ITEMS.registerSimpleBlockItem(ESBlocks.MARBLE_WALL);
    public static final DeferredItem<BlockItem> POLISHED_MARBLE = ITEMS.registerSimpleBlockItem(ESBlocks.POLISHED_MARBLE);
    public static final DeferredItem<BlockItem> POLISHED_MARBLE_STAIRS = ITEMS.registerSimpleBlockItem(ESBlocks.POLISHED_MARBLE_STAIRS);
    public static final DeferredItem<BlockItem> POLISHED_MARBLE_SLAB = ITEMS.registerSimpleBlockItem(ESBlocks.POLISHED_MARBLE_SLAB);
    public static final DeferredItem<BlockItem> POLISHED_MARBLE_WALL = ITEMS.registerSimpleBlockItem(ESBlocks.POLISHED_MARBLE_WALL);
    public static final DeferredItem<BlockItem> MARBLE_BRICKS = ITEMS.registerSimpleBlockItem(ESBlocks.MARBLE_BRICKS);
    public static final DeferredItem<BlockItem> MARBLE_BRICK_STAIRS = ITEMS.registerSimpleBlockItem(ESBlocks.MARBLE_BRICK_STAIRS);
    public static final DeferredItem<BlockItem> MARBLE_BRICK_SLAB = ITEMS.registerSimpleBlockItem(ESBlocks.MARBLE_BRICK_SLAB);
    public static final DeferredItem<BlockItem> MARBLE_BRICK_WALL = ITEMS.registerSimpleBlockItem(ESBlocks.MARBLE_BRICK_WALL);
    public static final DeferredItem<BlockItem> ZILLIUM_BRICKS = ITEMS.registerSimpleBlockItem(ESBlocks.ZILLIUM_BRICKS);
    public static final DeferredItem<BlockItem> ZILLIUM_BRICK_STAIRS = ITEMS.registerSimpleBlockItem(ESBlocks.ZILLIUM_BRICK_STAIRS);
    public static final DeferredItem<BlockItem> ZILLIUM_BRICK_SLAB = ITEMS.registerSimpleBlockItem(ESBlocks.ZILLIUM_BRICK_SLAB);
    public static final DeferredItem<BlockItem> ZILLIUM_BRICK_WALL = ITEMS.registerSimpleBlockItem(ESBlocks.ZILLIUM_BRICK_WALL);
    public static final DeferredItem<Item> GIFT = ITEMS.registerItem("gift", p -> new GiftItem(p.component(ESDataComponents.GIFT_TABLE, ESLootSubProvider.GIFT_LOOT_TABLE)));
    public static final DeferredItem<Item> LUCK_TOKEN = ITEMS.registerItem("luck_token", p -> new Tokenitem((Item.Properties)p));

    public static void addToCreativeTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        if (ModList.get().isLoaded("patchouli")) {
            output.accept(ItemModBook.forBook((ResourceLocation)ExtraStuck.modid("extrastuck")));
        }
        for (DeferredItem<Item> deferredItem : ESItems.getModusCards()) {
            output.accept((ItemLike)deferredItem.get());
        }
        for (DeferredItem<Item> deferredItem : ESItems.getTools()) {
            output.accept((ItemLike)deferredItem.get());
        }
        for (DeferredItem<Item> deferredItem : ESItems.getShields()) {
            output.accept((ItemLike)deferredItem.get());
        }
        output.accept(CAPTAIN_JUSTICE_SHIELD_THROWABLE);
        output.accept(GIFT);
        for (DeferredItem<Item> deferredItem : ESItems.getMeleeWeapons()) {
            output.accept((ItemLike)deferredItem.get());
        }
        output.accept(ANTI_DIE);
        output.accept(LUCK_TOKEN);
        for (DeferredItem<Item> deferredItem : ESItems.getRangedWeapons()) {
            output.accept((ItemLike)deferredItem.get());
        }
        for (DeferredItem<Item> deferredItem : ESItems.getArrows()) {
            output.accept((ItemLike)deferredItem.get());
        }
        for (DeferredItem<Item> deferredItem : ESItems.getAmmo()) {
            output.accept((ItemLike)deferredItem.get());
        }
        for (DeferredItem<Item> deferredItem : ESItems.getArmor()) {
            output.accept((ItemLike)deferredItem.get());
        }
        for (DeferredItem<Item> deferredItem : ESItems.getFoods()) {
            output.accept((ItemLike)deferredItem.get());
        }
        for (DeferredItem<Item> deferredItem : ESItems.getBlocks()) {
            output.accept((ItemLike)deferredItem.get());
        }
    }

    public static Collection<DeferredItem<Item>> getModusCards() {
        ArrayList<DeferredItem<Item>> list = new ArrayList<DeferredItem<Item>>();
        list.add(PILE_MODUS_CARD);
        list.add(FORTUNE_MODUS_CARD);
        list.add(ORE_MODUS_CARD);
        list.add(ARCHEOLOGY_MODUS_CARD);
        list.add(VOID_MODUS_CARD);
        return list;
    }

    public static Collection<DeferredItem<Item>> getTools() {
        ArrayList<DeferredItem<Item>> list = new ArrayList<DeferredItem<Item>>();
        list.add(OLD_BRUSH);
        list.add(MAGNET);
        return list;
    }

    public static Collection<DeferredItem<Item>> getShields() {
        ArrayList<DeferredItem<Item>> list = new ArrayList<DeferredItem<Item>>();
        list.add(WOODEN_SHIELD);
        list.add(FLAME_SHIELD);
        list.add(HALT_SHIELD);
        list.add(LIGHT_SHIELD);
        list.add(NON_CONTACT_CONTRACT);
        list.add(GIFT_OF_PROTECTION);
        list.add(SLIED);
        list.add(RIOT_SHIELD);
        list.add(CAPTAIN_JUSTICE_THROWABLE_SHIELD);
        list.add(CAPITASHIELD);
        list.add(IRON_SHIELD);
        list.add(SPIKES_ON_A_SLAB);
        list.add(JAWBITER);
        list.add(ELDRITCH_SHIELD);
        list.add(GOLD_SHIELD);
        list.add(FLUX_SHIELD);
        list.add(DIAMOND_SHIELD);
        list.add(NETHERITE_SHIELD);
        list.add(GARNET_SHIELD);
        list.add(POGO_SHIELD);
        list.add(RETURN_TO_SENDER);
        return list;
    }

    public static Collection<DeferredItem<Item>> getArrows() {
        ArrayList<DeferredItem<Item>> list = new ArrayList<DeferredItem<Item>>();
        list.add(NETHER_ARROW);
        list.add(FLAME_ARROW);
        list.add(CARDBOARD_ARROW);
        list.add(MISSED_YOU);
        list.add(SWEET_TOOTH);
        list.add(LIGHTNING_ARROW);
        list.add(EXPLOSIVE_ARROW);
        list.add(IRON_ARROW);
        list.add(QUARTZ_ARROW);
        list.add(PRISMARINE_ARROW);
        list.add(GLASS_ARROW);
        list.add(AMETHYST_ARROW);
        list.add(PROJECDRILL);
        list.add(CRUSADER_CROSSBOLT);
        list.add(END_ARROW);
        list.add(TELERROW);
        list.add(DRAGON_ARROW);
        return list;
    }

    public static Collection<DeferredItem<Item>> getMeleeWeapons() {
        ArrayList<DeferredItem<Item>> list = new ArrayList<DeferredItem<Item>>();
        list.add(GEM_BREAKER);
        list.add(BELL_HAMMER);
        list.add(BLIND_HAMMER);
        list.add(GOLD_COIN);
        list.add(STICKY_DIE);
        list.add(TOKEN_TETRAHEDRON);
        list.add(D_ICE);
        list.add(SLICE_AND_DICE);
        list.add(DONE);
        list.add(D10);
        list.add(RAINBOW_D7);
        list.add(D8_NIGHT);
        list.add(CAN_DIE);
        list.add(INFINI_DIE);
        list.add(SILVER_BAT);
        list.add(GOLDEN_PAN);
        list.add(ROLLING_PIN);
        list.add(KEY_OF_TRIALS);
        list.add(KEY_OF_OMINOUS_TRIALS);
        list.add(OFFICE_KEY);
        list.add(BAGUETTE_MAGIQUE);
        list.add(BROOM);
        list.add(MAGNEFORK);
        list.add(OVERCHARGED_MAGNEFORK);
        list.add(UNDERCHARGED_MAGNEFORK);
        return list;
    }

    public static Collection<DeferredItem<Item>> getMiningTools() {
        ArrayList<DeferredItem<Item>> list = new ArrayList<DeferredItem<Item>>();
        list.add(GEM_BREAKER);
        return list;
    }

    public static Collection<DeferredItem<Item>> getRangedWeapons() {
        ArrayList<DeferredItem<Item>> list = new ArrayList<DeferredItem<Item>>();
        list.add(HANDGUN);
        return list;
    }

    public static Collection<DeferredItem<Item>> getAmmo() {
        ArrayList<DeferredItem<Item>> list = new ArrayList<DeferredItem<Item>>();
        list.add(HANDGUN_BULLET);
        list.add(HEAVY_HANDGUN_BULLET);
        return list;
    }

    public static Collection<DeferredItem<Item>> getArmor() {
        ArrayList<DeferredItem<Item>> list = new ArrayList<DeferredItem<Item>>();
        list.add(CHEF_HAT);
        list.add(CHEF_APRON);
        list.add(PROPELLER_HAT);
        list.add(HEAVY_BOOTS);
        return list;
    }

    public static Collection<DeferredItem<Item>> getHelmets() {
        ArrayList<DeferredItem<Item>> list = new ArrayList<DeferredItem<Item>>();
        list.add(CHEF_HAT);
        list.add(PROPELLER_HAT);
        return list;
    }

    public static Collection<DeferredItem<Item>> getChestplates() {
        ArrayList<DeferredItem<Item>> list = new ArrayList<DeferredItem<Item>>();
        list.add(CHEF_APRON);
        return list;
    }

    public static Collection<DeferredItem<Item>> getBoots() {
        ArrayList<DeferredItem<Item>> list = new ArrayList<DeferredItem<Item>>();
        list.add(HEAVY_BOOTS);
        return list;
    }

    public static Collection<DeferredItem<? extends Item>> getFoods() {
        ArrayList<DeferredItem<? extends Item>> list = new ArrayList<DeferredItem<? extends Item>>();
        list.add(PIZZA);
        list.add(FORTUNE_COOKIE);
        return list;
    }

    public static Collection<DeferredItem<BlockItem>> getBlocks() {
        ArrayList<DeferredItem<BlockItem>> list = new ArrayList<DeferredItem<BlockItem>>();
        list.add(CUT_GARNET);
        list.add(CUT_GARNET_STAIRS);
        list.add(CUT_GARNET_SLAB);
        list.add(CUT_GARNET_WALL);
        list.add(GARNET_BRICKS);
        list.add(GARNET_BRICK_STAIRS);
        list.add(GARNET_BRICK_SLAB);
        list.add(GARNET_BRICK_WALL);
        list.add(CHISELED_GARNET_BRICKS);
        list.add(CUT_RUBY);
        list.add(CUT_RUBY_STAIRS);
        list.add(CUT_RUBY_SLAB);
        list.add(CUT_RUBY_WALL);
        list.add(RUBY_BRICKS);
        list.add(RUBY_BRICK_STAIRS);
        list.add(RUBY_BRICK_SLAB);
        list.add(RUBY_BRICK_WALL);
        list.add(CHISELED_RUBY_BRICKS);
        list.add(COBALT_BLOCK);
        list.add(COBALT_BARS);
        list.add(COBALT_DOOR);
        list.add(COBALT_TRAPDOOR);
        list.add(COBALT_PRESSURE_PLATE);
        list.add(SULFUROUS_STONE);
        list.add(SULFUROUS_STONE_STAIRS);
        list.add(SULFUROUS_STONE_SLAB);
        list.add(SULFUROUS_STONE_WALL);
        list.add(MARBLE);
        list.add(MARBLE_STAIRS);
        list.add(MARBLE_SLAB);
        list.add(MARBLE_WALL);
        list.add(POLISHED_MARBLE);
        list.add(POLISHED_MARBLE_STAIRS);
        list.add(POLISHED_MARBLE_SLAB);
        list.add(POLISHED_MARBLE_WALL);
        list.add(MARBLE_BRICKS);
        list.add(MARBLE_BRICK_STAIRS);
        list.add(MARBLE_BRICK_SLAB);
        list.add(MARBLE_BRICK_WALL);
        list.add(ZILLIUM_BRICKS);
        list.add(ZILLIUM_BRICK_STAIRS);
        list.add(ZILLIUM_BRICK_SLAB);
        list.add(ZILLIUM_BRICK_WALL);
        list.add(CARD_ORE);
        return list;
    }
}

