/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.items;

import com.medsal15.items.ESDataComponents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;

public class GiftItem
extends Item {
    public GiftItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (stack.has(ESDataComponents.GIFT_TABLE)) {
                LootTable table;
                ResourceKey tableId = (ResourceKey)stack.get(ESDataComponents.GIFT_TABLE);
                MinecraftServer server = level.getServer();
                if (server != null && (table = server.reloadableRegistries().getLootTable(tableId)) != null) {
                    LootParams.Builder builder = new LootParams.Builder(serverLevel).withLuck(player.getLuck());
                    LootParams params = builder.create(LootContextParamSet.builder().build());
                    ObjectArrayList rewards = table.getRandomItems(params);
                    for (ItemStack reward : rewards) {
                        if (player.getInventory().add(reward)) continue;
                        player.drop(reward, false);
                    }
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    return InteractionResultHolder.consume((Object)stack);
                }
            }
        }
        return super.use(level, player, hand);
    }
}

