/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.items;

import com.mraof.minestuck.entity.item.GristEntity;
import com.mraof.minestuck.entity.item.VitalityGelEntity;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class MagnetItem
extends TieredItem {
    private static final double RANGE = 5.0;

    public MagnetItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand usedHand) {
        boolean success = false;
        AABB box = new AABB(player.blockPosition()).inflate(5.0);
        List entities = level.getEntities((Entity)player, box, e -> e instanceof ItemEntity || e instanceof GristEntity || e instanceof VitalityGelEntity);
        for (Entity entity : entities) {
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                ItemStack stack = itemEntity.getItem();
                if (!player.addItem(stack)) continue;
                success = true;
                itemEntity.discard();
                continue;
            }
            if (entity instanceof GristEntity) {
                GristEntity gristEntity = (GristEntity)entity;
                gristEntity.playerTouch(player);
                success = true;
                continue;
            }
            if (!(entity instanceof VitalityGelEntity)) continue;
            VitalityGelEntity gelEntity = (VitalityGelEntity)entity;
            gelEntity.playerTouch(player);
            success = true;
        }
        if (success) {
            EquipmentSlot slot = null;
            if (usedHand == InteractionHand.MAIN_HAND) {
                slot = EquipmentSlot.MAINHAND;
            } else if (usedHand == InteractionHand.OFF_HAND) {
                slot = EquipmentSlot.OFFHAND;
            }
            if (slot != null) {
                player.getItemInHand(usedHand).hurtAndBreak(1, (LivingEntity)player, slot);
            }
            return InteractionResultHolder.consume((Object)player.getItemInHand(usedHand));
        }
        return super.use(level, player, usedHand);
    }
}

