/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.items;

import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Tokenitem
extends Item {
    private static final int COOLDOWN = 600;

    public Tokenitem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level instanceof ServerLevel) {
            MobEffectInstance luck;
            int amplifier = 0;
            int duration = 1200;
            if (player.hasEffect(MobEffects.LUCK) && (luck = player.getEffect(MobEffects.LUCK)) != null) {
                amplifier = Math.min(luck.getAmplifier() + 1, 4);
                duration = Math.max(duration, luck.getDuration());
            }
            player.addEffect(new MobEffectInstance(MobEffects.LUCK, duration, amplifier));
            player.getCooldowns().addCooldown(stack.getItem(), 600);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            return InteractionResultHolder.consume((Object)stack);
        }
        return super.use(level, player, hand);
    }
}

