/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.items.guns;

import com.medsal15.data.ESItemTags;
import com.medsal15.entities.projectiles.bullets.ItemBullet;
import com.medsal15.items.ESDataComponents;
import com.medsal15.items.guns.GunContainer;
import com.medsal15.items.projectiles.ESBulletItem;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.registries.DeferredItem;

public class ESGun
extends ProjectileWeaponItem
implements GunContainer.Filter {
    private TagKey<Item> ammo = ESItemTags.AMMO;
    private DeferredItem<Item> next;
    private float zoom = 1.0f;
    private int maxBullets = 64;

    public ESGun(Builder builder, Item.Properties properties) {
        super(properties.stacksTo(1).component(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
        this.ammo = builder.ammo;
        this.zoom = builder.zoom;
        this.maxBullets = builder.maxBullets;
        if (builder.next != null) {
            this.next = builder.next;
        }
    }

    @Override
    public boolean accepts(ItemStack stack) {
        return stack.is(this.ammo) && stack.has(ESDataComponents.AMMO_DAMAGE);
    }

    public int getMaxBullets() {
        return this.maxBullets;
    }

    public float getZoom() {
        return this.zoom;
    }

    public int getDefaultProjectileRange() {
        return 5;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return s -> this.accepts((ItemStack)s);
    }

    protected void shootProjectile(@Nonnull LivingEntity shooter, @Nonnull Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        projectile.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot() + angle, 0.0f, velocity, inaccuracy);
    }

    public boolean overrideStackedOnOther(@Nonnull ItemStack stack, @Nonnull Slot slot, @Nonnull ClickAction action, @Nonnull Player player) {
        if (stack.getCount() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (contents == null) {
            return false;
        }
        ItemStack other = slot.getItem();
        IItemHandler handler = (IItemHandler)Capabilities.ItemHandler.ITEM.getCapability(stack, null);
        if (other.isEmpty()) {
            ItemStack itemStack = handler.extractItem(0, 99, false);
            if (!itemStack.isEmpty()) {
                ItemStack otherStack = slot.safeInsert(itemStack);
                handler.insertItem(0, otherStack, false);
            }
        } else if (handler.isItemValid(0, other)) {
            ItemStack res = handler.insertItem(0, other, false);
            slot.setByPlayer(res);
        }
        return true;
    }

    public boolean overrideOtherStackedOnMe(@Nonnull ItemStack stack, @Nonnull ItemStack other, @Nonnull Slot slot, @Nonnull ClickAction action, @Nonnull Player player, @Nonnull SlotAccess access) {
        if (stack.getCount() != 1) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
            if (contents == null) {
                return false;
            }
            IItemHandler handler = (IItemHandler)Capabilities.ItemHandler.ITEM.getCapability(stack, null);
            if (other.isEmpty()) {
                ItemStack itemStack = handler.extractItem(0, 99, false);
                if (!itemStack.isEmpty()) {
                    access.set(itemStack);
                }
            } else {
                ItemStack itemStack = handler.insertItem(0, other, false);
                access.set(itemStack);
            }
            return true;
        }
        return false;
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        ItemContainerContents contents = (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        if (contents.equals((Object)ItemContainerContents.EMPTY)) {
            tooltipComponents.add((Component)Component.translatable((String)"extrastuck.gun_empty").withStyle(ChatFormatting.GRAY));
        } else {
            ItemStack itemStack = contents.copyOne();
            tooltipComponents.add((Component)Component.translatable((String)"extrastuck.gun_content", (Object[])new Object[]{itemStack.getCount(), itemStack.getDisplayName()}).withStyle(ChatFormatting.GRAY));
        }
    }

    public int getUseDuration(@Nonnull ItemStack stack, @Nonnull LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(@Nonnull ItemStack stack) {
        return UseAnim.NONE;
    }

    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching() && this.next != null) {
            ItemStack swap = new ItemStack(this.next.getDelegate(), stack.getCount(), stack.getComponentsPatch());
            return InteractionResultHolder.success((Object)swap);
        }
        ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (contents == null || contents.equals((Object)ItemContainerContents.EMPTY)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity entity, int timeCharged) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
            if (contents == null) {
                return;
            }
            IItemHandler handler = (IItemHandler)Capabilities.ItemHandler.ITEM.getCapability(stack, null);
            ItemStack ammo = handler.extractItem(0, 1, false);
            if (ammo.isEmpty()) {
                return;
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.shoot(serverLevel, (LivingEntity)player, player.getUsedItemHand(), stack, List.of(ammo), 10.0f, 0.0f, false, null);
            }
        }
    }

    protected Projectile createProjectile(@Nonnull Level level, @Nonnull LivingEntity shooter, @Nonnull ItemStack weapon, @Nonnull ItemStack ammo, boolean isCrit) {
        ItemBullet bullet;
        Item item = ammo.getItem();
        if (item instanceof ESBulletItem) {
            ESBulletItem bulletItem = (ESBulletItem)item;
            bullet = bulletItem.createBullet(level, ammo, shooter, weapon);
        } else {
            bullet = new ItemBullet(level, ammo, shooter, weapon);
        }
        return bullet;
    }

    public static class Builder {
        private float zoom = 1.0f;
        private TagKey<Item> ammo = ESItemTags.AMMO;
        private int maxBullets = 64;
        @Nullable
        private DeferredItem<Item> next = null;

        public Builder zoom(float zoom) {
            this.zoom = zoom;
            return this;
        }

        public Builder ammo(TagKey<Item> ammo) {
            this.ammo = ammo;
            return this;
        }

        public Builder maxBullets(int max) {
            this.maxBullets = max;
            return this;
        }

        public Builder switchTo(DeferredItem<Item> other) {
            this.next = other;
            return this;
        }
    }
}

