/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.items.guns;

import com.medsal15.items.guns.ESGun;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.items.ItemStackHandler;

public class GunContainer
extends ItemStackHandler {
    private ItemStack stack;

    public GunContainer(@Nonnull ItemStack stack) {
        this.stack = stack;
        this.setStacks(stack);
    }

    public GunContainer(int size, @Nonnull ItemStack stack) {
        super(size);
        this.stack = stack;
        this.setStacks(stack);
    }

    private void setStacks(@Nonnull ItemStack stack) {
        ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (contents != null) {
            this.setStackInSlot(0, contents.copyOne());
        }
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        boolean valid = super.isItemValid(slot, stack);
        Item item = this.stack.getItem();
        if (item instanceof ESGun) {
            ESGun gun = (ESGun)item;
            return valid && gun.accepts(stack);
        }
        return valid;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        int limit = super.getStackLimit(slot, stack);
        Item item = this.stack.getItem();
        if (item instanceof ESGun) {
            ESGun gun = (ESGun)item;
            limit = Math.min(limit, gun.getMaxBullets());
        }
        return limit;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)this.stacks));
    }

    public static interface Filter {
        public boolean accepts(ItemStack var1);
    }
}

