/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.items.melee;

import com.medsal15.ExtraStuck;
import com.mraof.minestuck.item.weapon.WeaponItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;

public class AltGunWeapon
extends WeaponItem {
    public AltGunWeapon(WeaponItem.Builder builder, Item.Properties properties) {
        super(builder, properties);
        NeoForge.EVENT_BUS.addListener(this::adjustDamge);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (contents == null || contents.equals((Object)ItemContainerContents.EMPTY)) {
            tooltipComponents.add((Component)Component.translatable((String)"extrastuck.office_key.empty").withStyle(ChatFormatting.GRAY));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"extrastuck.office_key.heavy").withStyle(ChatFormatting.GRAY));
        }
    }

    private void adjustDamge(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (!(stack.getItem() instanceof AltGunWeapon)) {
            return;
        }
        ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (contents != null && !contents.equals((Object)ItemContainerContents.EMPTY)) {
            event.addModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(ExtraStuck.modid("alt_gun"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
    }
}

