/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.items.melee;

import com.mraof.minestuck.item.weapon.WeaponItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class InnateEnchantsWeapon
extends WeaponItem {
    private Map<ResourceKey<Enchantment>, Integer> innate;

    public InnateEnchantsWeapon(WeaponItem.Builder builder, Item.Properties properties, Map<ResourceKey<Enchantment>, Integer> enchants) {
        super(builder, properties);
        this.innate = enchants;
    }

    public int getEnchantmentLevel(@Nonnull ItemStack stack, @Nonnull Holder<Enchantment> enchantment) {
        int level = super.getEnchantmentLevel(stack, enchantment);
        if (this.innate.getOrDefault(enchantment, 0) > 0) {
            level += this.innate.get(enchantment.getKey()).intValue();
        }
        return level;
    }

    public ItemEnchantments getAllEnchantments(@Nonnull ItemStack stack, @Nonnull HolderLookup.RegistryLookup<Enchantment> lookup) {
        ItemEnchantments list = super.getAllEnchantments(stack, lookup);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(list);
        for (ResourceKey<Enchantment> key : this.innate.keySet()) {
            int extra = this.innate.get(key);
            Optional enchant = lookup.get(key);
            if (!enchant.isPresent()) continue;
            mutable.upgrade((Holder)enchant.get(), extra);
        }
        return mutable.toImmutable();
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        for (ResourceKey<Enchantment> key : this.innate.keySet()) {
            int extra = this.innate.get(key);
            MutableComponent ench = Component.translatable((String)InnateEnchantsWeapon.getEnchantmentKey(key));
            if (extra == 1) {
                tooltipComponents.add((Component)Component.translatable((String)"extrastuck.innate_enchant", (Object[])new Object[]{1, ench}).withStyle(ChatFormatting.GRAY));
                continue;
            }
            if (extra <= 1) continue;
            tooltipComponents.add((Component)Component.translatable((String)"extrastuck.innate_enchants", (Object[])new Object[]{extra, ench}).withStyle(ChatFormatting.GRAY));
        }
    }

    private static String getEnchantmentKey(ResourceKey<Enchantment> enchantment) {
        ResourceLocation location = enchantment.location();
        return "enchantment." + location.getNamespace() + "." + location.getPath();
    }
}

