/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.items.shields;

import com.medsal15.ESDamageTypes;
import com.medsal15.items.ESDataComponents;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.player.PlayerBoondollars;
import com.mraof.minestuck.player.PlayerData;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.registries.DeferredItem;

public class ESShield
extends ShieldItem {
    @Nullable
    private Collection<IBlock> onBlock;
    @Nullable
    private DeferredItem<Item> swapWith;

    public ESShield(Item.Properties properties) {
        super(properties);
    }

    public ESShield(Item.Properties properties, DeferredItem<Item> swapItem) {
        super(properties);
        this.swapWith = swapItem;
    }

    public ESShield(Item.Properties properties, IBlock ... blocks) {
        super(properties);
        this.onBlock = List.of(blocks);
    }

    public ESShield(Item.Properties properties, DeferredItem<Item> swapItem, IBlock ... blocks) {
        super(properties);
        this.swapWith = swapItem;
        this.onBlock = List.of(blocks);
    }

    public boolean hasOnBlock(IBlock block) {
        return this.onBlock != null && this.onBlock.contains(block);
    }

    public boolean isValidRepairItem(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return false;
    }

    public void onShieldBlock(LivingShieldBlockEvent event) {
        Collection<IBlock> ob = this.onBlock;
        if (ob == null || ob.size() == 0) {
            return;
        }
        for (IBlock func : ob) {
            if (!func.onBlock(event)) continue;
            return;
        }
    }

    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        DeferredItem<Item> next = this.swapWith;
        if (next != null && player.isShiftKeyDown()) {
            ItemStack swap = new ItemStack(next.getDelegate(), stack.getCount(), stack.getComponentsPatch());
            return InteractionResultHolder.success((Object)swap);
        }
        return super.use(level, player, hand);
    }

    public static interface IBlock {
        public boolean onBlock(LivingShieldBlockEvent var1);
    }

    public static final class BlockFuncs {
        public static IBlock DAMAGE = event -> {
            ItemStack useItem = event.getEntity().getUseItem();
            if (!useItem.has(ESDataComponents.SHIELD_DAMAGE)) {
                return false;
            }
            float damage = ((Float)useItem.get(ESDataComponents.SHIELD_DAMAGE)).floatValue();
            if (damage <= 0.0f) {
                return false;
            }
            DamageSource damageSource = event.getDamageSource();
            if (damageSource.is(DamageTypeTags.BYPASSES_SHIELD) || !damageSource.isDirect()) {
                return false;
            }
            Entity attacker = damageSource.getDirectEntity();
            if (attacker == null || !(attacker instanceof LivingEntity)) {
                return false;
            }
            LivingEntity livingEntity = (LivingEntity)attacker;
            Level level = event.getEntity().level();
            Holder.Reference type = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(ESDamageTypes.THORN_SHIELD);
            DamageSource retSource = new DamageSource((Holder)type, (Entity)event.getEntity());
            livingEntity.hurt(retSource, damage);
            return false;
        };
        public static IBlock USE_POWER = event -> {
            int drain;
            DamageSource damageSource;
            ItemStack item = event.getEntity().getUseItem();
            if (!item.has(ESDataComponents.ENERGY) || !item.has(ESDataComponents.FLUX_MULTIPLIER)) {
                return false;
            }
            int mult = (Integer)item.getOrDefault(ESDataComponents.FLUX_MULTIPLIER, (Object)100);
            if (mult < 0) {
                mult = 1;
            }
            if ((damageSource = event.getDamageSource()).is(DamageTypeTags.BYPASSES_SHIELD)) {
                return false;
            }
            IEnergyStorage energyStorage = (IEnergyStorage)Capabilities.EnergyStorage.ITEM.getCapability(item, null);
            int extracted = energyStorage.extractEnergy(drain = (int)(event.getBlockedDamage() * (float)mult), false);
            if (extracted > 0) {
                event.setShieldDamage(0.0f);
            }
            return false;
        };

        public static boolean consumeBoondollars(LivingShieldBlockEvent event) {
            LivingEntity user = event.getEntity();
            if (!(user instanceof ServerPlayer)) {
                return false;
            }
            ServerPlayer player = (ServerPlayer)user;
            DamageSource damageSource = event.getDamageSource();
            if (damageSource.is(DamageTypeTags.BYPASSES_SHIELD)) {
                return false;
            }
            Optional oPlayerData = PlayerData.get((ServerPlayer)player);
            if (!oPlayerData.isPresent()) {
                return false;
            }
            PlayerData playerData = (PlayerData)oPlayerData.get();
            if (!PlayerBoondollars.tryTakeBoondollars((PlayerData)playerData, (long)((long)event.getBlockedDamage()))) {
                return false;
            }
            event.setShieldDamage(0.0f);
            return false;
        }

        public static IBlock bounceProjectiles(ProjectileDeflection deflection) {
            return e -> {
                DamageSource damageSource = e.getDamageSource();
                if (damageSource.is(DamageTypeTags.BYPASSES_SHIELD)) {
                    return false;
                }
                Entity attacker = damageSource.getDirectEntity();
                if (attacker == null || !(attacker instanceof Projectile)) {
                    return false;
                }
                Projectile projectile = (Projectile)attacker;
                projectile.deflect(deflection, (Entity)e.getEntity(), damageSource.getEntity(), e.getEntity() instanceof Player);
                return true;
            };
        }

        public static boolean dropCandy(LivingShieldBlockEvent event) {
            DamageSource damageSource = event.getDamageSource();
            if (damageSource.is(DamageTypeTags.BYPASSES_SHIELD) || !damageSource.isDirect()) {
                return false;
            }
            Entity attacker = damageSource.getEntity();
            if (attacker == null) {
                return false;
            }
            if (attacker instanceof UnderlingEntity) {
                UnderlingEntity underling = (UnderlingEntity)attacker;
                underling.dropCandy = true;
            }
            return false;
        }

        public static IBlock replace(DeferredItem<Item> next, TagKey<DamageType> changer) {
            return event -> {
                DamageSource damageSource = event.getDamageSource();
                if (!damageSource.is(changer)) {
                    return false;
                }
                LivingEntity entity = event.getEntity();
                entity.setItemInHand(entity.getUsedItemHand(), next.toStack());
                return true;
            };
        }

        public static boolean burn(LivingShieldBlockEvent event) {
            ItemStack useItem = event.getEntity().getUseItem();
            if (!useItem.has(ESDataComponents.BURN_DURATION.get())) {
                return false;
            }
            int duration = (Integer)useItem.get(ESDataComponents.BURN_DURATION);
            if (duration <= 0) {
                return false;
            }
            DamageSource damageSource = event.getDamageSource();
            if (damageSource.is(DamageTypeTags.BYPASSES_SHIELD) || !damageSource.isDirect()) {
                return false;
            }
            Entity attacker = damageSource.getDirectEntity();
            if (attacker == null || !(attacker instanceof LivingEntity)) {
                return false;
            }
            LivingEntity target = (LivingEntity)attacker;
            if (target.getRemainingFireTicks() < duration) {
                target.setRemainingFireTicks(duration);
            }
            return false;
        }

        public static boolean strongerKnockback(LivingShieldBlockEvent event) {
            DamageSource damageSource = event.getDamageSource();
            if (damageSource.is(DamageTypeTags.BYPASSES_SHIELD) || !damageSource.isDirect()) {
                return false;
            }
            Entity attacker = damageSource.getDirectEntity();
            if (attacker == null || !(attacker instanceof LivingEntity)) {
                return false;
            }
            LivingEntity target = (LivingEntity)attacker;
            float rot = event.getEntity().getYRot();
            target.knockback(1.0, Math.sin((double)(rot / 180.0f) * Math.PI), -Math.cos((double)(rot / 180.0f) * Math.PI));
            return false;
        }

        public static IBlock turn(float rot) {
            return event -> {
                DamageSource damageSource = event.getDamageSource();
                if (damageSource.is(DamageTypeTags.BYPASSES_SHIELD) || !damageSource.isDirect()) {
                    return false;
                }
                Entity attacker = damageSource.getDirectEntity();
                if (attacker == null) {
                    return false;
                }
                attacker.setYRot((attacker.getYRot() + rot) % 360.0f);
                return false;
            };
        }

        public static IBlock gainEffect(Holder<MobEffect> effect, int duration) {
            return event -> {
                DamageSource damageSource = event.getDamageSource();
                if (damageSource.is(DamageTypeTags.BYPASSES_SHIELD)) {
                    return false;
                }
                LivingEntity entity = event.getEntity();
                if (!entity.hasEffect(effect)) {
                    entity.addEffect(new MobEffectInstance(effect, duration));
                }
                return false;
            };
        }

        public static IBlock selfDropChance(float chance, Supplier<String> message) {
            return event -> {
                LivingEntity user = event.getEntity();
                if (user.getCommandSenderWorld().isClientSide || user.getRandom().nextFloat() >= chance) {
                    return false;
                }
                ItemStack stack = user.getUseItem();
                ItemEntity shield = new ItemEntity(user.level(), user.getX(), user.getY(), user.getZ(), stack.copy());
                shield.getItem().setCount(1);
                shield.setPickUpDelay(40);
                user.level().addFreshEntity((Entity)shield);
                stack.shrink(1);
                user.sendSystemMessage((Component)Component.translatable((String)((String)message.get())));
                return true;
            };
        }

        public static IBlock itemDropChance(Supplier<ItemStack> stack, float chance, Supplier<String> message) {
            return event -> {
                LivingEntity user = event.getEntity();
                if (user.getCommandSenderWorld().isClientSide || user.getRandom().nextFloat() >= chance) {
                    return false;
                }
                ItemStack itemStack = ((ItemStack)stack.get()).copy();
                ItemEntity item = new ItemEntity(user.level(), user.getX(), user.getY(), user.getZ(), itemStack);
                user.level().addFreshEntity((Entity)item);
                user.sendSystemMessage((Component)Component.translatable((String)((String)message.get()), (Object[])new Object[]{itemStack}));
                return true;
            };
        }
    }
}

