/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.modus;

import com.medsal15.modus.BaseModus;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.LogicalSide;

public class PileModus
extends BaseModus {
    public PileModus(ModusType<? extends PileModus> type, LogicalSide side) {
        super(type, side);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        if (this.side == LogicalSide.SERVER) {
            NonNullList items = NonNullList.copyOf((Collection)this.list);
            return items;
        }
        if (this.changed) {
            this.items = NonNullList.copyOf((Collection)this.list);
        }
        return this.items;
    }

    @Override
    public ItemStack getItem(ServerPlayer player, int id, boolean asCard) {
        if (id == -2) {
            if (this.list.size() < this.size) {
                --this.size;
                this.markDirty();
                return MSItems.CAPTCHA_CARD.toStack();
            }
            return ItemStack.EMPTY;
        }
        if (this.list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (id == -1) {
            for (ItemStack item : this.list) {
                CaptchaDeckHandler.launchAnyItem((Player)player, (ItemStack)item);
            }
            this.list.clear();
            this.markDirty();
            return ItemStack.EMPTY;
        }
        if (id < 0 || id >= this.list.size()) {
            return ItemStack.EMPTY;
        }
        ArrayList<ItemStack> pile = this.removePile(id);
        ItemStack item = pile.getLast();
        for (int i = 0; i < pile.size() - 1; ++i) {
            CaptchaDeckHandler.launchAnyItem((Player)player, (ItemStack)pile.get(i));
        }
        this.markDirty();
        if (asCard) {
            --this.size;
            this.markDirty();
            item = CaptchaCardItem.createCardWithItem((ItemStack)item, (MinecraftServer)player.server);
        }
        return item;
    }

    public int getWidth() {
        return (int)Math.ceil(Math.sqrt(this.list.size()));
    }

    private ArrayList<ItemStack> removePile(int id) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int cols = this.getWidth();
        for (int i = id; i < this.list.size(); i += cols) {
            ids.add(i);
        }
        Iterator iterator = ids.reversed().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            items.add((ItemStack)this.list.remove(i));
        }
        return items;
    }
}

