/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.modus;

import com.medsal15.modus.BaseModus;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.LogicalSide;

public class VoidModus
extends BaseModus {
    public VoidModus(ModusType<? extends VoidModus> type, LogicalSide side) {
        super(type, side);
    }

    @Override
    public boolean putItemStack(ServerPlayer player, ItemStack item) {
        if (this.size <= this.list.size() || item.isEmpty()) {
            return false;
        }
        boolean added = false;
        for (ItemStack stack : this.list) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)item)) continue;
            int count = Math.min(stack.getMaxStackSize(), stack.getCount() + item.getCount());
            stack.setCount(count);
            added = true;
        }
        if (!added) {
            this.list.add((Object)item);
        }
        this.markDirty();
        return true;
    }

    @Override
    public ItemStack getItem(ServerPlayer player, int id, boolean asCard) {
        if (asCard || id == -1 || id == -2) {
            return super.getItem(player, id, asCard);
        }
        if (this.list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (id < 0 || id >= this.list.size()) {
            return ItemStack.EMPTY;
        }
        ItemStack item = (ItemStack)this.list.get(id);
        player.getInventory().clearOrCountMatchingItems(stack -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)item), 9999, (Container)player.getInventory());
        return ItemStack.EMPTY;
    }
}

