/*
 * Decompiled with CFR 0.152.
 */
package com.medsal15.structures.processors;

import com.medsal15.structures.processors.ESProcessors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.consort.ConsortEntity;
import com.mraof.minestuck.entity.consort.EnumConsort;
import com.mraof.minestuck.world.lands.LandTypePair;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public final class PlaceConsortProcessor
extends StructureProcessor {
    public static final MapCodec<PlaceConsortProcessor> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)EnumConsort.MerchantType.CODEC.optionalFieldOf("merchant").forGetter(e -> e.merchant)).apply((Applicative)inst, PlaceConsortProcessor::new));
    private Optional<EnumConsort.MerchantType> merchant;

    public PlaceConsortProcessor(Optional<EnumConsort.MerchantType> merchant) {
        this.merchant = merchant;
    }

    public StructureTemplate.StructureEntityInfo processEntity(@Nonnull LevelReader world, @Nonnull BlockPos seedPos, @Nonnull StructureTemplate.StructureEntityInfo rawEntityInfo, @Nonnull StructureTemplate.StructureEntityInfo entityInfo, @Nonnull StructurePlaceSettings placementSettings, @Nonnull StructureTemplate template) {
        String id = rawEntityInfo.nbt.getString("id");
        if (world instanceof ServerLevelAccessor && "minecraft:armor_stand".equals(id)) {
            EntityType type;
            ServerLevelAccessor accessor = (ServerLevelAccessor)world;
            Optional oPair = LandTypePair.getTypes((ServerLevel)accessor.getLevel());
            if (oPair.isPresent()) {
                LandTypePair pair = (LandTypePair)oPair.get();
                type = pair.getTerrain().getConsortType();
            } else {
                type = (EntityType)MSEntityTypes.SALAMANDER.get();
            }
            ConsortEntity consort = (ConsortEntity)type.create((Level)accessor.getLevel());
            if (consort != null) {
                CompoundTag nbt;
                consort.setPos(entityInfo.pos);
                consort.finalizeSpawn(accessor, accessor.getCurrentDifficultyAt(seedPos), MobSpawnType.STRUCTURE, null);
                if (this.merchant.isPresent()) {
                    consort.merchantType = this.merchant.get();
                    if (consort.merchantType != EnumConsort.MerchantType.NONE) {
                        consort.restrictTo(entityInfo.blockPos, 0);
                    }
                } else {
                    consort.merchantType = EnumConsort.MerchantType.NONE;
                }
                if (consort.save(nbt = entityInfo.nbt)) {
                    return new StructureTemplate.StructureEntityInfo(entityInfo.pos, entityInfo.blockPos, nbt);
                }
            }
        }
        return super.processEntity(world, seedPos, rawEntityInfo, entityInfo, placementSettings, template);
    }

    protected StructureProcessorType<?> getType() {
        return ESProcessors.PLACE_CONSORT.get();
    }
}

