/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client;

import com.mojang.datafixers.util.Pair;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.core.systems.spirit.UmbralSpiritType;
import net.minecraft.client.renderer.RenderType;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.StateShards;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class SpiritBasedWorldVFXBuilder
extends VFXBuilders.WorldVFXBuilder {
    public final MalumSpiritType spiritType;

    public static SpiritBasedWorldVFXBuilder create(MalumSpiritType spiritType) {
        return new SpiritBasedWorldVFXBuilder(spiritType);
    }

    public SpiritBasedWorldVFXBuilder(MalumSpiritType spiritType) {
        this.spiritType = spiritType;
    }

    public VFXBuilders.WorldVFXBuilder setRenderType(RenderType renderType) {
        if (this.spiritType instanceof UmbralSpiritType && renderType instanceof LodestoneRenderType) {
            LodestoneRenderType umbralRenderType;
            LodestoneRenderType lodestoneRenderType = (LodestoneRenderType)renderType;
            if (!LodestoneRenderTypes.COPIES.containsKey(Pair.of((Object)this.spiritType, (Object)lodestoneRenderType))) {
                LodestoneRenderTypes.addRenderTypeModifier(b -> b.setTransparencyState(StateShards.NORMAL_TRANSPARENCY));
            }
            if (!RenderHandler.UNIFORM_HANDLERS.containsKey(umbralRenderType = LodestoneRenderTypes.copyAndStore((Object)this.spiritType, (LodestoneRenderType)lodestoneRenderType))) {
                LodestoneRenderTypes.applyUniformChanges((LodestoneRenderType)umbralRenderType, (ShaderUniformHandler)ShaderUniformHandler.LUMITRANSPARENT);
            }
            return super.setRenderType((RenderType)umbralRenderType);
        }
        return super.setRenderType(renderType);
    }

    public VFXBuilders.WorldVFXBuilder setAlpha(float a) {
        return super.setAlpha(a * this.spiritType.getAlphaMultiplier());
    }
}

