/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.sammy.malum.MalumMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import team.lodestar.lodestone.systems.model.LodestoneArmorModel;

public class SoulHunterArmorModel
extends LodestoneArmorModel {
    public static ModelLayerLocation LAYER = new ModelLayerLocation(MalumMod.malumPath("soul_hunter_armor"), "main");
    public ModelPart cape;
    public ModelPart hood;

    public SoulHunterArmorModel(ModelPart root) {
        super(root);
        this.cape = root.getChild("cape");
        this.hood = root.getChild("hood");
    }

    protected Iterable<ModelPart> bodyParts() {
        if (this.slot == EquipmentSlot.CHEST) {
            return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.cape, (Object)this.hood);
        }
        if (this.slot == EquipmentSlot.LEGS) {
            return ImmutableList.of((Object)this.leftLegging, (Object)this.rightLegging, (Object)this.leggings);
        }
        return this.slot == EquipmentSlot.FEET ? ImmutableList.of((Object)this.leftFoot, (Object)this.rightFoot) : ImmutableList.of();
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int p_350361_) {
        super.renderToBuffer(matrixStack, vertexConsumer, packedLight, packedOverlay, p_350361_);
    }

    public void copyFromDefault(HumanoidModel model) {
        super.copyFromDefault(model);
        this.cape.copyFrom(model.body);
        this.hood.copyFrom(model.body);
        model.hat.visible = false;
    }

    public void setupAnim(LivingEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float pPartialTicks = Minecraft.getInstance().timer.getGameTimeDeltaTicks();
        this.hood.visible = pEntity.getItemBySlot(EquipmentSlot.HEAD).isEmpty();
        if (pEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)pEntity;
            double d0 = Mth.lerp((double)pPartialTicks, (double)clientPlayer.xCloakO, (double)clientPlayer.xCloak) - Mth.lerp((double)pPartialTicks, (double)pEntity.xo, (double)pEntity.getX());
            double d1 = Mth.lerp((double)pPartialTicks, (double)clientPlayer.yCloakO, (double)clientPlayer.yCloak) - Mth.lerp((double)pPartialTicks, (double)pEntity.yo, (double)pEntity.getY());
            double d2 = Mth.lerp((double)pPartialTicks, (double)clientPlayer.zCloakO, (double)clientPlayer.zCloak) - Mth.lerp((double)pPartialTicks, (double)pEntity.zo, (double)pEntity.getZ());
            float f = pEntity.yBodyRotO + (pEntity.yBodyRot - pEntity.yBodyRotO);
            double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
            double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = Mth.clamp((float)f1, (float)-6.0f, (float)16.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 65.0f;
            f2 = Mth.clamp((float)f2, (float)0.0f, (float)75.0f);
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = Mth.lerp((float)pPartialTicks, (float)clientPlayer.oBob, (float)clientPlayer.bob);
            f1 += Mth.sin((float)(Mth.lerp((float)pPartialTicks, (float)pEntity.walkDistO, (float)pEntity.walkDist) * 6.0f)) * 32.0f * f4;
            if (pEntity.isCrouching()) {
                f1 += 25.0f;
            }
            float x = (float)Math.toRadians(6.0f + f2 / 2.0f + f1);
            float y = (float)Math.toRadians(f3 / 2.0f);
            float z = (float)Math.toRadians(f3 / 2.0f);
            this.cape.xRot = x;
            this.cape.yRot = y;
            this.cape.zRot = z;
            this.hood.xRot = x / 3.0f;
            this.hood.yRot = y / 3.0f;
            this.hood.zRot = z / 3.0f;
        } else {
            this.cape.xRot = 0.0f;
            this.cape.yRot = 0.0f;
            this.cape.zRot = 0.0f;
            this.hood.xRot = 0.0f;
            this.hood.yRot = 0.0f;
            this.hood.zRot = 0.0f;
        }
        super.setupAnim(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
    }

    public static LayerDefinition createBodyLayer() {
        return SoulHunterArmorModel.createArmorModel((mesh, root, body, leggings, right_legging, left_legging, right_foot, left_foot, right_arm, left_arm, head) -> {
            PartDefinition cape = root.addOrReplaceChild("cape", new CubeListBuilder(), PartPose.ZERO);
            PartDefinition helmet = head.addOrReplaceChild("helmet", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(36, 0).addBox(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition left_hood_part = helmet.addOrReplaceChild("left_hood_part", CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, -4.0f, -3.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(42, 18).addBox(0.0f, -4.0f, -3.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)4.5f, (float)-0.5f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f));
            PartDefinition right_hood_part = helmet.addOrReplaceChild("right_hood_part", CubeListBuilder.create().texOffs(42, 18).mirror().addBox(-2.0f, -4.0f, -3.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.25f)).mirror(false).texOffs(0, 18).mirror().addBox(-2.0f, -4.0f, -3.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.5f, (float)-0.5f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.3927f));
            PartDefinition back_hood_part = helmet.addOrReplaceChild("back_hood_part", CubeListBuilder.create().texOffs(18, 20).addBox(-3.5f, 0.0f, 0.0f, 7.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.5f, (float)4.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition hood = root.addOrReplaceChild("hood", CubeListBuilder.create(), PartPose.ZERO);
            PartDefinition lowered_hood = hood.addOrReplaceChild("lowered_hood", CubeListBuilder.create().texOffs(28, 30).addBox(-3.98f, -0.5028f, -2.1359f, 8.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(54, 30).addBox(-3.98f, -0.5028f, -2.1359f, 8.0f, 2.0f, 5.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)3.5f, (float)-0.6109f, (float)0.0f, (float)0.0f));
            PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 30).addBox(-4.5f, -0.5f, -2.5f, 9.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 45).addBox(-4.5f, -0.5f, -2.5f, 9.0f, 10.0f, 5.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition left_robe = torso.addOrReplaceChild("left_robe", CubeListBuilder.create().texOffs(28, 37).mirror().addBox(-1.0926f, -0.5f, -0.6014f, 3.0f, 10.0f, 1.0f, new CubeDeformation(0.01f)).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)0.0f, (float)-2.5f, (float)-0.0873f, (float)-0.3491f, (float)0.0087f));
            PartDefinition right_robe = torso.addOrReplaceChild("right_robe", CubeListBuilder.create().texOffs(28, 37).addBox(-1.9074f, -0.5f, -0.6014f, 3.0f, 10.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-2.5f, (float)0.0f, (float)-2.5f, (float)-0.0873f, (float)0.3491f, (float)0.0087f));
            PartDefinition cape_top = cape.addOrReplaceChild("cape_top", CubeListBuilder.create().texOffs(36, 37).addBox(-5.5213f, 0.3976f, -0.5395f, 11.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(60, 37).addBox(-5.5213f, 0.3976f, -0.5395f, 11.0f, 8.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
            PartDefinition cape_middle = cape_top.addOrReplaceChild("cape_middle", CubeListBuilder.create().texOffs(60, 45).addBox(-5.5213f, -0.2225f, -0.5569f, 11.0f, 7.0f, 1.0f, new CubeDeformation(0.25f)).texOffs(36, 45).addBox(-5.5213f, -0.2225f, -0.5569f, 11.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.5455f, (float)0.0417f, (float)0.1309f, (float)0.0f, (float)0.0f));
            PartDefinition cape_bottom = cape_middle.addOrReplaceChild("cape_bottom", CubeListBuilder.create().texOffs(28, 48).addBox(-5.5213f, -1.3642f, -0.3206f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(36, 53).addBox(-2.5213f, -1.3642f, -0.3206f, 5.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(28, 48).mirror().addBox(2.4787f, -1.3642f, -0.3206f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(28, 53).mirror().addBox(2.4787f, -1.3642f, -0.3206f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.25f)).mirror(false).texOffs(48, 53).addBox(-2.5213f, -1.3642f, -0.3206f, 5.0f, 6.0f, 1.0f, new CubeDeformation(0.25f)).texOffs(28, 53).addBox(-5.5213f, -1.3642f, -0.3206f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0653f, (float)-0.0043f, (float)0.1745f, (float)0.0f, (float)0.0f));
            PartDefinition left_shoulder = left_arm.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(0, 60).addBox(-1.5f, -2.5f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.01f)).texOffs(20, 60).addBox(-1.5f, -2.5f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.26f)).texOffs(40, 60).addBox(-1.5f, 5.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.01f)).texOffs(60, 60).addBox(-1.5f, 5.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.26f)).texOffs(80, 62).addBox(2.5f, 4.5f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(90, 62).addBox(2.5f, 4.5f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition right_shoulder = right_arm.addOrReplaceChild("right_shoulder", CubeListBuilder.create().texOffs(40, 60).mirror().addBox(-3.5f, 5.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.01f)).mirror(false).texOffs(60, 60).mirror().addBox(-3.5f, 5.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.26f)).mirror(false).texOffs(80, 62).mirror().addBox(-4.5f, 4.5f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(90, 62).mirror().addBox(-4.5f, 4.5f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.25f)).mirror(false).texOffs(0, 60).mirror().addBox(-3.5f, -2.5f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.01f)).mirror(false).texOffs(20, 60).mirror().addBox(-3.5f, -2.5f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.26f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition left_leg = left_legging.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 82).mirror().addBox(-2.4f, -0.5f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition left_lower_robe = left_leg.addOrReplaceChild("left_lower_robe", CubeListBuilder.create().texOffs(20, 81).mirror().addBox(-4.0f, -1.0f, -5.0f, 4.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(42, 81).mirror().addBox(-4.0f, -1.0f, -5.0f, 4.0f, 7.0f, 7.0f, new CubeDeformation(0.25f)).mirror(false).texOffs(0, 95).mirror().addBox(0.0f, 3.0f, -5.0f, 1.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(16, 95).mirror().addBox(0.0f, 3.0f, -5.0f, 1.0f, 3.0f, 7.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offsetAndRotation((float)3.1f, (float)-0.5f, (float)1.5f, (float)0.0f, (float)0.0f, (float)-0.3491f));
            PartDefinition right_leg = right_legging.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 82).addBox(-2.6f, -0.5f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition right_lower_robe = right_leg.addOrReplaceChild("right_lower_robe", CubeListBuilder.create().texOffs(20, 81).addBox(0.0f, -1.0f, -5.0f, 4.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(42, 81).addBox(0.0f, -1.0f, -5.0f, 4.0f, 7.0f, 7.0f, new CubeDeformation(0.25f)).texOffs(0, 95).addBox(-1.0f, 3.0f, -5.0f, 1.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(16, 95).addBox(-1.0f, 3.0f, -5.0f, 1.0f, 3.0f, 7.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)-3.1f, (float)-0.5f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.3491f));
            PartDefinition codpiece = leggings.addOrReplaceChild("codpiece", CubeListBuilder.create().texOffs(0, 71).addBox(-5.0f, -14.5f, -3.5f, 10.0f, 3.0f, 7.0f, new CubeDeformation(0.01f)).texOffs(34, 71).addBox(-5.0f, -14.5f, -3.5f, 10.0f, 3.0f, 7.0f, new CubeDeformation(0.26f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
            PartDefinition left_boot = left_foot.addOrReplaceChild("left_boot", CubeListBuilder.create().texOffs(0, 105).mirror().addBox(-2.9f, 7.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.01f)).mirror(false).texOffs(24, 105).mirror().addBox(-2.9f, 7.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition right_boot = right_foot.addOrReplaceChild("right_boot", CubeListBuilder.create().texOffs(0, 105).addBox(-3.1f, 7.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(24, 105).addBox(-3.1f, 7.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
        });
    }
}

