/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlockEntity;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import com.sammy.malum.registry.client.MalumRenderTypes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import org.joml.Vector3f;
import org.joml.Vector4f;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;

public class VoidConduitRenderer
implements BlockEntityRenderer<VoidConduitBlockEntity> {
    public VoidConduitRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(VoidConduitBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderQuad(blockEntityIn, poseStack, partialTicks);
    }

    public void renderQuad(VoidConduitBlockEntity voidConduit, PoseStack poseStack, float partialTicks) {
        float height = 0.375f;
        float width = 1.5f;
        Vector3f[] positions = new Vector3f[]{new Vector3f(-width, height, width), new Vector3f(width, height, width), new Vector3f(width, height, -width), new Vector3f(-width, height, -width)};
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.01f, 0.5f);
        builder.replaceBufferSource(RenderHandler.LATE_DELAYED_RENDER).setRenderType((RenderType)LodestoneRenderTypes.TRANSPARENT_TEXTURE.apply(MalumRenderTypeTokens.VOID_VIGNETTE)).renderQuad(poseStack, positions, 1.0f);
        long gameTime = voidConduit.getLevel().getGameTime();
        float uOffset = ((float)gameTime + partialTicks) % 4000.0f / 2000.0f;
        float vOffset = ((float)gameTime + 500.0f + partialTicks) % 8000.0f / 8000.0f;
        float alpha = 0.05f;
        LodestoneRenderType renderType = MalumRenderTypes.WEEPING_WELL_DISTORTED_TEXTURE.apply(MalumRenderTypeTokens.VOID_NOISE);
        builder.replaceBufferSource((MultiBufferSource)RenderHandler.DELAYED_RENDER.getTarget());
        for (int i = 0; i < 3; ++i) {
            float speed = 1000.0f + 250.0f * (float)i;
            builder.setColor(MalumSpiritTypes.WICKED_SPIRIT.getPrimaryColor()).setRenderType((RenderType)LodestoneRenderTypes.applyUniformChanges((LodestoneRenderType)LodestoneRenderTypes.copyAndStore((Object)i, (LodestoneRenderType)renderType), s -> {
                s.safeGetUniform("Speed").set(speed);
                s.safeGetUniform("Width").set(48.0f);
                s.safeGetUniform("Height").set(48.0f);
                s.safeGetUniform("UVCoordinates").set(new Vector4f(-2.0f, 4.0f, -2.0f, 4.0f));
            }));
            builder.setAlpha(alpha);
            builder.setUV(-uOffset, vOffset, 1.0f - uOffset, 1.0f + vOffset).renderQuad(poseStack, positions, 1.0f);
            builder.setUV(uOffset, -vOffset, 1.0f + uOffset, 1.0f - vOffset).renderQuad(poseStack, positions, 1.0f);
            alpha -= 0.0125f;
            uOffset = -uOffset - 0.2f;
            vOffset = -vOffset + 0.4f;
            poseStack.translate(0.0f, 0.05f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            if (i != 0) continue;
            builder.setColor(MalumSpiritTypes.ELDRITCH_SPIRIT.getPrimaryColor());
        }
        poseStack.popPose();
    }
}

