/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block.redstone;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.common.block.curiosities.redstone.SpiritDiodeBlock;
import com.sammy.malum.common.block.curiosities.redstone.SpiritDiodeBlockEntity;
import com.sammy.malum.core.systems.item.HeldItemTracker;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import com.sammy.malum.registry.common.MalumTags;
import java.awt.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneBufferWrapper;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.cube.CubeVertexData;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public abstract class SpiritDiodeRenderer<T extends SpiritDiodeBlockEntity>
implements BlockEntityRenderer<T> {
    private static final MultiBufferSource TEXT = new LodestoneBufferWrapper(LodestoneRenderTypes.ADDITIVE_TEXT, (MultiBufferSource)RenderHandler.DELAYED_RENDER.getTarget());
    protected final RenderTypeToken output;
    protected final String langKey;
    protected static final Color COLOR = new Color(170, 15, 1);
    public static final HeldItemTracker CLAW_TRACKER = new HeldItemTracker(p -> p.is(MalumTags.ItemTags.IS_REDSTONE_TOOL));

    public SpiritDiodeRenderer(BlockEntityRendererProvider.Context context, ResourceLocation tokenTexture, String langKey) {
        this.output = RenderTypeToken.createToken((ResourceLocation)tokenTexture);
        this.langKey = langKey;
    }

    public abstract float getGlowDelta(T var1, float var2);

    public void render(T blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float timing;
        float delta;
        float pct;
        if (((SpiritDiodeBlockEntity)((Object)blockEntityIn)).visualTransitionDuration != 0 && (pct = Mth.clamp((float)this.getGlowDelta(blockEntityIn, delta = Mth.clampedLerp((float)((SpiritDiodeBlockEntity)((Object)blockEntityIn)).visualTransitionStart, (float)((SpiritDiodeBlockEntity)((Object)blockEntityIn)).visualTransitionEnd, (float)(timing = (float)(blockEntityIn.getLevel().getGameTime() - ((SpiritDiodeBlockEntity)((Object)blockEntityIn)).visualStartTime) / (float)((SpiritDiodeBlockEntity)((Object)blockEntityIn)).visualTransitionDuration))), (float)0.0f, (float)1.0f)) > 0.0f) {
            float alpha = Easing.CUBIC_OUT.clamped(pct, 0.0f, 1.0f) * 0.8f;
            float glowAlpha = Easing.SINE_OUT.clamped(pct, 0.0f, 1.0f) * 0.4f;
            CubeVertexData cubeVertexData = CubeVertexData.makeCubePositions((float)1.002f);
            VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setColor(COLOR);
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            BlockState state = blockEntityIn.getBlockState();
            for (int i = 0; i < 4; ++i) {
                Direction direction = Direction.from2DDataValue((int)i);
                RenderTypeToken token = this.getTokenForSide(state, direction);
                LodestoneRenderType transparent = LodestoneRenderTypes.TRANSPARENT_TEXTURE.apply(token);
                LodestoneRenderType additive = LodestoneRenderTypes.ADDITIVE_TEXTURE.apply(token);
                builder.setAlpha(alpha).setRenderType((RenderType)transparent).drawCubeSide(poseStack, cubeVertexData, direction);
                builder.setAlpha(glowAlpha).setRenderType((RenderType)additive).drawCubeSide(poseStack, cubeVertexData, direction);
            }
            poseStack.popPose();
        }
        if (CLAW_TRACKER.isVisible()) {
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            float delta2 = Easing.SINE_IN_OUT.clamped(CLAW_TRACKER.getDelta(partialTicks), 0.0f, 1.0f);
            float scale = 0.016f - (1.0f - delta2) * 0.004f;
            poseStack.pushPose();
            poseStack.translate(0.5f, 1.75f, 0.55f);
            poseStack.mulPose(minecraft.getEntityRenderDispatcher().cameraOrientation());
            poseStack.scale(scale, -scale, -scale);
            MutableComponent base = Component.translatable((String)this.langKey).append((Component)Component.translatable((String)"malum.waveform_artifice.value_display", (Object[])new Object[]{((SpiritDiodeBlockEntity)((Object)blockEntityIn)).frequency, ((SpiritDiodeBlockEntity)((Object)blockEntityIn)).type.getText()}));
            MutableComponent textComponent = base.copy().withStyle(ChatFormatting.RED);
            MutableComponent outlineComponent = base.withStyle(ChatFormatting.DARK_RED);
            float f = (float)(-font.width((FormattedText)textComponent)) / 2.0f;
            float xPos = 0.0f + f;
            Matrix4f pose = poseStack.last().pose();
            float alpha = 0.38f * delta2;
            int color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (alpha > 0.02f) {
                SpiritDiodeRenderer.renderText(textComponent, xPos, 0.0f, color, pose);
            }
            if ((alpha = 0.18f * delta2) > 0.02f) {
                color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                SpiritDiodeRenderer.renderText(textComponent, xPos - 0.5f, 0.0f, color, pose);
                SpiritDiodeRenderer.renderText(textComponent, xPos - 0.5f, 0.0f, color, pose);
                SpiritDiodeRenderer.renderText(textComponent, xPos, 0.5f, color, pose);
                SpiritDiodeRenderer.renderText(textComponent, xPos, -0.5f, color, pose);
            }
            if ((alpha = 0.12f * delta2) > 0.02f) {
                color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                SpiritDiodeRenderer.renderText(textComponent, xPos - 1.0f, 0.0f, color, pose);
                SpiritDiodeRenderer.renderText(outlineComponent, xPos + 1.0f, 0.0f, color, pose);
                SpiritDiodeRenderer.renderText(outlineComponent, xPos, 1.0f, color, pose);
                SpiritDiodeRenderer.renderText(textComponent, xPos, -1.0f, color, pose);
                SpiritDiodeRenderer.renderText(outlineComponent, xPos - 0.5f, -0.5f, color, pose);
                SpiritDiodeRenderer.renderText(textComponent, xPos - 0.5f, 0.5f, color, pose);
                SpiritDiodeRenderer.renderText(outlineComponent, xPos + 0.5f, 0.5f, color, pose);
                SpiritDiodeRenderer.renderText(textComponent, xPos + 0.5f, -0.5f, color, pose);
            }
            poseStack.popPose();
        }
    }

    public static void renderText(MutableComponent component, float xPos, float yPos, int color, Matrix4f pose) {
        Font font = Minecraft.getInstance().font;
        font.drawInBatch((Component)component, xPos, yPos, color, false, pose, TEXT, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public RenderTypeToken getTokenForSide(BlockState state, Direction direction) {
        Direction facing = (Direction)state.getValue((Property)SpiritDiodeBlock.FACING);
        if (direction.equals((Object)facing.getOpposite())) {
            return MalumRenderTypeTokens.DIODE_INPUT;
        }
        if (direction.equals((Object)facing)) {
            return this.output;
        }
        return MalumRenderTypeTokens.DIODE_LOCKED;
    }
}

