/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.client.screen.codex.screens.AbstractProgressionCodexScreen;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.config.ClientConfig;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.MalumShaders;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.registry.client.LodestoneShaders;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneBufferWrapper;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class ArcanaCodexHelper {
    public static final VFXBuilders.ScreenVFXBuilder VFX_BUILDER = VFXBuilders.createScreen();
    public static final Function<GuiGraphics, LodestoneBufferWrapper> WRAPPER_FUNCTION = Util.memoize(guiGraphics -> new LodestoneBufferWrapper(LodestoneRenderTypes.ADDITIVE_TEXT, (MultiBufferSource)guiGraphics.bufferSource));
    public static final TextColorData DEFAULT_TEXT_COLOR = new TextColorData(new Color(138, 79, 58), new Color(65, 41, 8), new Color(20, 44, 60), new Color(227, 39, 228));
    public static final TextColorData GEAS_POSITIVE_COLOR = new TextColorData(new Color(18, 52, 141), new Color(118, 52, 141), new Color(20, 44, 120), new Color(100, 100, 240));
    public static final TextColorData GEAS_NEGATIVE_COLOR = new TextColorData(new Color(141, 18, 52), new Color(118, 52, 141), new Color(120, 44, 20), new Color(240, 100, 100));

    public static <T extends AbstractProgressionCodexScreen> void renderTransitionFade(T screen, PoseStack stack) {
        float pct = (float)screen.transitionTimer / (float)screen.getTransitionDuration();
        float overlayAlpha = Easing.SINE_IN_OUT.ease(pct, 0.0f, 1.0f, 1.0f);
        float effectStrength = Easing.QUAD_OUT.ease(pct, 0.0f, 1.0f, 1.0f);
        float effectAlpha = Math.min(1.0f, effectStrength * 1.0f);
        float zoom = 0.5f + Math.min(0.35f, effectStrength);
        float intensity = 1.0f + (effectStrength > 0.5f ? (effectStrength - 0.5f) * 2.5f : 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPositionWithWidth((float)screen.getInsideLeft(), (float)screen.getInsideTop(), (float)screen.bookInsideWidth, (float)screen.bookInsideHeight).setColor(0, 0, 0).setAlpha(overlayAlpha).setZLevel(200).setShader(GameRenderer::getPositionColorShader).blit(stack);
        ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)MalumShaders.TOUCH_OF_DARKNESS.getInstance().get();
        shaderInstance.safeGetUniform("Speed").set(1000.0f);
        Consumer<Float> setZoom = f -> shaderInstance.safeGetUniform("Zoom").set(f.floatValue());
        Consumer<Float> setIntensity = f -> shaderInstance.safeGetUniform("Intensity").set(f.floatValue());
        builder.setAlpha(effectAlpha).setShader((ShaderInstance)shaderInstance);
        setZoom.accept(Float.valueOf(zoom));
        setIntensity.accept(Float.valueOf(intensity));
        builder.blit(stack);
        setZoom.accept(Float.valueOf(zoom * 1.25f + 0.15f));
        setIntensity.accept(Float.valueOf(intensity * 0.8f + 0.5f));
        builder.blit(stack);
        shaderInstance.setUniformDefaults();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void renderRiteIcon(TotemicRiteType rite, PoseStack stack, boolean corrupted, float glowAlpha, float x, float y) {
        ArcanaCodexHelper.renderRiteIcon(rite.getIcon(), stack, rite.getIdentifyingSpirit(), corrupted, glowAlpha, x, y, 0);
    }

    public static void renderRiteIcon(ResourceLocation texture, PoseStack stack, MalumSpiritType spiritType, boolean corrupted, float glowAlpha, float x, float y) {
        ArcanaCodexHelper.renderRiteIcon(texture, stack, spiritType, corrupted, glowAlpha, x, y, 0);
    }

    public static void renderRiteIcon(ResourceLocation texture, PoseStack stack, MalumSpiritType spiritType, boolean corrupted, float glowAlpha, float x, float y, int z) {
        ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)LodestoneShaders.SCREEN_DISTORTED_TEXTURE.getInstance().get();
        shaderInstance.safeGetUniform("YFrequency").set(corrupted ? 5.0f : 11.0f);
        shaderInstance.safeGetUniform("XFrequency").set(corrupted ? 12.0f : 17.0f);
        shaderInstance.safeGetUniform("Speed").set(1500.0f * (corrupted ? -0.75f : 1.0f));
        shaderInstance.safeGetUniform("Intensity").set(corrupted ? 14.0f : 50.0f);
        Supplier<ShaderInstance> shaderInstanceSupplier = () -> shaderInstance;
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setShader(shaderInstanceSupplier).setColor(spiritType.getPrimaryColor()).setAlpha(0.9f).setZLevel(z);
        RenderSystem.blendFunc((int)770, (int)1);
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        builder.setAlpha(glowAlpha);
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x - 1.0f, y, 0.0f, 0.0f, 16, 16, 16, 16);
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x + 1.0f, y, 0.0f, 0.0f, 16, 16, 16, 16);
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x, y - 1.0f, 0.0f, 0.0f, 16, 16, 16, 16);
        if (corrupted) {
            builder.setColor(spiritType.getSecondaryColor());
        }
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x, y + 1.0f, 0.0f, 0.0f, 16, 16, 16, 16);
        shaderInstance.setUniformDefaults();
        RenderSystem.defaultBlendFunc();
    }

    public static void renderGeasIcon(ResourceLocation location, PoseStack stack, GeasEffectType type, float x, float y) {
        ArcanaCodexHelper.renderGeasIcon(location, stack, type, x, y, 0);
    }

    public static void renderGeasIcon(ResourceLocation location, PoseStack stack, GeasEffectType type, float x, float y, int z) {
        ArcanaCodexHelper.renderGeasIcon(location, stack, type, x, y, z, 16, 16);
    }

    public static void renderGeasIcon(ResourceLocation location, PoseStack stack, GeasEffectType type, float x, float y, int z, int textureWidth, int textureHeight) {
        ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)LodestoneShaders.SCREEN_DISTORTED_TEXTURE.getInstance().get();
        shaderInstance.safeGetUniform("YFrequency").set(10.0f);
        shaderInstance.safeGetUniform("XFrequency").set(12.0f);
        shaderInstance.safeGetUniform("Speed").set(1000.0f);
        shaderInstance.safeGetUniform("Intensity").set(50.0f);
        shaderInstance.safeGetUniform("UVCoordinates").set(new Vector4f(0.0f, 1.0f, 0.0f, 1.0f));
        Supplier<ShaderInstance> shaderInstanceSupplier = () -> shaderInstance;
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setShader(shaderInstanceSupplier).setZLevel(z).setShader(() -> shaderInstance);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        AtomicInteger cycle = new AtomicInteger();
        List<MalumSpiritType> spiritTypes = type.spiritTypes;
        Supplier<MalumSpiritType> colorSupplier = () -> (MalumSpiritType)spiritTypes.get(cycle.getAndIncrement() % spiritTypes.size());
        Color mainColor = colorSupplier.get().getPrimaryColor();
        if (spiritTypes.getFirst().equals(MalumSpiritTypes.AQUEOUS_SPIRIT)) {
            mainColor = ColorHelper.brighter((Color)mainColor, (int)2);
        }
        if (spiritTypes.getFirst().equals(MalumSpiritTypes.SACRED_SPIRIT) || spiritTypes.getFirst().equals(MalumSpiritTypes.WICKED_SPIRIT)) {
            mainColor = ColorHelper.brighter((Color)mainColor, (int)1);
        }
        builder.setColor(colorSupplier.get().getPrimaryColor()).multiplyColor(0.24f).setAlpha(0.6f);
        shaderInstance.safeGetUniform("Speed").set(2000.0f);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x - 1.0f, y, 0, 0.0f, 0.0f, textureWidth, textureHeight);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x + 1.0f, y, 1, 0.0f, 0.0f, textureWidth, textureHeight);
        builder.setColor(colorSupplier.get().getPrimaryColor()).multiplyColor(0.24f);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y - 1.0f, 2, 0.0f, 0.0f, textureWidth, textureHeight);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y + 0.8f, 3, 0.0f, 0.0f, textureWidth, textureHeight);
        RenderSystem.blendFunc((int)770, (int)1);
        builder.setColor(mainColor).setAlpha(0.7f);
        shaderInstance.safeGetUniform("Speed").set(1000.0f);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y, 4, 0.0f, 0.0f, textureWidth, textureHeight);
        builder.setColor(ColorHelper.brighter((Color)mainColor, (int)4)).setAlpha(0.2f);
        shaderInstance.safeGetUniform("Speed").set(400.0f);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x + 2.0f, y + 2.0f, 5, 2.0f, 2.0f, 12, 12, textureWidth, textureHeight);
        builder.setColor(colorSupplier.get().getSecondaryColor());
        shaderInstance.safeGetUniform("Speed").set(2000.0f);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x + 1.0f, y, 6, 0.0f, 0.0f, textureWidth, textureHeight);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x - 1.0f, y, 7, 0.0f, 0.0f, textureWidth, textureHeight);
        builder.setColor(colorSupplier.get().getSecondaryColor());
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y + 1.0f, 8, 0.0f, 0.0f, textureWidth, textureHeight);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y - 1.0f, 9, 0.0f, 0.0f, textureWidth, textureHeight);
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        shaderInstance.setUniformDefaults();
    }

    public static void renderWavyIcon(ResourceLocation location, PoseStack stack, float x, float y) {
        ArcanaCodexHelper.renderWavyIcon(location, stack, x, y, 0);
    }

    public static void renderWavyIcon(ResourceLocation location, PoseStack stack, float x, float y, int z) {
        ArcanaCodexHelper.renderWavyIcon(location, stack, x, y, z, 16, 16);
    }

    public static void renderWavyIcon(ResourceLocation location, PoseStack stack, float x, float y, int z, int textureWidth, int textureHeight) {
        ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)LodestoneShaders.SCREEN_DISTORTED_TEXTURE.getInstance().get();
        shaderInstance.safeGetUniform("YFrequency").set(10.0f);
        shaderInstance.safeGetUniform("XFrequency").set(12.0f);
        shaderInstance.safeGetUniform("Speed").set(1000.0f);
        shaderInstance.safeGetUniform("Intensity").set(50.0f);
        shaderInstance.safeGetUniform("UVCoordinates").set(new Vector4f(0.0f, 1.0f, 0.0f, 1.0f));
        Supplier<ShaderInstance> shaderInstanceSupplier = () -> shaderInstance;
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setShader(shaderInstanceSupplier).setAlpha(0.7f).setZLevel(z).setShader(() -> shaderInstance);
        RenderSystem.blendFunc((int)770, (int)1);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y, 0, 0.0f, 0.0f, textureWidth, textureHeight);
        builder.setAlpha(0.1f);
        shaderInstance.safeGetUniform("Speed").set(2000.0f);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x - 1.0f, y, 1, 0.0f, 0.0f, textureWidth, textureHeight);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x + 1.0f, y, 2, 0.0f, 0.0f, textureWidth, textureHeight);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y - 1.0f, 3, 0.0f, 0.0f, textureWidth, textureHeight);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y + 1.0f, 4, 0.0f, 0.0f, textureWidth, textureHeight);
        shaderInstance.setUniformDefaults();
        RenderSystem.defaultBlendFunc();
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, float x, float y, float u, float v, int width, int height) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, x, y, u, v, width, height, width, height);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, float x, float y, int z, float u, float v, int width, int height) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, x, y, z, u, v, width, height, width, height);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, float x, float y, float u, float v, int width, int height, int canvasWidth, int canvasHeight) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, VFX_BUILDER, x, y, 0, u, v, width, height, canvasWidth, canvasHeight);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, float x, float y, int z, float u, float v, int width, int height, int canvasWidth, int canvasHeight) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, VFX_BUILDER, x, y, z, u, v, width, height, canvasWidth, canvasHeight);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, float x, float y, int z, float u, float v, int width, int height) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, builder, x, y, z, u, v, width, height, width, height);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, float x, float y, float u, float v, int width, int height, int canvasWidth, int canvasHeight) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, builder, x, y, 0, u, v, width, height, canvasWidth, canvasHeight);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, float x, float y, int z, float u, float v, int width, int height, int canvasWidth, int canvasHeight) {
        ArcanaCodexHelper.renderTexture(poseStack, builder.setShaderTexture(texture).setPositionWithWidth(x, y, (float)width, (float)height), z, u, v, width, height, canvasWidth, canvasHeight);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, float x, float y, float u, float v, int width, int height, int textureWidth, int textureHeight, int canvasWidth, int canvasHeight) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, builder, x, y, 0, u, v, width, height, textureWidth, textureHeight, canvasWidth, canvasHeight);
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, float x, float y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight, int canvasWidth, int canvasHeight) {
        ArcanaCodexHelper.renderTexture(poseStack, builder.setShaderTexture(texture).setPositionWithWidth(x, y, (float)width, (float)height), z, u, v, textureWidth, textureHeight, canvasWidth, canvasHeight);
    }

    private static void renderTexture(PoseStack poseStack, VFXBuilders.ScreenVFXBuilder builder, int z, float u, float v, int width, int height, int canvasWidth, int canvasHeight) {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        builder.setZLevel(z).setUVWithWidth(u, v, (float)width, (float)height, (float)canvasWidth, (float)canvasHeight).blit(poseStack);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void renderIngredient(AbstractMalumScreen screen, GuiGraphics guiGraphics, ICustomIngredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        ArcanaCodexHelper.renderItem(screen, guiGraphics, ingredient.getItems().toList(), posX, posY, mouseX, mouseY);
    }

    public static void renderIngredient(AbstractMalumScreen screen, GuiGraphics guiGraphics, SizedIngredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        ArcanaCodexHelper.renderItem(screen, guiGraphics, List.of(ingredient.getItems()), posX, posY, mouseX, mouseY);
    }

    public static void renderIngredient(AbstractMalumScreen screen, GuiGraphics guiGraphics, Ingredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        ArcanaCodexHelper.renderItem(screen, guiGraphics, List.of(ingredient.getItems()), posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumScreen screen, GuiGraphics guiGraphics, ICustomIngredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        ArcanaCodexHelper.renderItem(screen, guiGraphics, ingredient.getItems().toList(), posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumScreen screen, GuiGraphics guiGraphics, SizedIngredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        ArcanaCodexHelper.renderItem(screen, guiGraphics, List.of(ingredient.getItems()), posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumScreen screen, GuiGraphics guiGraphics, Ingredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        ArcanaCodexHelper.renderItem(screen, guiGraphics, List.of(ingredient.getItems()), posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumScreen screen, GuiGraphics guiGraphics, List<ItemStack> stacks, int posX, int posY, int mouseX, int mouseY) {
        if (stacks.isEmpty()) {
            return;
        }
        if (stacks.size() == 1) {
            ArcanaCodexHelper.renderItem(screen, guiGraphics, stacks.getFirst(), posX, posY, mouseX, mouseY);
            return;
        }
        int index = (int)(Minecraft.getInstance().level.getGameTime() % (20L * (long)stacks.size()) / 20L);
        ItemStack stack = stacks.get(index);
        ArcanaCodexHelper.renderItem(screen, guiGraphics, stack, posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumScreen screen, GuiGraphics guiGraphics, ItemStack stack, int posX, int posY, int mouseX, int mouseY) {
        if (!stack.isEmpty()) {
            guiGraphics.renderItem(stack, posX, posY);
            guiGraphics.renderItemDecorations(Minecraft.getInstance().font, stack, posX, posY, null);
            if (screen.isHovering(mouseX, mouseY, posX, posY, 16, 16)) {
                screen.renderLater(() -> guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)stack), mouseX, mouseY));
            }
        }
    }

    public static void renderIngredients(AbstractMalumScreen screen, GuiGraphics guiGraphics, List<?> ingredients, Component hoverComponent, int left, int top, int mouseX, int mouseY, boolean vertical) {
        List<List<ItemStack>> stackBundles = Stream.of(ingredients.stream().filter(o -> o instanceof ICustomIngredient).map(o -> ((ICustomIngredient)o).getItems().toList()), ingredients.stream().filter(o -> o instanceof SizedIngredient).map(o -> Arrays.stream(((SizedIngredient)o).getItems()).toList()), ingredients.stream().filter(o -> o instanceof Ingredient).map(o -> Arrays.stream(((Ingredient)o).getItems()).toList())).flatMap(s -> s).toList();
        ArcanaCodexHelper.renderItemList(screen, guiGraphics, stackBundles, hoverComponent, left, top, mouseX, mouseY, vertical);
    }

    public static void renderItemList(AbstractMalumScreen screen, GuiGraphics guiGraphics, List<List<ItemStack>> items, Component hoverComponent, int left, int top, int mouseX, int mouseY, boolean isVertical) {
        int slots = items.size();
        int startingOffset = 9 * (slots - 1);
        screen.renderLater(ArcanaCodexHelper.renderItemFrames(guiGraphics, hoverComponent, slots, left, top, mouseX, mouseY, items.getFirst().getFirst().getItem() instanceof SpiritShardItem, isVertical));
        if (isVertical) {
            top -= startingOffset;
        } else {
            left -= startingOffset;
        }
        for (int i = 0; i < slots; ++i) {
            List<ItemStack> list = items.get(i);
            int offset = i * 18;
            int oLeft = left + (isVertical ? 0 : offset);
            int oTop = top + (isVertical ? offset : 0);
            ArcanaCodexHelper.renderItem(screen, guiGraphics, list, oLeft, oTop, mouseX, mouseY);
        }
    }

    public static void renderItemFrames(GuiGraphics guiGraphics, int slots, int left, int top, double mouseX, double mouseY, boolean isSpirits, boolean isVertical) {
        ArcanaCodexHelper.renderItemFrames(guiGraphics, null, slots, left, top, mouseX, mouseY, isSpirits, isVertical);
    }

    public static Runnable renderItemFrames(GuiGraphics guiGraphics, @Nullable Component hoverComponent, int slots, int left, int top, double mouseX, double mouseY, boolean isSpirits, boolean isVertical) {
        PoseStack poseStack = guiGraphics.pose();
        int startingOffset = 9 * (slots - 1);
        if (isVertical) {
            top -= startingOffset;
        } else {
            left -= startingOffset;
        }
        for (int i = slots - 1; i >= 0; --i) {
            int offset = i * 18;
            int u = isVertical ? 0 : 2;
            int v = isVertical ? 2 : 0;
            int oLeft = left - 1 + (isVertical ? -2 : offset);
            int oTop = top - 1 + (isVertical ? offset : -2);
            int width = isVertical ? 22 : 18;
            int height = isVertical ? 18 : 22;
            ArcanaCodexHelper.renderTexture(EntryScreen.ITEM_SOCKET, poseStack, oLeft, (float)oTop, (float)u, (float)v, width, height, 64, 64);
        }
        if (isVertical) {
            ArcanaCodexHelper.renderTexture(EntryScreen.ITEM_SOCKET, poseStack, left - 3, (float)(top - 3), 0.0f, 0.0f, 22, 2, 64, 64);
            ArcanaCodexHelper.renderTexture(EntryScreen.ITEM_SOCKET, poseStack, left - 3, (float)(top - 1 + 18 * slots), 0.0f, 20.0f, 22, 2, 64, 64);
        } else {
            ArcanaCodexHelper.renderTexture(EntryScreen.ITEM_SOCKET, poseStack, left - 3, (float)(top - 3), 0.0f, 0.0f, 2, 22, 64, 64);
            ArcanaCodexHelper.renderTexture(EntryScreen.ITEM_SOCKET, poseStack, left - 1 + 18 * slots, (float)(top - 3), 20.0f, 0.0f, 2, 22, 64, 64);
        }
        return () -> {
            if (hoverComponent != null) {
                // empty if block
            }
        };
    }

    public static MutableComponent convertToComponent(String text) {
        return ArcanaCodexHelper.convertToComponent(text, UnaryOperator.identity());
    }

    public static MutableComponent convertToComponent(String text, UnaryOperator<Style> styleModifier) {
        text = Component.translatable((String)text).getString();
        MutableComponent raw = Component.empty();
        boolean italic = false;
        boolean bold = false;
        boolean strikethrough = false;
        boolean underline = false;
        boolean obfuscated = false;
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char peek;
            char chr = text.charAt(i);
            if (chr == '$') {
                if (i != text.length() - 1) {
                    peek = text.charAt(i + 1);
                    switch (peek) {
                        case 'i': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            italic = true;
                            ++i;
                            break;
                        }
                        case 'b': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            bold = true;
                            ++i;
                            break;
                        }
                        case 's': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            strikethrough = true;
                            ++i;
                            break;
                        }
                        case 'u': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            underline = true;
                            ++i;
                            break;
                        }
                        case 'k': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            obfuscated = true;
                            ++i;
                            break;
                        }
                        default: {
                            line.append(chr);
                            break;
                        }
                    }
                    continue;
                }
                line.append(chr);
                continue;
            }
            if (chr == '/') {
                if (i != text.length() - 1) {
                    peek = text.charAt(i + 1);
                    if (peek == '$') {
                        line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                        obfuscated = false;
                        underline = false;
                        strikethrough = false;
                        bold = false;
                        italic = false;
                        ++i;
                        continue;
                    }
                    line.append(chr);
                    continue;
                }
                line.append(chr);
                continue;
            }
            line.append(chr);
        }
        ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
        return raw;
    }

    public static void renderWrappingText(GuiGraphics guiGraphics, String text, float x, float y, int width) {
        ArcanaCodexHelper.renderWrappingText(guiGraphics, (Component)Component.translatable((String)text), x, y, width);
    }

    public static void renderWrappingText(GuiGraphics guiGraphics, Component text, float x, float y, int width) {
        ArcanaCodexHelper.renderWrappingText(guiGraphics, DEFAULT_TEXT_COLOR, text, x, y, width);
    }

    public static void renderWrappingText(GuiGraphics guiGraphics, TextColorData colorData, String text, float x, float y, int width) {
        ArcanaCodexHelper.renderWrappingText(guiGraphics, colorData, (Component)Component.translatable((String)text), x, y, width);
    }

    public static void renderWrappingText(GuiGraphics guiGraphics, TextColorData colorData, Component text, float x, float y, int width) {
        float scale = 1.0f;
        String translated = text.getString();
        if (translated.startsWith("$m")) {
            int i = translated.indexOf("/$");
            float value = Float.parseFloat(translated.substring(3, i));
            text = Component.literal((String)translated.substring(i + 2));
            scale = value;
        }
        ArcanaCodexHelper.renderWrappingText(guiGraphics, colorData, text, x, y, width, scale);
    }

    public static void renderWrappingText(GuiGraphics guiGraphics, TextColorData colorData, Component text, float x, float y, int width, float scaleMultiplier) {
        Font font = Minecraft.getInstance().font;
        List<String> lines = ArcanaCodexHelper.wrapText(text, (int)((float)width / scaleMultiplier));
        for (int i = 0; i < lines.size(); ++i) {
            String currentLine = lines.get(i);
            float textX = x;
            float textY = y;
            if (scaleMultiplier != 1.0f) {
                textX /= scaleMultiplier;
                textY /= scaleMultiplier;
            }
            Objects.requireNonNull(font);
            ArcanaCodexHelper.renderRawText(guiGraphics, colorData, currentLine, textX, textY + (float)(i * (9 + 1)), 0.2f, scaleMultiplier);
        }
    }

    public static List<Component> wrapComponent(String text, int width) {
        return ArcanaCodexHelper.wrapText(text, width).stream().map(Component::literal).map(Component.class::cast).toList();
    }

    public static List<Component> wrapComponent(Component component, int width) {
        return ArcanaCodexHelper.wrapText(component, width).stream().map(Component::literal).map(Component.class::cast).toList();
    }

    public static List<String> wrapText(String text, int width) {
        return ArcanaCodexHelper.wrapText((Component)Component.translatable((String)text), width);
    }

    public static List<String> wrapText(Component component, int width) {
        Font font = Minecraft.getInstance().font;
        String text = component.getString() + "\n";
        ArrayList<String> lines = new ArrayList<String>();
        boolean italic = false;
        boolean bold = false;
        boolean strikethrough = false;
        boolean underline = false;
        boolean obfuscated = false;
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr == ' ' || chr == '\n') {
                if (!word.isEmpty()) {
                    if (font.width(line.toString()) + font.width(word.toString()) > width) {
                        line = ArcanaCodexHelper.newLine(lines, italic, bold, strikethrough, underline, obfuscated, line);
                    }
                    line.append((CharSequence)word).append(' ');
                    word = new StringBuilder();
                }
                String noFormatting = ChatFormatting.stripFormatting((String)line.toString());
                if (chr != '\n' || noFormatting == null) continue;
                line = ArcanaCodexHelper.newLine(lines, italic, bold, strikethrough, underline, obfuscated, line);
                continue;
            }
            if (chr == '$') {
                if (i != text.length() - 1) {
                    char peek = text.charAt(i + 1);
                    switch (peek) {
                        case 'i': {
                            word.append(ChatFormatting.ITALIC);
                            italic = true;
                            ++i;
                            break;
                        }
                        case 'b': {
                            word.append(ChatFormatting.BOLD);
                            bold = true;
                            ++i;
                            break;
                        }
                        case 's': {
                            word.append(ChatFormatting.STRIKETHROUGH);
                            strikethrough = true;
                            ++i;
                            break;
                        }
                        case 'u': {
                            word.append(ChatFormatting.UNDERLINE);
                            underline = true;
                            ++i;
                            break;
                        }
                        case 'k': {
                            word.append(ChatFormatting.OBFUSCATED);
                            obfuscated = true;
                            ++i;
                            break;
                        }
                        default: {
                            word.append(chr);
                            break;
                        }
                    }
                    continue;
                }
                word.append(chr);
                continue;
            }
            if (chr == '/') {
                if (i != text.length() - 1) {
                    char peek = text.charAt(i + 1);
                    if (peek == '$') {
                        obfuscated = false;
                        underline = false;
                        strikethrough = false;
                        bold = false;
                        italic = false;
                        word.append(ChatFormatting.RESET);
                        ++i;
                        continue;
                    }
                    word.append(chr);
                    continue;
                }
                word.append(chr);
                continue;
            }
            word.append(chr);
        }
        return lines;
    }

    private static StringBuilder commitComponent(MutableComponent component, boolean italic, boolean bold, boolean strikethrough, boolean underline, boolean obfuscated, StringBuilder line, UnaryOperator<Style> styleModifier) {
        component.append((Component)Component.literal((String)line.toString()).withStyle(style -> style.withItalic(Boolean.valueOf(italic)).withBold(Boolean.valueOf(bold)).withStrikethrough(Boolean.valueOf(strikethrough)).withUnderlined(Boolean.valueOf(underline)).withObfuscated(Boolean.valueOf(obfuscated))).withStyle(styleModifier));
        line = new StringBuilder();
        return line;
    }

    private static StringBuilder newLine(List<String> lines, boolean italic, boolean bold, boolean strikethrough, boolean underline, boolean obfuscated, StringBuilder line) {
        lines.add(line.toString());
        line = new StringBuilder();
        if (italic) {
            line.append(ChatFormatting.ITALIC);
        }
        if (bold) {
            line.append(ChatFormatting.BOLD);
        }
        if (strikethrough) {
            line.append(ChatFormatting.STRIKETHROUGH);
        }
        if (underline) {
            line.append(ChatFormatting.UNDERLINE);
        }
        if (obfuscated) {
            line.append(ChatFormatting.OBFUSCATED);
        }
        return line;
    }

    public static void renderHeadline(GuiGraphics graphics, Component component, int left, int top) {
        int width = Minecraft.getInstance().font.width(component.getString());
        float scale = 1.0f;
        if (width > 100) {
            scale -= (float)(width - 100) / 200.0f;
        }
        float textLeft = left + 72;
        float textTop = top + 5;
        if (scale != 1.0f) {
            textLeft /= scale;
            textTop /= scale;
            textTop += 5.0f * (1.0f - scale);
        }
        ArcanaCodexHelper.renderText(graphics, component, textLeft - (float)width / 2.0f, textTop, scale);
    }

    public static void renderText(GuiGraphics guiGraphics, Component component, float x, float y) {
        ArcanaCodexHelper.renderText(guiGraphics, DEFAULT_TEXT_COLOR, component, x, y, 0.4f);
    }

    public static void renderText(GuiGraphics guiGraphics, Component component, float x, float y, float scale) {
        ArcanaCodexHelper.renderRawText(guiGraphics, DEFAULT_TEXT_COLOR, component.getString(), x, y, 0.4f, scale);
    }

    public static void renderText(GuiGraphics guiGraphics, TextColorData colorData, Component component, float x, float y, float glow) {
        ArcanaCodexHelper.renderText(guiGraphics, colorData, component, x, y, glow, 1.0f);
    }

    public static void renderText(GuiGraphics guiGraphics, TextColorData colorData, Component component, float x, float y, float glow, float scale) {
        String text = component.getString();
        ArcanaCodexHelper.renderRawText(guiGraphics, colorData, text, x, y, glow, scale);
    }

    private static void renderRawText(GuiGraphics guiGraphics, TextColorData colorData, String text, float x, float y, float glowMultiplier, float scaleMultiplier) {
        Minecraft minecraft = Minecraft.getInstance();
        PoseStack poseStack = guiGraphics.pose();
        Font font = minecraft.font;
        float guiScale = (float)minecraft.getWindow().getGuiScale();
        float inverseScale = 4.0f / guiScale * 4.0f * scaleMultiplier;
        float width = (float)font.width(text) / 2.0f;
        float screenWidth = minecraft.getWindow().getScreenWidth();
        float screenHeight = minecraft.getWindow().getScreenHeight();
        float mouseX = (float)(minecraft.mouseHandler.xpos() / (double)screenWidth);
        float mouseY = (float)(minecraft.mouseHandler.ypos() / (double)screenHeight);
        Objects.requireNonNull(font);
        float lineHeight = 9.0f;
        if (scaleMultiplier != 1.0f) {
            poseStack.pushPose();
            poseStack.scale(scaleMultiplier, scaleMultiplier, 1.0f);
            mouseX /= scaleMultiplier;
            mouseY /= scaleMultiplier;
        }
        float textX = (x + width) * guiScale / screenWidth;
        float textY = (y + lineHeight) * guiScale / screenHeight;
        float differenceX = textX - mouseX;
        float differenceY = textY - mouseY;
        double horizontalDelta = Math.clamp(1.0f - Mth.abs((float)differenceX) * inverseScale, 0.0f, 1.0f);
        double verticalDelta = Math.clamp(1.0f - Mth.abs((float)differenceY) * inverseScale, 0.0f, 1.0f);
        if (differenceY > 0.0f) {
            verticalDelta = Math.pow(verticalDelta * (double)(1.0f - differenceY), 3.0);
        }
        double delta = Easing.QUINTIC_OUT.ease(horizontalDelta, 0.0, 1.0) * Easing.QUINTIC_OUT.ease(verticalDelta, 0.0, 1.0);
        if (EntryScreen.textJump > 0.0f) {
            double jumpDelta = delta * (double)Easing.SINE_IN_OUT.ease(EntryScreen.textJump, 0.0f, 1.0f);
            glowMultiplier *= (float)(1.0 + jumpDelta);
        }
        if (((BookTheme)((Object)ClientConfig.BOOK_THEME.getConfigValue())).equals((Object)BookTheme.EASY_READING)) {
            Color color = colorData.secondaryColor();
            guiGraphics.drawString(font, text, x, y, 0, false);
            font.drawInBatch(text, x, y, FastColor.ARGB32.color((int)1, (int)color.getRGB()), false, poseStack.last().pose(), (MultiBufferSource)guiGraphics.bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
        } else {
            Color gray = colorData.primaryColor();
            Color dark = colorData.secondaryColor();
            guiGraphics.drawString(font, text, x - 1.0f, y, FastColor.ARGB32.color((int)64, (int)gray.getRGB()), false);
            guiGraphics.drawString(font, text, x + 1.0f, y, FastColor.ARGB32.color((int)32, (int)gray.getRGB()), false);
            guiGraphics.drawString(font, text, x, y - 1.0f, FastColor.ARGB32.color((int)32, (int)gray.getRGB()), false);
            guiGraphics.drawString(font, text, x, y + 1.0f, FastColor.ARGB32.color((int)92, (int)gray.getRGB()), false);
            guiGraphics.drawString(font, text, x, y, FastColor.ARGB32.color((int)255, (int)dark.getRGB()), false);
            int alpha = Mth.floor((float)(255.0f * Easing.QUARTIC_IN.ease(delta, (double)0.4f, 1.0, 1.0) * glowMultiplier));
            if (alpha > 15) {
                float color = Easing.CUBIC_IN.ease(delta, 0.0, 1.0, 1.0);
                Color start = colorData.glowStart();
                Color end = colorData.glowEnd();
                int r = (int)Mth.lerp((float)color, (float)start.getRed(), (float)end.getRed());
                int g = (int)Mth.lerp((float)color, (float)start.getGreen(), (float)end.getGreen());
                int b = (int)Mth.lerp((float)color, (float)start.getBlue(), (float)end.getBlue());
                LodestoneBufferWrapper buffer = WRAPPER_FUNCTION.apply(guiGraphics);
                Matrix4f pose = poseStack.last().pose();
                RenderSystem.enableBlend();
                font.drawInBatch(text, x, y, FastColor.ARGB32.color((int)alpha, (int)r, (int)g, (int)b), false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
                font.drawInBatch(text, x + 1.0f, y, FastColor.ARGB32.color((int)(alpha / 2), (int)r, (int)g, (int)b), false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
                font.drawInBatch(text, x - 1.0f, y, FastColor.ARGB32.color((int)(alpha / 3), (int)r, (int)g, (int)b), false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
                font.drawInBatch(text, x, y + 1.0f, FastColor.ARGB32.color((int)(alpha / 2), (int)r, (int)g, (int)b), false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
                font.drawInBatch(text, x, y - 1.0f, FastColor.ARGB32.color((int)(alpha / 3), (int)r, (int)g, (int)b), false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
                RenderSystem.defaultBlendFunc();
            }
        }
        if (scaleMultiplier != 1.0f) {
            poseStack.popPose();
        }
    }

    public static boolean isHovering(double mouseX, double mouseY, float posX, float posY, int width, int height) {
        return mouseX > (double)posX && mouseX < (double)(posX + (float)width) && mouseY > (double)posY && mouseY < (double)(posY + (float)height);
    }

    public record TextColorData(Color primaryColor, Color secondaryColor, Color glowStart, Color glowEnd) {
    }

    public static enum BookTheme {
        DEFAULT,
        EASY_READING;

    }
}

