/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.recipe;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class SpiritRepairPage
extends BookPage {
    public static final Component BASE = Component.translatable((String)"malum.gui.book.entry.page.info.spirit_repair");
    public static final Component SPIRIT = Component.translatable((String)"malum.gui.book.entry.page.info.spirit_repair.spirit");
    public static final Component DAMAGED = Component.translatable((String)"malum.gui.book.entry.page.info.spirit_repair.damaged");
    private final SpiritRepairRecipe recipe;
    private final List<ItemStack> damagedStacks;
    private final List<ItemStack> repairedStacks;

    public SpiritRepairPage(Predicate<SpiritRepairRecipe> predicate) {
        this((SpiritRepairRecipe)LodestoneRecipeType.findRecipe((Level)Minecraft.getInstance().level, (RecipeType)((RecipeType)MalumRecipeTypes.SPIRIT_REPAIR.get()), predicate));
    }

    public SpiritRepairPage(SpiritRepairRecipe recipe) {
        super(MalumMod.malumPath("textures/gui/book/pages/spirit_repair_page.png"));
        this.recipe = recipe;
        this.damagedStacks = recipe.itemsForRepair.stream().map(Item::getDefaultInstance).peek(s -> s.setDamageValue(Mth.floor((float)((float)s.getMaxDamage() * recipe.durabilityPercentage)))).collect(Collectors.toList());
        this.repairedStacks = recipe.itemsForRepair.stream().map(Item::getDefaultInstance).map(recipe::getResultItem).collect(Collectors.toList());
    }

    @Override
    public boolean isValid() {
        return this.recipe != null;
    }

    public static SpiritRepairPage fromOutput(Item outputItem) {
        return new SpiritRepairPage(s -> s.repairResult.equals(outputItem));
    }

    public static SpiritRepairPage fromId(String recipeId) {
        return SpiritRepairPage.fromId(MalumMod.malumPath(recipeId));
    }

    public static SpiritRepairPage fromId(ResourceLocation recipeId) {
        ClientLevel level = Minecraft.getInstance().level;
        ResourceLocation other = recipeId.withPrefix("spirit_repair/");
        SpiritRepairRecipe recipe = LodestoneRecipeType.getRecipeHolders((Level)level, (RecipeType)((RecipeType)MalumRecipeTypes.SPIRIT_REPAIR.get())).stream().filter(r -> r.id().equals((Object)other)).findFirst().map(RecipeHolder::value).orElse(null);
        return new SpiritRepairPage(recipe);
    }

    @Override
    public void render(EntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        ArcanaCodexHelper.renderIngredients(screen, guiGraphics, this.recipe.spirits, SPIRIT, left + 59, top + 16, mouseX, mouseY, false);
        ArcanaCodexHelper.renderItem((AbstractMalumScreen)screen, guiGraphics, this.damagedStacks, left + 82, top + 59, mouseX, mouseY);
        ArcanaCodexHelper.renderIngredient((AbstractMalumScreen)screen, guiGraphics, this.recipe.repairMaterial, left + 44, top + 59, mouseX, mouseY);
        ArcanaCodexHelper.renderItem((AbstractMalumScreen)screen, guiGraphics, this.repairedStacks, left + 63, top + 126, mouseX, mouseY);
        screen.renderLater(() -> {
            if (screen.isHovering(mouseX, mouseY, left + 43, top + 78, 18, 18)) {
                guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, ArcanaCodexHelper.wrapComponent(BASE, 180), mouseX, mouseY);
            }
            if (screen.isHovering(mouseX, mouseY, left + 82, top + 78, 18, 18)) {
                guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, ArcanaCodexHelper.wrapComponent(DAMAGED, 180), mouseX, mouseY);
            }
        });
    }
}

