/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.recipe;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import com.sammy.malum.common.recipe.SpiritTransmutationRecipe;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class SpiritTransmutationRecipePage
extends BookPage {
    private static final Component BASE = Component.translatable((String)"malum.gui.book.entry.page.info.unchained_transmutation");
    private final String headlineTranslationKey;
    private final List<SpiritTransmutationRecipe> recipes;

    public SpiritTransmutationRecipePage(String headlineTranslationKey, Predicate<SpiritTransmutationRecipe> predicate) {
        super(MalumMod.malumPath("textures/gui/book/pages/transmutation_recipe_page.png"));
        this.headlineTranslationKey = headlineTranslationKey;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            this.recipes = new ArrayList<SpiritTransmutationRecipe>();
            SpiritTransmutationRecipe recipe = (SpiritTransmutationRecipe)LodestoneRecipeType.findRecipe((Level)level, (RecipeType)((RecipeType)MalumRecipeTypes.SPIRIT_TRANSMUTATION.get()), predicate);
            if (recipe != null) {
                this.recipes.add(recipe);
                if (recipe.group != null) {
                    for (SpiritTransmutationRecipe otherRecipe : LodestoneRecipeType.getRecipes((Level)level, (RecipeType)((RecipeType)MalumRecipeTypes.SPIRIT_TRANSMUTATION.get()))) {
                        if (((Object)((Object)recipe)).equals((Object)otherRecipe) || !recipe.group.equals(otherRecipe.group)) continue;
                        this.recipes.add(otherRecipe);
                    }
                }
            }
        } else {
            this.recipes = null;
        }
    }

    public String headlineTranslationKey() {
        return "malum.gui.book.entry.page.headline." + this.headlineTranslationKey;
    }

    public static SpiritTransmutationRecipePage fromInput(String headlineTranslationKey, Item inputItem) {
        return new SpiritTransmutationRecipePage(headlineTranslationKey, s -> s.ingredient.test(inputItem.getDefaultInstance()));
    }

    public static SpiritTransmutationRecipePage fromOutput(String headlineTranslationKey, Item outputItem) {
        return new SpiritTransmutationRecipePage(headlineTranslationKey, s -> s.output.is(outputItem));
    }

    @Override
    public boolean isValid() {
        return this.recipes != null;
    }

    @Override
    public void render(EntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        MutableComponent component = Component.translatable((String)this.headlineTranslationKey());
        ArcanaCodexHelper.renderText(guiGraphics, (Component)component, (float)(left + 70) - (float)Minecraft.getInstance().font.width(component.getString()) / 2.0f, top + 5);
        SpiritTransmutationRecipe recipe = this.recipes.get(this.getIndex());
        ArcanaCodexHelper.renderIngredient((AbstractMalumScreen)screen, guiGraphics, recipe.ingredient, left + 63, top + 56, mouseX, mouseY);
        ArcanaCodexHelper.renderItem((AbstractMalumScreen)screen, guiGraphics, recipe.output, left + 63, top + 132, mouseX, mouseY);
        screen.renderLater(() -> {
            if (screen.isHovering(mouseX, mouseY, left + 62, top + 78, 18, 18)) {
                guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, ArcanaCodexHelper.wrapComponent(BASE, 180), mouseX, mouseY);
            }
        });
    }

    public int getIndex() {
        return (int)(Minecraft.getInstance().level.getGameTime() % (20L * (long)this.recipes.size()) / 20L);
    }
}

