/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.redstone.wavebreaker;

import com.sammy.malum.common.block.curiosities.redstone.SpiritDiodeBlock;
import com.sammy.malum.common.block.curiosities.redstone.wavebreaker.WaveBreakerBlockEntity;
import com.sammy.malum.registry.common.MalumSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class WaveBreakerBlock
extends SpiritDiodeBlock<WaveBreakerBlockEntity> {
    public WaveBreakerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean processUpdate(Level level, BlockPos pos, BlockState state, WaveBreakerBlockEntity diode, int signal) {
        if (diode.outputSignal == diode.pendingSignal) {
            if (signal != diode.pendingSignal) {
                diode.pendingSignal = signal;
                return true;
            }
            return false;
        }
        diode.outputSignal = diode.pendingSignal;
        level.playSound(null, pos, diode.pendingSignal == 0 ? (SoundEvent)MalumSoundEvents.WAVEBREAKER_RELEASE.get() : (SoundEvent)MalumSoundEvents.WAVECHARGER_CHARGE.get(), SoundSource.BLOCKS, 0.3f, 2.0f);
        this.updateState(level, pos, state, diode);
        return signal != diode.outputSignal;
    }

    @Override
    public int redstoneTicksUntilUpdate(Level level, BlockPos pos, BlockState state, WaveBreakerBlockEntity diode, int newInput) {
        if (diode.pendingSignal != diode.outputSignal) {
            return super.redstoneTicksUntilUpdate(level, pos, state, diode, newInput);
        }
        return 2;
    }

    @Override
    public boolean shouldUpdateWhenNeighborChanged(Level level, BlockPos pos, BlockState state, WaveBreakerBlockEntity diode, int newInput) {
        return newInput != diode.pendingSignal;
    }
}

