/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.ritual_plinth;

import com.sammy.malum.common.block.curiosities.ritual_plinth.RitualPlinthBlockEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.sound.LodestoneBlockEntitySoundInstance;

public class RitualSoundInstance
extends LodestoneBlockEntitySoundInstance<RitualPlinthBlockEntity> {
    private static final Map<BlockPos, RitualSoundInstance> ACTIVE_SOUNDS = new HashMap<BlockPos, RitualSoundInstance>();
    public final Predicate<RitualPlinthBlockEntity> stopCondition;

    public RitualSoundInstance(RitualPlinthBlockEntity blockEntity, Supplier<SoundEvent> soundEvent, Predicate<RitualPlinthBlockEntity> stopCondition) {
        super((LodestoneBlockEntity)blockEntity, soundEvent.get(), 1.0f, 1.0f);
        this.x = (float)blockEntity.getBlockPos().getX() + 0.5f;
        this.y = (float)blockEntity.getBlockPos().getY() + 0.5f;
        this.z = (float)blockEntity.getBlockPos().getZ() + 0.5f;
        this.stopCondition = stopCondition;
    }

    public void tick() {
        if (((RitualPlinthBlockEntity)this.blockEntity).isRemoved() || this.stopCondition.test((RitualPlinthBlockEntity)this.blockEntity)) {
            this.stop();
            ACTIVE_SOUNDS.remove(((RitualPlinthBlockEntity)this.blockEntity).getBlockPos());
        }
        super.tick();
    }

    public static void playSound(RitualPlinthBlockEntity blockEntity, Supplier<SoundEvent> soundEvent, Predicate<RitualPlinthBlockEntity> stopCondition) {
        RitualSoundInstance ritualSound = new RitualSoundInstance(blockEntity, soundEvent, stopCondition);
        BlockPos blockPos = blockEntity.getBlockPos();
        if (ACTIVE_SOUNDS.containsKey(blockPos)) {
            RitualSoundInstance existingSound = ACTIVE_SOUNDS.get(blockPos);
            if (!existingSound.location.equals((Object)ritualSound.location)) {
                existingSound.stop();
                ACTIVE_SOUNDS.put(blockPos, ritualSound);
                Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)ritualSound);
            }
        } else {
            ACTIVE_SOUNDS.put(blockPos, ritualSound);
            Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)ritualSound);
        }
    }
}

