/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_catalyzer;

import com.sammy.malum.common.block.curiosities.spirit_catalyzer.SpiritCatalyzerCoreBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import team.lodestar.lodestone.systems.block.WaterLoggedEntityBlock;

public class SpiritCatalyzerCoreBlock<T extends SpiritCatalyzerCoreBlockEntity>
extends WaterLoggedEntityBlock<T> {
    public static final VoxelShape NORTH_SOUTH_SHAPE = SpiritCatalyzerCoreBlock.makeNorthSouthShape();
    public static final VoxelShape WEST_EAST_SHAPE = SpiritCatalyzerCoreBlock.makeWestEastShape();

    public SpiritCatalyzerCoreBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case NORTH: 
            case SOUTH: {
                return NORTH_SOUTH_SHAPE;
            }
            case EAST: 
            case WEST: {
                return WEST_EAST_SHAPE;
            }
        }
        return super.getShape(pState, pLevel, pPos, pContext);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        SpiritCatalyzerCoreBlockEntity catalyzer;
        IItemHandler inv;
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof SpiritCatalyzerCoreBlockEntity && (inv = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(pLevel, pPos, pState, (BlockEntity)(catalyzer = (SpiritCatalyzerCoreBlockEntity)blockEntity), null)) != null) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)inv);
        }
        return 0;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        super.createBlockStateDefinition(builder);
    }

    public static VoxelShape makeNorthSouthShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.3125, (double)0.1875, (double)0.75, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.625, (double)0.375, (double)0.3125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.0625, (double)0.625, (double)0.1875, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.3125, (double)0.3125, (double)0.25, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.3125, (double)0.3125, (double)0.9375, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.375, (double)0.375, (double)0.3125, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.375, (double)0.9375, (double)0.3125, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.8125, (double)0.625, (double)0.1875, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.1875, (double)0.625, (double)0.3125, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.625, (double)1.0, (double)0.3125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.375, (double)0.3125, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.0, (double)1.0, (double)0.3125, (double)0.375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeWestEastShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.3125, (double)0.25, (double)0.8125, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.625, (double)1.0, (double)0.3125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.375, (double)0.1875, (double)0.1875, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.3125, (double)0.75, (double)0.6875, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.3125, (double)0.0625, (double)0.6875, (double)1.0, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.625, (double)0.625, (double)0.3125, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.0625, (double)0.625, (double)0.3125, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.375, (double)0.9375, (double)0.1875, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.375, (double)0.8125, (double)0.3125, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.0, (double)1.0, (double)0.3125, (double)0.375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.625, (double)0.375, (double)0.3125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.375, (double)0.3125, (double)0.375), (BooleanOp)BooleanOp.OR);
        return shape;
    }
}

