/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_crucible;

import com.sammy.malum.common.block.AugmentBlockEntityInventory;
import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.MalumSpiritBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleSoundInstance;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.data.component.ArtificeAugmentDataComponent;
import com.sammy.malum.common.data.map.ImpetusDataMap;
import com.sammy.malum.common.item.augment.MendingDiffuserItem;
import com.sammy.malum.common.item.augment.ShieldingApparatusItem;
import com.sammy.malum.common.item.augment.WarpingEngineItem;
import com.sammy.malum.common.item.augment.core.SuspiciousDeviceItem;
import com.sammy.malum.common.item.augment.core.SympathyDrive;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.packets.CodecUtil;
import com.sammy.malum.common.recipe.SpiritFocusingRecipe;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeData;
import com.sammy.malum.core.systems.artifice.ArtificeModifierSourceInstance;
import com.sammy.malum.core.systems.artifice.IArtificeAcceptor;
import com.sammy.malum.core.systems.recipe.SpiritBasedRecipeInput;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumDataMaps;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import com.sammy.malum.visual_effects.SpiritCrucibleParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.IItemHandlerSupplier;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.multiblock.MultiBlockCoreEntity;
import team.lodestar.lodestone.systems.multiblock.MultiBlockStructure;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class SpiritCrucibleCoreBlockEntity
extends MultiBlockCoreEntity
implements IArtificeAcceptor,
IMalumSpecialItemAccessPoint,
IItemHandlerSupplier {
    public static final Vec3 CRUCIBLE_ITEM_OFFSET = new Vec3(0.0, (double)1.1f, 0.0);
    public static final Vec3 CRUCIBLE_CORE_AUGMENT_OFFSET = new Vec3(0.0, 2.5, 0.0);
    public static final Supplier<MultiBlockStructure> STRUCTURE = () -> MultiBlockStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((Block)MalumBlocks.SPIRIT_CRUCIBLE_COMPONENT.get()).defaultBlockState())});
    public LodestoneBlockEntityInventory inventory;
    public LodestoneBlockEntityInventory spiritInventory;
    public LodestoneBlockEntityInventory augmentInventory;
    public LodestoneBlockEntityInventory coreAugmentInventory;
    public SpiritFocusingRecipe recipe;
    public float spiritAmount;
    public float spiritSpin;
    public float progress;
    public int queuedCracks;
    public int crackTimer;
    public ArtificeAttributeData attributes = new ArtificeAttributeData();
    private final Supplier<IItemHandler> exposedInventory = () -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.spiritInventory});

    public SpiritCrucibleCoreBlockEntity(BlockEntityType<? extends SpiritCrucibleCoreBlockEntity> type, MultiBlockStructure structure, BlockPos pos, BlockState state) {
        super(type, structure, pos, state);
        this.inventory = MalumBlockEntityInventory.singleNotSpirit((LodestoneBlockEntity)this).onContentsChanged(this::updateRecipe);
        this.spiritInventory = MalumSpiritBlockEntityInventory.spiritStacks((LodestoneBlockEntity)this, 4).onContentsChanged(this::updateRecipe);
        this.augmentInventory = AugmentBlockEntityInventory.augmentInventory((LodestoneBlockEntity)this, 4).onContentsChanged(() -> this.recalibrateAccelerators(this.level));
        this.coreAugmentInventory = AugmentBlockEntityInventory.coreAugmentInventory((LodestoneBlockEntity)this, 1).onContentsChanged(() -> this.recalibrateAccelerators(this.level));
    }

    public SpiritCrucibleCoreBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends SpiritCrucibleCoreBlockEntity>)((BlockEntityType)MalumBlockEntities.SPIRIT_CRUCIBLE.get()), STRUCTURE.get(), pos, state);
    }

    public IItemHandler getInventory(Direction direction) {
        return this.exposedInventory.get();
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        if (this.spiritAmount != 0.0f) {
            compound.putFloat("spiritAmount", this.spiritAmount);
        }
        if (this.progress != 0.0f) {
            compound.putFloat("progress", this.progress);
        }
        if (this.queuedCracks != 0) {
            compound.putInt("queuedCracks", this.queuedCracks);
        }
        compound.put("attributeData", CodecUtil.encodeNBT(ArtificeAttributeData.CODEC, this.attributes));
        this.inventory.save(pRegistries, compound);
        this.spiritInventory.save(pRegistries, compound, "spiritInventory");
        this.augmentInventory.save(pRegistries, compound, "augmentInventory");
        this.coreAugmentInventory.save(pRegistries, compound, "coreAugmentInventory");
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.spiritAmount = compound.getFloat("spiritAmount");
        this.progress = compound.getFloat("progress");
        this.queuedCracks = compound.getInt("queuedCracks");
        this.attributes = CodecUtil.decodeNBT(ArtificeAttributeData.CODEC, (Tag)compound.getCompound("attributeData"));
        this.inventory.load(pRegistries, compound);
        this.spiritInventory.load(pRegistries, compound, "spiritInventory");
        this.augmentInventory.load(pRegistries, compound, "augmentInventory");
        this.coreAugmentInventory.load(pRegistries, compound, "coreAugmentInventory");
        this.loadWithLevel(level -> {
            if (level.isClientSide && this.recipe != null) {
                CrucibleSoundInstance.playSound(this);
            }
            this.updateRecipe();
        });
        super.loadAdditional(compound, pRegistries);
    }

    public void onBreak(@Nullable Player player) {
        this.inventory.dumpItems(this.level, this.worldPosition);
        this.spiritInventory.dumpItems(this.level, this.worldPosition);
        this.augmentInventory.dumpItems(this.level, this.worldPosition);
        this.coreAugmentInventory.dumpItems(this.level, this.worldPosition);
        if (!this.level.isClientSide) {
            this.invalidateModifiers(this.level);
        }
        super.onBreak(player);
    }

    public ItemInteractionResult onUseWithItem(Player pPlayer, ItemStack pStack, InteractionHand pHand) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return ItemInteractionResult.CONSUME;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (pStack.is(MalumTags.ItemTags.IS_ARTIFICE_TOOL)) {
            this.attributes.applyTuningForkBuff(serverLevel, this.worldPosition);
            return ItemInteractionResult.SUCCESS;
        }
        return super.onUseWithItem(pPlayer, pStack, pHand);
    }

    public ItemInteractionResult onUse(Player pPlayer, InteractionHand pHand) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return ItemInteractionResult.CONSUME;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack heldStack = pPlayer.getItemInHand(pHand);
        boolean isAugment = heldStack.has(MalumDataComponents.ARTIFICE_AUGMENT);
        if (!isAugment || heldStack.isEmpty()) {
            ItemStack spiritResult = this.spiritInventory.interact(serverLevel, pPlayer, pHand);
            if (!spiritResult.isEmpty()) {
                return ItemInteractionResult.SUCCESS;
            }
            ItemStack impetusResult = this.inventory.interact(serverLevel, pPlayer, pHand);
            if (!impetusResult.isEmpty()) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        if (isAugment || heldStack.isEmpty()) {
            ItemStack augment;
            if (!(!heldStack.isEmpty() && ((ArtificeAugmentDataComponent)heldStack.get(MalumDataComponents.ARTIFICE_AUGMENT)).isCoreAugment() || (augment = this.augmentInventory.interact(serverLevel, pPlayer, pHand)).isEmpty())) {
                return ItemInteractionResult.SUCCESS;
            }
            ItemStack coreAugment = this.coreAugmentInventory.interact(serverLevel, pPlayer, pHand);
            if (!coreAugment.isEmpty()) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.FAIL;
    }

    public void tick() {
        this.spiritAmount = Math.max(1.0f, Mth.lerp((float)0.1f, (float)this.spiritAmount, (float)this.spiritInventory.getFilledSlotCount()));
        float speed = this.attributes.focusingSpeed.getValue(this.attributes);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.queuedCracks > 0) {
                ++this.crackTimer;
                if (this.crackTimer % 5 == 0) {
                    if (this.crackTimer >= 15) {
                        this.crackTimer = 0;
                    }
                    float pitch = RandomHelper.randomBetween((RandomSource)this.level.getRandom(), (float)0.9f, (float)1.1f) * (0.95f + (float)(this.crackTimer - 8) * 0.015f);
                    this.level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.IMPETUS_CRACK.get(), SoundSource.BLOCKS, 0.7f, pitch);
                    --this.queuedCracks;
                    if (this.queuedCracks == 0) {
                        this.crackTimer = 0;
                    }
                }
            }
            if (this.recipe != null) {
                this.attributes.getInfluenceData(this.level).ifPresent(d -> {
                    for (ArtificeModifierSourceInstance modifier : d.modifiers()) {
                        modifier.tickFocusing(this.attributes);
                        if (modifier.canModifyFocusing(this.attributes)) continue;
                        this.recalibrateAccelerators(this.level);
                    }
                });
                this.progress += speed;
                if (this.progress >= (float)this.recipe.time) {
                    this.craft(serverLevel);
                }
            } else if (this.progress != 0.0f) {
                this.progress = 0.0f;
                this.invalidateModifiers(this.level);
            }
        } else {
            this.spiritSpin += 1.0f + speed * 0.1f;
            SpiritCrucibleParticleEffects.passiveCrucibleParticles(this);
        }
    }

    public void craft(ServerLevel level) {
        boolean skippedForward;
        ItemStack impetus = this.inventory.getStackInSlot(0);
        ItemStack outputStack = this.recipe.output.copy();
        Vec3 itemPos = this.getItemPos();
        RandomSource random = level.random;
        float speed = this.attributes.focusingSpeed.getValue(this.attributes);
        float instability = this.attributes.instability.getValue(this.attributes);
        float fortuneChance = this.attributes.fortuneChance.getValue(this.attributes);
        int durabilityCost = 0;
        if (!ShieldingApparatusItem.shieldImpetus((Level)level, this.worldPosition, this.attributes) && this.recipe.durabilityCost != 0 && impetus.isDamageableItem()) {
            durabilityCost = this.recipe.durabilityCost;
            if (instability > 0.0f && random.nextFloat() < instability) {
                durabilityCost *= 2;
                if (instability > 1.0f) {
                    durabilityCost = Math.round((float)durabilityCost * instability);
                }
            }
            this.queuedCracks += durabilityCost;
        }
        block0: for (SpiritIngredient spirit : this.recipe.spirits) {
            for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                ItemStack spiritStack = this.spiritInventory.getStackInSlot(i);
                if (!spirit.test(spiritStack)) continue;
                spiritStack.shrink(spirit.getCount());
                continue block0;
            }
        }
        if (this.coreAugmentInventory.getStackInSlot(0).getItem() instanceof SuspiciousDeviceItem) {
            SuspiciousDeviceItem.blowUp(level, this.getBlockPos());
        }
        if (skippedForward = WarpingEngineItem.skipForward((Level)level, this.worldPosition, this.attributes)) {
            this.progress = (float)this.recipe.time - 10.0f * speed;
        } else {
            SympathyDrive.completeCycle(this.attributes, durabilityCost);
            this.progress = 0.0f;
        }
        MalumParticleEffectTypes.SPIRIT_CRUCIBLE_CRAFTS.createEffect(this.worldPosition).color(MalumNetworkedParticleEffectColorData.fromSpiritIngredients(this.recipe.spirits)).spawn(level);
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.CRUCIBLE_CRAFT.get(), SoundSource.BLOCKS, 1.0f, 0.75f + random.nextFloat() * 0.5f);
        level.addFreshEntity((Entity)new ItemEntity((Level)level, itemPos.x, itemPos.y, itemPos.z, outputStack));
        while (fortuneChance > 0.0f) {
            if (fortuneChance >= 1.0f || random.nextFloat() < fortuneChance) {
                level.addFreshEntity((Entity)new ItemEntity((Level)level, itemPos.x, itemPos.y, itemPos.z, outputStack.copy()));
            }
            fortuneChance -= 1.0f;
        }
        if (durabilityCost > 0) {
            impetus.hurtAndBreak(durabilityCost, level, null, brokenStack -> {
                Holder itemHolder = ((Registry)level.registryAccess().registry(Registries.ITEM).orElseThrow()).wrapAsHolder((Object)brokenStack.asItem());
                ImpetusDataMap data = (ImpetusDataMap)itemHolder.getData(MalumDataMaps.FRACTURED_IMPETUS_VARIANT);
                if (data != null) {
                    this.inventory.setStackInSlot(0, ((Item)data.fracturedImpetus().value()).getDefaultInstance());
                }
            });
            if (MendingDiffuserItem.repairImpetus((Level)level, this.attributes, impetus)) {
                SympathyDrive.repairImpetus((Level)level, this.attributes, impetus);
            }
        }
        this.updateRecipe();
        BlockStateHelper.updateAndNotifyState((Level)level, (BlockPos)this.worldPosition);
    }

    @Override
    public Vec3 getVisualAccelerationPoint() {
        return this.getItemPos();
    }

    @Override
    public ArtificeAttributeData getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(ArtificeAttributeData attributes) {
        this.attributes = attributes;
    }

    @Override
    public MalumSpiritType getActiveSpiritType() {
        int spiritCount = this.spiritInventory.getFilledSlotCount();
        Item currentItem = this.spiritInventory.getStackInSlot(0).getItem();
        if (spiritCount > 1) {
            float duration = 60.0f * (float)spiritCount;
            float gameTime = (float)this.getLevel().getGameTime() % duration / 60.0f;
            currentItem = this.spiritInventory.getStackInSlot(Mth.floor((float)gameTime)).getItem();
        }
        if (!(currentItem instanceof SpiritShardItem)) {
            return null;
        }
        SpiritShardItem spiritItem = (SpiritShardItem)currentItem;
        return spiritItem.type;
    }

    @Override
    public void applyAugments(Consumer<ItemStack> augmentConsumer) {
        this.augmentInventory.getNonEmptyStacks().forEach(augmentConsumer);
        this.coreAugmentInventory.getNonEmptyStacks().forEach(augmentConsumer);
    }

    @Override
    public Vec3 getItemPos(float partialTicks) {
        return this.getBlockPos().getCenter().add(CRUCIBLE_ITEM_OFFSET);
    }

    @Override
    public BlockPos getAccessPointBlockPos() {
        return this.getBlockPos();
    }

    @Override
    public LodestoneBlockEntityInventory getSuppliedInventory() {
        return this.inventory;
    }

    public void updateRecipe() {
        this.spiritInventory.updateInventoryCaches();
        this.recipe = (SpiritFocusingRecipe)LodestoneRecipeType.getRecipe((Level)this.level, (RecipeType)((RecipeType)MalumRecipeTypes.SPIRIT_FOCUSING.get()), (RecipeInput)new SpiritBasedRecipeInput(this.inventory.getStackInSlot(0), (List<ItemStack>)this.spiritInventory.nonEmptyItemStacks));
    }

    public Vec3 getSpiritItemOffset(int slot, float partialTicks) {
        float predictedSpiritSpin = this.spiritSpin + 1.0f + this.attributes.focusingSpeed.getValue(this.attributes) * 0.1f;
        float spinLerp = this.spiritSpin + partialTicks * (predictedSpiritSpin - this.spiritSpin);
        float distance = 0.75f + (float)Math.sin((spinLerp + partialTicks) / 20.0f % 6.28f) * 0.025f;
        float height = 1.8f;
        return VecHelper.rotatingRadialOffset((Vec3)new Vec3(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)this.spiritAmount, (float)spinLerp, (float)360.0f);
    }

    public Vec3 getAugmentItemOffset(int slot, float partialTicks) {
        float predictedSpiritSpin = this.spiritSpin + 1.0f + this.attributes.focusingSpeed.getValue(this.attributes) * 0.1f;
        float spinLerp = this.spiritSpin + partialTicks * (predictedSpiritSpin - this.spiritSpin);
        float distance = 0.6f + (float)Math.sin((this.spiritSpin + partialTicks) / 20.0f % 6.28f) * 0.025f;
        float height = 1.6f;
        return VecHelper.rotatingRadialOffset((Vec3)new Vec3(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)this.augmentInventory.slotCount, (float)spinLerp, (float)240.0f);
    }
}

