/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritRiteTypes;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import team.lodestar.lodestone.helpers.block.BlockEntityHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class TotemBaseBlockEntity
extends LodestoneBlockEntity {
    public static final StringRepresentable.EnumCodec<TotemRiteState> CODEC = StringRepresentable.fromEnum(TotemRiteState::values);
    public final boolean isSoulwood;
    public TotemRiteState state = TotemRiteState.IDLE;
    public TotemicRiteType activeRite;
    private final List<BlockPos> totemPolePositions = new ArrayList<BlockPos>();
    private Direction direction;
    public int timer;
    public TotemicRiteType cachedRadiusRite;
    public int radiusVisibility;

    public TotemBaseBlockEntity(BlockEntityType<? extends TotemBaseBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.isSoulwood = ((TotemBaseBlock)state.getBlock()).corrupted;
    }

    public TotemBaseBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends TotemBaseBlockEntity>)((BlockEntityType)MalumBlockEntities.TOTEM_BASE.get()), pos, state);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        compound.putString("state", this.state.name);
        if (this.activeRite != null) {
            compound.putString("rite", this.activeRite.identifier);
        }
        if (this.direction != null) {
            compound.putString("direction", this.direction.getName());
        }
        compound.putInt("height", this.totemPolePositions.size());
        compound.putInt("timer", this.timer);
        super.saveAdditional(compound, registries);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.state = compound.contains("state") ? (TotemRiteState)CODEC.byName(compound.getString("state")) : TotemRiteState.IDLE;
        this.activeRite = MalumSpiritRiteTypes.getRite(compound.getString("rite"));
        this.direction = Direction.byName((String)compound.getString("direction"));
        this.totemPolePositions.clear();
        for (int i = 1; i <= compound.getInt("height"); ++i) {
            this.totemPolePositions.add(this.worldPosition.above(i));
        }
        this.timer = compound.getInt("timer");
        super.loadAdditional(compound, pRegistries);
    }

    public void tick() {
        super.tick();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            switch (this.state.ordinal()) {
                case 2: {
                    ++this.timer;
                    if (this.timer < this.activeRite.getRiteEffect(this.isSoulwood).getRiteEffectTickRate()) break;
                    this.activeRite.executeRite(this);
                    this.timer = 0;
                    BlockStateHelper.updateAndNotifyState((Level)serverLevel, (BlockPos)this.worldPosition);
                    break;
                }
                case 1: {
                    --this.timer;
                    if (this.timer > 0) break;
                    BlockPos polePos = this.worldPosition.above(this.totemPolePositions.size() + 1);
                    BlockEntity blockEntity = serverLevel.getBlockEntity(polePos);
                    if (blockEntity instanceof TotemPoleBlockEntity) {
                        TotemPoleBlockEntity pole = (TotemPoleBlockEntity)blockEntity;
                        this.timer = 20;
                        this.addTotemPole(serverLevel, pole);
                        break;
                    }
                    TotemicRiteType rite = MalumSpiritRiteTypes.getRite(this.getSpirits());
                    if (rite == null) {
                        this.setState(TotemRiteState.IDLE);
                        break;
                    }
                    this.activeRite = rite;
                    this.modifyTotemPoles(TotemPoleBlockEntity.TotemPoleState.ACTIVE);
                    rite.executeRite(this);
                    if (rite.getRiteEffect((boolean)this.isSoulwood).category.equals((Object)TotemicRiteEffect.MalumRiteEffectCategory.ONE_TIME_EFFECT)) {
                        this.setState(TotemRiteState.IDLE);
                        break;
                    }
                    this.setState(TotemRiteState.ACTIVE);
                    this.deactivateOtherRites();
                }
            }
        } else if (this.state.equals((Object)TotemRiteState.IDLE) && this.radiusVisibility > 0) {
            --this.radiusVisibility;
            if (this.radiusVisibility == 0) {
                this.cachedRadiusRite = null;
            }
        } else if (this.state.equals((Object)TotemRiteState.ACTIVE) && this.radiusVisibility < 40) {
            if (this.activeRite != null && this.cachedRadiusRite == null) {
                this.cachedRadiusRite = this.activeRite;
            }
            ++this.radiusVisibility;
        }
    }

    public ItemInteractionResult onUseWithItem(Player player, ItemStack pStack, InteractionHand pHand) {
        if (this.state.equals((Object)TotemRiteState.ASSEMBLING)) {
            return ItemInteractionResult.FAIL;
        }
        if (this.level.getBlockEntity(this.worldPosition.above()) instanceof TotemPoleBlockEntity) {
            if (!this.level.isClientSide) {
                if (this.state.equals((Object)TotemRiteState.ACTIVE)) {
                    this.setState(TotemRiteState.IDLE);
                } else {
                    this.setState(TotemRiteState.ASSEMBLING);
                }
                BlockStateHelper.updateState((Level)this.level, (BlockPos)this.worldPosition);
            }
            player.swing(InteractionHand.MAIN_HAND, true);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onBreak(@Nullable Player player) {
        if (!this.level.isClientSide) {
            this.setState(TotemRiteState.IDLE);
        }
    }

    public void addTotemPole(ServerLevel level, TotemPoleBlockEntity pole) {
        Direction direction = (Direction)pole.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (this.totemPolePositions.isEmpty()) {
            this.direction = direction;
        }
        if (pole.isSoulwood == this.isSoulwood && direction.equals((Object)this.direction) && pole.spirit != null) {
            this.totemPolePositions.add(pole.getBlockPos());
            pole.riteStarting(level, this, this.totemPolePositions.size());
        }
        BlockStateHelper.updateState((Level)level, (BlockPos)this.worldPosition);
    }

    public void deactivateOtherRites() {
        TotemicRiteEffect riteEffect = this.activeRite.getRiteEffect(this.isSoulwood);
        int horizontalRadius = riteEffect.getRiteEffectHorizontalRadius();
        int verticalRadius = riteEffect.getRiteEffectVerticalRadius();
        Collection deactivatedTotems = BlockEntityHelper.getBlockEntities(TotemBaseBlockEntity.class, (Level)this.level, (BlockPos)riteEffect.getRiteEffectCenter(this), (int)horizontalRadius, (int)verticalRadius, (int)horizontalRadius);
        for (TotemBaseBlockEntity deactivatedTotem : deactivatedTotems) {
            if (((Object)((Object)deactivatedTotem)).equals((Object)this) || !deactivatedTotem.isActiveOrAssembling() || deactivatedTotem.activeRite == null || !deactivatedTotem.activeRite.equals(this.activeRite)) continue;
            deactivatedTotem.setState(TotemRiteState.IDLE);
        }
        Collection otherTotems = BlockEntityHelper.getBlockEntities(TotemBaseBlockEntity.class, (Level)this.level, (BlockPos)this.worldPosition, (int)24);
        for (TotemBaseBlockEntity otherTotem : otherTotems) {
            if (((Object)((Object)otherTotem)).equals((Object)this) || otherTotem.activeRite == null || !otherTotem.activeRite.equals(this.activeRite)) continue;
            riteEffect = this.activeRite.getRiteEffect(this.isSoulwood);
            horizontalRadius = riteEffect.getRiteEffectHorizontalRadius();
            verticalRadius = riteEffect.getRiteEffectVerticalRadius();
            if (!BlockEntityHelper.getBlockEntities(TotemBaseBlockEntity.class, (Level)this.level, (BlockPos)riteEffect.getRiteEffectCenter(otherTotem), (int)horizontalRadius, (int)verticalRadius, (int)horizontalRadius).contains((Object)this)) continue;
            otherTotem.setState(TotemRiteState.IDLE);
        }
    }

    public void setState(TotemRiteState state) {
        if (state.equals((Object)TotemRiteState.ACTIVE)) {
            this.level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.TOTEM_ACTIVATED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (state.equals((Object)TotemRiteState.IDLE)) {
            if (this.isActiveOrAssembling()) {
                this.level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.TOTEM_CANCELLED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.modifyTotemPoles(TotemPoleBlockEntity.TotemPoleState.INACTIVE);
            this.totemPolePositions.clear();
            this.activeRite = null;
            this.direction = null;
        }
        this.state = state;
        this.timer = 0;
        BlockStateHelper.updateAndNotifyState((Level)this.level, (BlockPos)this.worldPosition);
    }

    public void modifyTotemPoles(TotemPoleBlockEntity.TotemPoleState state) {
        for (TotemPoleBlockEntity totemPole : this.getTotemPoles()) {
            totemPole.setState(state);
        }
    }

    public List<TotemPoleBlockEntity> getTotemPoles() {
        ArrayList<TotemPoleBlockEntity> totemPoles = new ArrayList<TotemPoleBlockEntity>();
        for (BlockPos totemPolePosition : this.totemPolePositions) {
            BlockEntity blockEntity = this.level.getBlockEntity(totemPolePosition);
            if (!(blockEntity instanceof TotemPoleBlockEntity)) continue;
            TotemPoleBlockEntity totemPole = (TotemPoleBlockEntity)blockEntity;
            totemPoles.add(totemPole);
        }
        return totemPoles;
    }

    public List<MalumSpiritType> getSpirits() {
        return this.getTotemPoles().stream().map(t -> t.spirit).toList();
    }

    public Direction getDirection() {
        BlockState state;
        if (this.direction == null && (state = this.level.getBlockState(this.worldPosition.above())).getBlock() instanceof TotemPoleBlock) {
            this.direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        }
        return this.direction;
    }

    public boolean isActiveOrAssembling() {
        return !this.state.equals((Object)TotemRiteState.IDLE);
    }

    public static enum TotemRiteState implements StringRepresentable
    {
        IDLE("idle"),
        ASSEMBLING("assembling"),
        ACTIVE("active");

        final String name;

        private TotemRiteState(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

