/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem;

import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.core.systems.spirit.SpiritTypeProperty;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.systems.block.LodestoneEntityBlock;

public class TotemPoleBlock<T extends TotemPoleBlockEntity>
extends LodestoneEntityBlock<T> {
    public static final SpiritTypeProperty SPIRIT_TYPE = MalumSpiritTypes.SPIRIT_TYPE_PROPERTY;
    public final Supplier<? extends Block> logBlock;
    public final boolean isSoulwood;

    public TotemPoleBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> logBlock, boolean isSoulwood) {
        super(properties.lootFrom(logBlock));
        this.logBlock = logBlock;
        this.isSoulwood = isSoulwood;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)SPIRIT_TYPE, (Comparable)((Object)"sacred")));
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof TotemPoleBlockEntity) {
            TotemPoleBlockEntity pole = (TotemPoleBlockEntity)be;
            return Math.min(MalumSpiritTypes.getIndexForSpiritType(pole.spirit) + 1, 15);
        }
        return 0;
    }

    @NotNull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        return this.logBlock.get().getCloneItemStack(world, pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, SPIRIT_TYPE});
    }
}

