/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.totem;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlock;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.visual_effects.TotemParticleEffects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class TotemPoleBlockEntity
extends LodestoneBlockEntity {
    public MalumSpiritType spirit;
    public TotemPoleState totemPoleState = TotemPoleState.INACTIVE;
    public TotemBaseBlockEntity totemBase;
    public int totemBaseYLevel;
    public int chargeProgress;
    public final boolean isSoulwood;
    public final Block logBlock;
    public final Direction direction;

    public TotemPoleBlockEntity(BlockEntityType<? extends TotemPoleBlockEntity> spirit, BlockPos pos, BlockState state) {
        super(spirit, pos, state);
        this.isSoulwood = ((TotemPoleBlock)state.getBlock()).isSoulwood;
        this.logBlock = ((TotemPoleBlock)state.getBlock()).logBlock.get();
        this.direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    public TotemPoleBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends TotemPoleBlockEntity>)((BlockEntityType)MalumBlockEntities.TOTEM_POLE.get()), pos, state);
    }

    public ItemInteractionResult onUseWithItem(Player player, ItemStack held, InteractionHand hand) {
        boolean success = false;
        if (held.is(MalumTags.ItemTags.IS_TOTEMIC_TOOL) && !this.totemPoleState.equals((Object)TotemPoleState.ACTIVE) && !this.totemPoleState.equals((Object)TotemPoleState.CHARGING)) {
            if (this.level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            this.totemPoleState = this.totemPoleState.equals((Object)TotemPoleState.INACTIVE) ? TotemPoleState.VISUAL_ONLY : TotemPoleState.INACTIVE;
            success = true;
        } else if (held.canPerformAction(ItemAbilities.AXE_STRIP)) {
            if (this.level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            if (this.spirit != null) {
                this.level.setBlockAndUpdate(this.worldPosition, this.logBlock.defaultBlockState());
                success = true;
                this.onBreak(player);
            }
        }
        if (success) {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.spirit != null) {
                    MalumParticleEffectTypes.TOTEM_POLE_ACTIVATED.createEffect().at(this.worldPosition).color(this.spirit).spawn(serverLevel);
                }
            }
            float pitch = this.totemPoleState == TotemPoleState.VISUAL_ONLY ? 1.2f : 0.7f;
            this.level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.TOTEM_ENGRAVE.get(), SoundSource.BLOCKS, 1.0f, pitch + Mth.nextFloat((RandomSource)this.level.random, (float)-0.2f, (float)0.2f));
            if (this.isSoulwood) {
                this.level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.MAJOR_BLIGHT_MOTIF.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            BlockStateHelper.updateState((Level)this.level, (BlockPos)this.worldPosition);
            return ItemInteractionResult.SUCCESS;
        }
        return super.onUseWithItem(player, held, hand);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.spirit != null) {
            tag.putString("spirit", this.spirit.getIdentifier());
        }
        if (!this.totemPoleState.equals((Object)TotemPoleState.INACTIVE)) {
            tag.putInt("state", this.totemPoleState.ordinal());
        }
        if (this.chargeProgress != 0) {
            tag.putInt("chargeProgress", this.chargeProgress);
        }
        if (this.totemBaseYLevel != 0) {
            tag.putInt("totemBaseYLevel", this.totemBaseYLevel);
        }
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (tag.contains("spirit")) {
            this.spirit = MalumSpiritType.getSpiritType(tag.getString("spirit"));
        }
        this.totemPoleState = tag.contains("state") ? TotemPoleState.values()[tag.getInt("state")] : TotemPoleState.INACTIVE;
        this.chargeProgress = tag.getInt("chargeProgress");
        this.totemBaseYLevel = tag.getInt("totemBaseYLevel");
        super.loadAdditional(tag, pRegistries);
    }

    public void update(@NotNull Level level) {
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)this.getBlockPos().mutable().setY(this.totemBaseYLevel));
        if (blockEntity instanceof TotemBaseBlockEntity) {
            TotemBaseBlockEntity totemBaseBlockEntity;
            this.totemBase = totemBaseBlockEntity = (TotemBaseBlockEntity)blockEntity;
        }
    }

    public void tick() {
        super.tick();
        if (this.totemPoleState.equals((Object)TotemPoleState.INACTIVE)) {
            this.chargeProgress = this.chargeProgress > 0 ? this.chargeProgress - 1 : 0;
        } else {
            int cap = this.totemPoleState.equals((Object)TotemPoleState.CHARGING) ? 10 : 20;
            int n = this.chargeProgress = this.chargeProgress < cap ? this.chargeProgress + 1 : cap;
        }
        if (this.level.isClientSide && this.spirit != null && this.totemPoleState.equals((Object)TotemPoleState.ACTIVE)) {
            TotemParticleEffects.activeTotemPoleParticles(this);
        }
    }

    public void setSpirit(ServerLevel level, MalumSpiritType spirit) {
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.TOTEM_ENGRAVE.get(), SoundSource.BLOCKS, 1.0f, Mth.nextFloat((RandomSource)level.random, (float)0.9f, (float)1.1f));
        level.playSound(null, this.worldPosition, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, Mth.nextFloat((RandomSource)level.random, (float)0.9f, (float)1.1f));
        this.spirit = spirit;
        this.chargeProgress = 10;
        MalumParticleEffectTypes.TOTEM_POLE_ACTIVATED.createEffect().at(this.worldPosition).color(spirit).spawn(level);
        BlockStateHelper.updateState((Level)level, (BlockPos)this.worldPosition);
    }

    public void riteStarting(ServerLevel level, TotemBaseBlockEntity totemBase, int height) {
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.TOTEM_CHARGE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.2f * (float)height);
        this.totemBaseYLevel = this.worldPosition.getY() - height;
        this.totemBase = totemBase;
        this.totemPoleState = TotemPoleState.CHARGING;
        MalumParticleEffectTypes.TOTEM_POLE_ACTIVATED.createEffect().at(this.worldPosition).color(this.spirit).spawn(level);
        BlockStateHelper.updateState((Level)level, (BlockPos)this.worldPosition);
    }

    public void setState(TotemPoleState state) {
        this.totemPoleState = state;
        BlockStateHelper.updateState((Level)this.level, (BlockPos)this.worldPosition);
    }

    public void onBreak(@Nullable Player player) {
        TotemBaseBlockEntity base;
        if (this.level.isClientSide) {
            return;
        }
        BlockEntity blockEntity = this.level.getBlockEntity((BlockPos)this.getBlockPos().mutable().setY(this.totemBaseYLevel));
        if (blockEntity instanceof TotemBaseBlockEntity && (base = (TotemBaseBlockEntity)blockEntity).isActiveOrAssembling()) {
            base.onBreak(player);
        }
    }

    public static enum TotemPoleState {
        INACTIVE,
        VISUAL_ONLY,
        CHARGING,
        ACTIVE;

    }
}

