/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.weavers_workbench;

import com.sammy.malum.common.block.curiosities.weavers_workbench.WeaversWorkbenchItemHandler;
import com.sammy.malum.common.container.WeaversWorkbenchContainer;
import com.sammy.malum.common.data.component.ItemSkinComponent;
import com.sammy.malum.common.packets.particle.rite.BlightTransformItemParticlePacket;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.helpers.block.BlockPosHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class WeaversWorkbenchBlockEntity
extends LodestoneBlockEntity
implements IBlockCapabilityProvider<IItemHandler, Direction> {
    public final WeaversWorkbenchItemHandler itemHandler = new WeaversWorkbenchItemHandler(2, 1, this);

    public WeaversWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MalumBlockEntities.WEAVERS_WORKBENCH.get(), pos, state);
    }

    public ItemInteractionResult onUse(Player player, InteractionHand pHand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SimpleMenuProvider container = new SimpleMenuProvider((w, p, pl) -> new WeaversWorkbenchContainer(w, p, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.getBlockPos())), WeaversWorkbenchContainer.component);
            serverPlayer.openMenu((MenuProvider)container, buf -> buf.writeBlockPos(this.getBlockPos()));
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public IItemHandler getCapability(Level level, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, Direction direction) {
        return this.itemHandler;
    }

    public void onCraft() {
        if (!this.level.isClientSide) {
            Vec3 itemPos = this.getItemPos();
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new BlightTransformItemParticlePacket(List.of(MalumSpiritTypes.ARCANE_SPIRIT.getIdentifier()), itemPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)MalumSoundEvents.WEAVERS_WORKBENCH_CRAFT.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.level.random.nextFloat() * 0.25f);
        }
        this.itemHandler.getStackInSlot(0).shrink(1);
        this.itemHandler.getStackInSlot(1).shrink(1);
    }

    public ItemStack tryCraft() {
        this.itemHandler.isCrafting = true;
        ItemStack output = this.getOutput();
        this.itemHandler.setStackInSlot(2, output);
        this.itemHandler.isCrafting = false;
        return output;
    }

    public ItemStack getOutput() {
        ItemStack target = this.itemHandler.getStackInSlot(0);
        ItemStack weave = this.itemHandler.getStackInSlot(1);
        if (!target.isEmpty() && weave.isEmpty() && target.has(MalumDataComponents.APPLIED_ITEM_SKIN)) {
            ItemStack result = target.copy();
            result.remove(MalumDataComponents.APPLIED_ITEM_SKIN);
            return result;
        }
        if (!target.isEmpty() && !weave.isEmpty()) {
            ItemStack result = target.copy();
            if (weave.has(MalumDataComponents.ITEM_SKIN)) {
                ItemSkinComponent weaveSkin = (ItemSkinComponent)weave.get(MalumDataComponents.ITEM_SKIN);
                if (weaveSkin.equals(target.get(MalumDataComponents.APPLIED_ITEM_SKIN))) {
                    return ItemStack.EMPTY;
                }
                result.set(MalumDataComponents.APPLIED_ITEM_SKIN, (Object)weaveSkin);
                return result;
            }
        }
        return ItemStack.EMPTY;
    }

    public Vec3 getItemPos() {
        return BlockPosHelper.fromBlockPos((BlockPos)this.getBlockPos()).add(this.itemOffset());
    }

    public Vec3 itemOffset() {
        return new Vec3(0.5, (double)1.35f, 0.5);
    }
}

