/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.weeping_well;

import com.sammy.malum.common.block.curiosities.weeping_well.PrimordialSoupBlock;
import com.sammy.malum.common.packets.CodecUtil;
import com.sammy.malum.common.recipe.void_favor.FavorOfTheVoidRecipe;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import com.sammy.malum.visual_effects.WeepingWellParticleEffects;
import com.sammy.malum.visual_effects.networked.weeping_well.WeepingWellReactionParticleEffect;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class VoidConduitBlockEntity
extends LodestoneBlockEntity {
    private static final int PROCESSING_TIME = 80;
    public final List<ItemStack> eatenItems = new ArrayList<ItemStack>();
    public int progress;
    public int streak;
    public boolean reachedStreakGoal;

    public VoidConduitBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MalumBlockEntities.VOID_CONDUIT.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        if (!this.eatenItems.isEmpty()) {
            compound.putInt("itemCount", this.eatenItems.size());
            for (int i = 0; i < this.eatenItems.size(); ++i) {
                ItemStack stack = this.eatenItems.get(i);
                CompoundTag itemTag = (CompoundTag)CodecUtil.encodeNBT(ItemStack.CODEC, stack);
                compound.put("item_" + i, (Tag)itemTag);
            }
        }
        compound.putInt("progress", this.progress);
        compound.putInt("streak", this.streak);
        compound.putBoolean("reachedStreakGoal", this.reachedStreakGoal);
        super.saveAdditional(compound, registries);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.eatenItems.clear();
        for (int i = 0; i < compound.getInt("itemCount"); ++i) {
            CompoundTag itemTag = compound.getCompound("item_" + i);
            this.eatenItems.add((ItemStack)CodecUtil.decodeNBT(ItemStack.CODEC, (Tag)itemTag));
        }
        this.progress = compound.getInt("progress");
        this.streak = compound.getInt("streak");
        this.reachedStreakGoal = compound.getBoolean("reachedStreakGoal");
    }

    public void tick() {
        super.tick();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long gameTime = serverLevel.getGameTime();
            if (gameTime % 100L == 0L) {
                this.level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.UNCANNY_VALLEY.get(), SoundSource.HOSTILE, 1.0f, Mth.nextFloat((RandomSource)this.level.getRandom(), (float)0.55f, (float)1.75f));
            }
            if (gameTime % 20L == 0L) {
                this.level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.VOID_HEARTBEAT.get(), SoundSource.HOSTILE, 1.5f, Mth.nextFloat((RandomSource)this.level.getRandom(), (float)0.95f, (float)1.15f));
            }
            if (gameTime % 10L == 0L) {
                this.acceptItems(serverLevel);
            }
            if (!this.eatenItems.isEmpty()) {
                ++this.progress;
                if (this.progress >= 80) {
                    this.processItem(serverLevel);
                }
                if (this.eatenItems.isEmpty()) {
                    this.progress = 0;
                }
            } else if (this.streak != 0) {
                this.streak = 0;
            }
        } else {
            WeepingWellParticleEffects.passiveWeepingWellParticles(this);
        }
    }

    public void acceptItems(ServerLevel serverLevel) {
        AABB aabb = new AABB(this.worldPosition).inflate(1.0, 3.0, 1.0).move(0.0, -3.0, 0.0);
        List<ItemEntity> items = serverLevel.getEntitiesOfClass(ItemEntity.class, aabb).stream().sorted(Comparator.comparingInt(ItemEntity::getAge)).toList();
        for (ItemEntity entity : items) {
            if (!(entity.getInBlockState().getBlock() instanceof PrimordialSoupBlock)) continue;
            this.eatenItems.add(entity.getItem());
            entity.discard();
        }
        BlockStateHelper.updateAndNotifyState((Level)this.level, (BlockPos)this.worldPosition);
    }

    public void processItem(ServerLevel serverLevel) {
        WeepingWellReactionParticleEffect particleEffectType = MalumParticleEffectTypes.WEEPING_WELL_REACTS;
        ItemStack stack = this.eatenItems.getLast();
        if (stack.getItem().equals(MalumItems.BLIGHTED_GUNK.get())) {
            this.eatGunk(stack);
        } else {
            this.spitOutItem(stack);
        }
        this.progress = 60;
        this.eatenItems.removeLast();
        particleEffectType.createEffect(this.worldPosition.getCenter()).spawn(serverLevel);
        BlockStateHelper.updateAndNotifyState((Level)this.level, (BlockPos)this.worldPosition);
    }

    public void eatGunk(ItemStack stack) {
        this.streak += stack.getCount();
        if (this.streak >= 4096) {
            this.reachedStreakGoal = true;
        }
        this.level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.VOID_EATS_GUNK.get(), SoundSource.PLAYERS, 0.7f, RandomHelper.randomBetween((RandomSource)this.level.getRandom(), (float)0.5f, (float)2.0f));
        this.level.playSound(null, this.worldPosition, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.7f, RandomHelper.randomBetween((RandomSource)this.level.getRandom(), (float)0.5f, (float)2.0f));
    }

    public void spitOutItem(ItemStack stack) {
        FavorOfTheVoidRecipe recipe = (FavorOfTheVoidRecipe)LodestoneRecipeType.getRecipe((Level)this.level, (RecipeType)((RecipeType)MalumRecipeTypes.VOID_FAVOR.get()), (RecipeInput)new SingleRecipeInput(stack));
        float pitch = RandomHelper.randomBetween((RandomSource)this.level.getRandom(), (float)0.8f, (float)1.3f);
        Vec3 outputPosition = this.worldPosition.getCenter();
        SoundEvent sound = (SoundEvent)MalumSoundEvents.VOID_REJECTION.get();
        ItemStack outputStack = stack.copy();
        if (recipe != null) {
            outputStack = recipe.output.copyWithCount(stack.getCount());
            sound = (SoundEvent)MalumSoundEvents.VOID_TRANSMUTATION.get();
        }
        ItemEntity entity = new ItemEntity(this.level, outputPosition.x, outputPosition.y, outputPosition.z, outputStack);
        entity.setDeltaMovement(0.0, (double)0.65f, (double)0.15f);
        this.level.addFreshEntity((Entity)entity);
        this.level.playSound(null, this.worldPosition, sound, SoundSource.HOSTILE, 2.0f, pitch);
    }
}

