/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.nature;

import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import team.lodestar.lodestone.systems.block.LodestoneLogBlock;

public class MalumLogBLock
extends LodestoneLogBlock {
    private final boolean isCorrupt;

    public MalumLogBLock(BlockBehaviour.Properties properties, Supplier<Block> stripped, boolean isCorrupt) {
        super(properties, stripped);
        this.isCorrupt = isCorrupt;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item item = stack.getItem();
        if (item instanceof SpiritShardItem) {
            SpiritShardItem item2 = (SpiritShardItem)item;
            if (hit.getDirection().equals((Object)Direction.UP) || hit.getDirection().equals((Object)Direction.DOWN)) {
                return ItemInteractionResult.FAIL;
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                boolean success = this.createTotemPole(serverLevel, pos, player, handIn, hit, stack, item2);
                if (success) {
                    return ItemInteractionResult.SUCCESS;
                }
            } else {
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, handIn, hit);
    }

    public boolean createTotemPole(ServerLevel level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, ItemStack stack, SpiritShardItem spirit) {
        if (spirit.type.equals(MalumSpiritTypes.UMBRAL_SPIRIT)) {
            return false;
        }
        level.setBlockAndUpdate(pos, spirit.type.getTotemPoleBlockState(this.isCorrupt, hit));
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TotemPoleBlockEntity) {
            TotemPoleBlockEntity blockEntity2 = (TotemPoleBlockEntity)blockEntity;
            blockEntity2.setSpirit(level, spirit.type);
        }
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        level.levelEvent(2001, pos, Block.getId((BlockState)level.getBlockState(pos)));
        player.swing(handIn, true);
        return true;
    }
}

