/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.nature;

import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.visual_effects.networked.sap.SapCollectionParticleEffect;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;

public class SapFilledLogBlock
extends RotatedPillarBlock {
    public final Supplier<Block> drained;
    public final Supplier<Item> sap;
    public final List<ColorParticleData> sapColor;

    public SapFilledLogBlock(BlockBehaviour.Properties properties, Supplier<Block> drained, Supplier<Item> sap, Color ... sapColor) {
        super(properties);
        this.drained = drained;
        this.sap = sap;
        this.sapColor = Arrays.stream(sapColor).map(c -> ColorParticleData.create((Color)c).build()).toList();
    }

    protected ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (itemstack.getItem() == Items.GLASS_BOTTLE) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                itemstack.shrink(1);
                serverLevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)this.sap.get()));
                MalumParticleEffectTypes.SAP_COLLECTED.createEffect(pos).customData(new SapCollectionParticleEffect.SapCollectionEffectData(hit.getDirection(), player.getUUID())).color((List)this.sapColor).spawn(serverLevel);
                if (level.random.nextBoolean()) {
                    BlockStateHelper.setBlockStateWithExistingProperties((Level)level, (BlockPos)pos, (BlockState)this.drained.get().defaultBlockState(), (int)3);
                }
                this.collectSap(level, pos, player);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemstack, state, level, pos, player, handIn, hit);
    }

    public void collectSap(Level level, BlockPos pos, Player player) {
    }
}

