/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.common.packets.SyncSoulWardDataPayload;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.helpers.SoundHelper;

public class SoulWardData {
    public static Codec<SoulWardData> CODEC = RecordCodecBuilder.create(obj -> obj.group((App)Codec.DOUBLE.fieldOf("soulWard").forGetter(sw -> sw.soulWard), (App)Codec.DOUBLE.fieldOf("soulWardProgress").forGetter(sw -> sw.soulWardCooldown)).apply((Applicative)obj, SoulWardData::new));
    public static StreamCodec<ByteBuf, SoulWardData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    private double soulWard;
    private double soulWardCooldown;
    private boolean isDirty;

    public SoulWardData() {
    }

    public SoulWardData(double soulWard, double soulWardCooldown) {
        this.soulWard = soulWard;
        this.soulWardCooldown = soulWardCooldown;
    }

    public void tickData(LivingEntity living) {
        AttributeInstance capacity = living.getAttribute(MalumAttributes.SOUL_WARD_CAPACITY);
        if (capacity != null) {
            if (this.getSoulWard() < capacity.getValue()) {
                if (this.soulWardCooldown > 0.0) {
                    this.soulWardCooldown -= 1.0;
                }
                if (this.soulWardCooldown <= 0.0) {
                    this.recoverSoulWard(living, 1.0);
                }
            }
            if (this.getSoulWard() > capacity.getValue()) {
                this.setSoulWard(capacity.getValue());
            }
        }
        if (this.isDirty()) {
            if (!living.level().isClientSide) {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)living, (CustomPacketPayload)new SyncSoulWardDataPayload(living.getId(), this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.setDirty(false);
        }
    }

    public void recoverSoulWard(LivingEntity entity, double amount) {
        AttributeInstance capacity = entity.getAttribute(MalumAttributes.SOUL_WARD_CAPACITY);
        if (this.getSoulWard() < capacity.getValue()) {
            Player player;
            Double multiplier = Optional.ofNullable(entity.getAttribute(MalumAttributes.SOUL_WARD_RECOVERY_MULTIPLIER)).map(AttributeInstance::getValue).orElse(1.0);
            double previousSoulward = this.soulWard;
            this.addSoulWard(amount * multiplier);
            if (!(!(this.soulWard > previousSoulward) || entity instanceof Player && (player = (Player)entity).isCreative())) {
                DeferredHolder<SoundEvent, SoundEvent> sound = this.soulWard >= capacity.getValue() ? MalumSoundEvents.SOUL_WARD_CHARGE : MalumSoundEvents.SOUL_WARD_GROW;
                double pitchOffset = this.soulWard / capacity.getValue() * 0.5 + (double)((float)(Mth.ceil((double)this.soulWard) % 3) * 0.25f);
                SoundHelper.playSound((Entity)entity, (SoundEvent)((SoundEvent)sound.get()), (float)0.25f, (float)((float)(1.0 + pitchOffset)));
            }
        }
        this.addCooldown(entity, 1.0);
    }

    public void addSoulWard(double added) {
        this.setSoulWard(this.soulWard + added);
    }

    public void reduceSoulWard(double removed) {
        this.setSoulWard(this.soulWard - removed);
    }

    public void setSoulWard(double soulWard) {
        this.soulWard = Math.max(soulWard, 0.0);
        this.setDirty(true);
    }

    public double getSoulWard() {
        return this.soulWard;
    }

    public void addCooldown(LivingEntity living, double multiplier) {
        double newCooldown = (double)SoulWardData.getSoulWardCooldown(living) * multiplier;
        if (this.soulWardCooldown < newCooldown) {
            this.soulWardCooldown = newCooldown;
            this.setDirty(true);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public boolean isDepleted() {
        return this.soulWard <= 0.0;
    }

    public static float getSoulWardCooldown(LivingEntity living) {
        return SoulWardData.getSoulWardCooldown(living.getAttributeValue(MalumAttributes.SOUL_WARD_RECOVERY_RATE));
    }

    public static float getSoulWardCooldown(double recoverySpeed) {
        return Mth.floor((double)((double)((Integer)CommonConfig.SOUL_WARD_RATE.getConfigValue()).intValue() / recoverySpeed));
    }
}

