/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.activator;

import com.sammy.malum.common.entity.FloatingEntity;
import com.sammy.malum.common.entity.FloatingItemDestinationData;
import com.sammy.malum.core.handlers.SoulHarvestHandler;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.util.UUID;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class SpiritCollectionActivatorEntityOld
extends FloatingEntity {
    public TrailPointBuilder secondaryTrailPointBuilder = TrailPointBuilder.create((int)4);
    public TrailPointBuilder trinaryTrailPointBuilder = TrailPointBuilder.create((int)4);
    public float spinOffset = (float)((double)this.random.nextFloat() * Math.PI * 2.0);

    public SpiritCollectionActivatorEntityOld(Level level) {
        super((EntityType)MalumEntities.SPIRIT_COLLECTION_ACTIVATOR.get(), level);
        this.maxAge = 4000;
    }

    public SpiritCollectionActivatorEntityOld(Level level, UUID ownerUUID, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        this(level);
        this.setDestination(new FloatingItemDestinationData(ownerUUID));
        this.setPos(posX, posY, posZ);
        this.setDeltaMovement(velX, velY, velZ);
        this.maxAge = 800;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    @Override
    public void collect(ServerLevel level) {
        this.getDestination().getEntityCollector(level).ifPresent(SoulHarvestHandler::triggerSpiritCollection);
        SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)MalumSoundEvents.SPIRIT_PICKUP.get()), (float)0.3f, (float)Mth.nextFloat((RandomSource)this.random, (float)1.2f, (float)1.5f));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            float offsetScale = 0.1f + this.random.nextFloat() * 0.2f;
            for (int i = 0; i < 2; ++i) {
                float progress = (float)(i + 1) * 0.5f;
                Vec3 position = this.getPosition(progress).add(0.0, (double)this.getYOffset(progress), 0.0);
                float scalar = ((float)this.age + progress) / 6.0f;
                double xOffset = Math.cos(this.spinOffset + scalar) * (double)offsetScale;
                double zOffset = Math.sin(this.spinOffset + scalar) * (double)offsetScale;
                this.secondaryTrailPointBuilder.addTrailPoint(position.add(xOffset, 0.0, zOffset));
                xOffset = Math.cos(this.spinOffset + scalar + 3.14f) * (double)offsetScale;
                zOffset = Math.sin(this.spinOffset + scalar + 3.14f) * (double)offsetScale;
                this.trinaryTrailPointBuilder.addTrailPoint(position.add(xOffset, 0.0, zOffset));
            }
            this.secondaryTrailPointBuilder.tickTrailPoints();
            this.trinaryTrailPointBuilder.tickTrailPoints();
            Vec3 motion = this.getDeltaMovement();
            Vec3 norm = motion.normalize().scale((double)0.05f);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.level(), this.getOffsetPosition(), MalumSpiritTypes.UMBRAL_SPIRIT);
            lightSpecs.getBuilder().setMotion(norm);
            lightSpecs.getBloomBuilder().setMotion(norm);
            lightSpecs.spawnParticles();
        }
    }

    @Override
    public int getWindUpDuration() {
        return 25;
    }

    @Override
    public float getMotionEasingRatio(float windUpDelta, float distance) {
        return super.getMotionEasingRatio(windUpDelta, distance) * 4.0f;
    }

    @Override
    public float getFriction() {
        return 0.9f;
    }
}

