/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.nitrate;

import com.sammy.malum.common.entity.nitrate.NitrateExplosion;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.nitrate.NitrateImpactParticleEffectType;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.rendering.trail.TrailPoint;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public abstract class AbstractNitrateEntity
extends ThrowableProjectile {
    protected static final EntityDataAccessor<Boolean> DATA_FADING_AWAY = SynchedEntityData.defineId(AbstractNitrateEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final int MAX_AGE = 1200;
    public static final Color SECOND_SMOKE_COLOR = new Color(30, 30, 30);
    public static final float MAIN_TRAIL_LENGTH = 12.0f;
    public final TrailPointBuilder trailPointBuilder = TrailPointBuilder.create((int)12);
    public final TrailPointBuilder spinningTrailPointBuilder = TrailPointBuilder.create((int)6);
    public float spinOffset = (float)((double)this.random.nextFloat() * Math.PI * 2.0);
    public int age;
    public int timesExploded;
    public boolean fadingAway;

    public AbstractNitrateEntity(EntityType<? extends AbstractNitrateEntity> type, Level level) {
        super(type, level);
    }

    public AbstractNitrateEntity(EntityType<? extends AbstractNitrateEntity> type, LivingEntity owner, Level level) {
        super(type, owner, level);
    }

    public void onExplode() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void spawnParticles();

    public abstract int getMaxPierce();

    public abstract float getExplosionRadius();

    public abstract NitrateImpactParticleEffectType getImpactParticleEffect();

    public abstract MalumNetworkedParticleEffectColorData getImpactParticleEffectColor();

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_FADING_AWAY, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (DATA_FADING_AWAY.equals(pKey)) {
            this.fadingAway = (Boolean)this.entityData.get(DATA_FADING_AWAY);
            if (this.fadingAway) {
                this.age = 1180;
            }
        }
        super.onSyncedDataUpdated(pKey);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.age != 0) {
            compound.putInt("age", this.age);
        }
        if (this.timesExploded != 0) {
            compound.putInt("timesExploded", this.timesExploded);
        }
        if (this.fadingAway) {
            compound.putBoolean("fadingAway", true);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.age = compound.getInt("age");
        this.timesExploded = compound.getInt("pierce");
        this.getEntityData().set(DATA_FADING_AWAY, (Object)compound.getBoolean("fadingAway"));
    }

    protected void onHit(HitResult pResult) {
        if (this.fadingAway) {
            return;
        }
        NitrateExplosion.explode(this.level(), (Entity)this, this.getX(), this.getY(0.0625), this.getZ(), this.getExplosionRadius());
        this.onExplode();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.getImpactParticleEffect().createEffect(this.position()).color(this.getImpactParticleEffectColor()).spawn(serverLevel);
        }
        if (this.timesExploded++ >= this.getMaxPierce()) {
            this.getEntityData().set(DATA_FADING_AWAY, (Object)true);
            this.setDeltaMovement(this.getDeltaMovement().scale((double)0.05f));
        }
        super.onHit(pResult);
    }

    public void tick() {
        int i;
        super.tick();
        Vec3 motion = this.getDeltaMovement();
        if (!this.fadingAway) {
            this.setDeltaMovement(motion.x * (double)0.99f, (motion.y - (double)0.015f) * (double)0.99f, motion.z * (double)0.99f);
        }
        float radialOffsetScale = this.fadingAway ? 0.0f : 0.15f;
        float randomOffsetScale = this.age > 5 ? Math.min((float)(this.age - 5) * 0.02f, 0.2f) : 0.0f;
        for (i = 0; i < 2; ++i) {
            float progress = (float)i * 0.5f;
            final Vec3 position = this.getPosition(progress);
            final Vec3 randomizedPosition = position.add((double)(this.random.nextFloat() * randomOffsetScale), (double)(this.random.nextFloat() * randomOffsetScale), (double)(this.random.nextFloat() * randomOffsetScale));
            this.trailPointBuilder.addTrailPoint(new TrailPoint(this, position, i){

                public Vec3 getPosition() {
                    return new Vec3(Mth.lerp((double)((float)this.getAge() / 12.0f), (double)position.x, (double)randomizedPosition.x), Mth.lerp((double)((float)this.getAge() / 12.0f), (double)position.y, (double)randomizedPosition.y), Mth.lerp((double)((float)this.getAge() / 12.0f), (double)position.z, (double)randomizedPosition.z));
                }
            });
            this.spinningTrailPointBuilder.addTrailPoint(new TrailPoint(position.add(Math.cos(this.spinOffset + ((float)this.age + progress) / 2.0f) * (double)radialOffsetScale, 0.0, Math.sin(this.spinOffset + ((float)this.age + progress) / 2.0f) * (double)radialOffsetScale), i));
        }
        for (i = 0; i < (this.fadingAway || this.age > 1180 ? 2 : 1); ++i) {
            this.trailPointBuilder.tickTrailPoints();
            this.spinningTrailPointBuilder.tickTrailPoints();
        }
        ++this.age;
        if (this.age > 1200) {
            this.discard();
        }
        if (this.level().isClientSide && !this.fadingAway && this.age > 1) {
            this.spawnParticles();
        }
    }

    public float getVisualEffectScalar() {
        float effectScalar;
        float f = effectScalar = this.fadingAway ? 1.0f - (float)(this.age - 1200 + 10) / 10.0f : 1.0f;
        if (this.age < 5) {
            effectScalar = (float)this.age / 5.0f;
        }
        return effectScalar;
    }

    public boolean isInWater() {
        return false;
    }

    public boolean isNoGravity() {
        return true;
    }

    public float getPickRadius() {
        return 4.0f;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }
}

